/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.function;

import com.github.dm.jrt.function.BiConsumer;
import com.github.dm.jrt.util.Reflection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiConsumerWrapper<IN1, IN2>
implements BiConsumer<IN1, IN2> {
    private static final BiConsumerWrapper<Object, Object> sBiSink = new BiConsumerWrapper(new BiConsumer<Object, Object>(){

        @Override
        public void accept(Object in1, Object in2) {
        }
    });
    private final List<BiConsumer<?, ?>> mConsumers;

    BiConsumerWrapper(@NotNull BiConsumer<?, ?> consumer) {
        this(Collections.singletonList(consumer));
        if (consumer == null) {
            throw new NullPointerException("the consumer instance must not be null");
        }
    }

    private BiConsumerWrapper(@NotNull List<BiConsumer<?, ?>> consumers) {
        this.mConsumers = consumers;
    }

    @NotNull
    public static <IN1, IN2> BiConsumerWrapper<IN1, IN2> biSink() {
        return sBiSink;
    }

    @NotNull
    public BiConsumerWrapper<IN1, IN2> andThen(@NotNull BiConsumer<? super IN1, ? super IN2> after) {
        Class<?> consumerClass = after.getClass();
        List<BiConsumer<?, ?>> consumers = this.mConsumers;
        ArrayList newConsumers = new ArrayList(consumers.size() + 1);
        newConsumers.addAll(consumers);
        if (consumerClass == BiConsumerWrapper.class) {
            newConsumers.addAll(((BiConsumerWrapper)after).mConsumers);
        } else {
            newConsumers.add(after);
        }
        return new BiConsumerWrapper<IN1, IN2>(newConsumers);
    }

    public boolean hasStaticContext() {
        for (BiConsumer<?, ?> consumer : this.mConsumers) {
            if (Reflection.hasStaticContext(consumer.getClass())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.mConsumers.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BiConsumerWrapper that = (BiConsumerWrapper)o;
        return this.mConsumers.equals(that.mConsumers);
    }

    @Override
    public void accept(IN1 in1, IN2 in2) {
        for (BiConsumer<?, ?> consumer : this.mConsumers) {
            consumer.accept(in1, in2);
        }
    }
}

