/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.function;

import com.github.dm.jrt.function.BiFunction;
import com.github.dm.jrt.function.Function;
import com.github.dm.jrt.function.FunctionWrapper;
import com.github.dm.jrt.util.Reflection;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiFunctionWrapper<IN1, IN2, OUT>
implements BiFunction<IN1, IN2, OUT> {
    private static final BiFunctionWrapper<Object, Object, Object> sFirst = new BiFunctionWrapper(new BiFunction<Object, Object, Object>(){

        @Override
        public Object apply(Object in1, Object in2) {
            return in1;
        }
    });
    private static final BiFunctionWrapper<Object, Object, Object> sSecond = new BiFunctionWrapper(new BiFunction<Object, Object, Object>(){

        @Override
        public Object apply(Object in1, Object in2) {
            return in2;
        }
    });
    private final BiFunction<IN1, IN2, ?> mBiFunction;
    private final FunctionWrapper<?, OUT> mFunction;

    BiFunctionWrapper(@NotNull BiFunction<IN1, IN2, ?> biFunction) {
        this(biFunction, FunctionWrapper.identity());
        if (biFunction == null) {
            throw new NullPointerException("the bi-function instance must not be null");
        }
    }

    private BiFunctionWrapper(@NotNull BiFunction<IN1, IN2, ?> biFunction, @NotNull FunctionWrapper<?, OUT> function) {
        this.mBiFunction = biFunction;
        this.mFunction = function;
    }

    @NotNull
    public static <IN1, IN2> BiFunctionWrapper<IN1, IN2, IN1> first() {
        return sFirst;
    }

    @NotNull
    public static <IN1, IN2> BiFunctionWrapper<IN1, IN2, IN2> second() {
        return sSecond;
    }

    @NotNull
    public <AFTER> BiFunctionWrapper<IN1, IN2, AFTER> andThen(@NotNull Function<? super OUT, AFTER> after) {
        return new BiFunctionWrapper<IN1, IN2, AFTER>(this.mBiFunction, this.mFunction.andThen(after));
    }

    public boolean hasStaticContext() {
        BiFunction<IN1, IN2, ?> biFunction = this.mBiFunction;
        return Reflection.hasStaticContext(biFunction.getClass()) && this.mFunction.hasStaticContext();
    }

    public int hashCode() {
        int result = this.mBiFunction.hashCode();
        result = 31 * result + this.mFunction.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BiFunctionWrapper that = (BiFunctionWrapper)o;
        return this.mBiFunction.equals(that.mBiFunction) && this.mFunction.equals(that.mFunction);
    }

    @Override
    public OUT apply(IN1 in1, IN2 in2) {
        return this.mFunction.apply(this.mBiFunction.apply(in1, in2));
    }
}

