/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.function;

import com.github.dm.jrt.function.Consumer;
import com.github.dm.jrt.util.Reflection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerWrapper<IN>
implements Consumer<IN> {
    private static final ConsumerWrapper<Object> sSink = new ConsumerWrapper(new Consumer<Object>(){

        @Override
        public void accept(Object in) {
        }
    });
    private final List<Consumer<?>> mConsumers;

    ConsumerWrapper(@NotNull Consumer<?> consumer) {
        this(Collections.singletonList(consumer));
        if (consumer == null) {
            throw new NullPointerException("the consumer instance must not be null");
        }
    }

    private ConsumerWrapper(@NotNull List<Consumer<?>> consumers) {
        this.mConsumers = consumers;
    }

    @NotNull
    public static <IN> ConsumerWrapper<IN> sink() {
        return sSink;
    }

    @NotNull
    public ConsumerWrapper<IN> andThen(@NotNull Consumer<? super IN> after) {
        Class<?> consumerClass = after.getClass();
        List<Consumer<?>> consumers = this.mConsumers;
        ArrayList newConsumers = new ArrayList(consumers.size() + 1);
        newConsumers.addAll(consumers);
        if (consumerClass == ConsumerWrapper.class) {
            newConsumers.addAll(((ConsumerWrapper)after).mConsumers);
        } else {
            newConsumers.add(after);
        }
        return new ConsumerWrapper<IN>(newConsumers);
    }

    public boolean hasStaticContext() {
        for (Consumer<?> consumer : this.mConsumers) {
            if (Reflection.hasStaticContext(consumer.getClass())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.mConsumers.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerWrapper that = (ConsumerWrapper)o;
        return this.mConsumers.equals(that.mConsumers);
    }

    @Override
    public void accept(IN in) {
        for (Consumer<?> consumer : this.mConsumers) {
            consumer.accept(in);
        }
    }
}

