/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.function;

import com.github.dm.jrt.function.Function;
import com.github.dm.jrt.util.ClassToken;
import com.github.dm.jrt.util.Reflection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionWrapper<IN, OUT>
implements Function<IN, OUT> {
    private static final FunctionWrapper<Object, Object> sIdentity = new FunctionWrapper(new Function<Object, Object>(){

        @Override
        public Object apply(Object in) {
            return in;
        }
    });
    private final List<Function<?, ?>> mFunctions;

    FunctionWrapper(@NotNull Function<?, ?> function) {
        this(Collections.singletonList(function));
        if (function == null) {
            throw new NullPointerException("the function instance must not be null");
        }
    }

    private FunctionWrapper(@NotNull List<Function<?, ?>> functions) {
        this.mFunctions = functions;
    }

    @NotNull
    public static <IN, OUT> FunctionWrapper<IN, OUT> castTo(@NotNull Class<? extends OUT> type) {
        if (type == null) {
            throw new NullPointerException("the type must not be null");
        }
        return new FunctionWrapper<IN, OUT>(new ClassCastFunction(type));
    }

    @NotNull
    public static <IN, OUT> FunctionWrapper<IN, OUT> castTo(@NotNull ClassToken<? extends OUT> token) {
        return FunctionWrapper.castTo(token.getRawClass());
    }

    @NotNull
    public static <IN> FunctionWrapper<IN, IN> identity() {
        return sIdentity;
    }

    @NotNull
    public <AFTER> FunctionWrapper<IN, AFTER> andThen(@NotNull Function<? super OUT, AFTER> after) {
        Class<?> functionClass = after.getClass();
        List<Function<?, ?>> functions = this.mFunctions;
        ArrayList newFunctions = new ArrayList(functions.size() + 1);
        newFunctions.addAll(functions);
        if (functionClass == FunctionWrapper.class) {
            newFunctions.addAll(((FunctionWrapper)after).mFunctions);
        } else {
            newFunctions.add(after);
        }
        return new FunctionWrapper<IN, OUT>(newFunctions);
    }

    @NotNull
    public <BEFORE> FunctionWrapper<BEFORE, OUT> compose(@NotNull Function<BEFORE, ? extends IN> before) {
        Class<?> functionClass = before.getClass();
        List<Function<?, ?>> functions = this.mFunctions;
        ArrayList newFunctions = new ArrayList(functions.size() + 1);
        if (functionClass == FunctionWrapper.class) {
            newFunctions.addAll(((FunctionWrapper)before).mFunctions);
        } else {
            newFunctions.add(before);
        }
        newFunctions.addAll(functions);
        return new FunctionWrapper<IN, OUT>(newFunctions);
    }

    public boolean hasStaticContext() {
        for (Function<?, ?> function : this.mFunctions) {
            if (Reflection.hasStaticContext(function.getClass())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.mFunctions.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionWrapper that = (FunctionWrapper)o;
        return this.mFunctions.equals(that.mFunctions);
    }

    @Override
    public OUT apply(IN in) {
        Object result = in;
        for (Function<?, ?> function : this.mFunctions) {
            result = function.apply(result);
        }
        return (OUT)result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassCastFunction<IN, OUT>
    implements Function<IN, OUT> {
        private final Class<? extends OUT> mType;

        private ClassCastFunction(@NotNull Class<? extends OUT> type) {
            this.mType = type;
        }

        @Override
        public OUT apply(IN in) {
            return this.mType.cast(in);
        }

        public int hashCode() {
            return this.mType.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassCastFunction that = (ClassCastFunction)o;
            return this.mType.equals(that.mType);
        }
    }
}

