/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.function;

import com.github.dm.jrt.channel.ResultChannel;
import com.github.dm.jrt.channel.RoutineException;
import com.github.dm.jrt.function.BiConsumer;
import com.github.dm.jrt.function.BiConsumerWrapper;
import com.github.dm.jrt.function.BiFunction;
import com.github.dm.jrt.function.BiFunctionWrapper;
import com.github.dm.jrt.function.Consumer;
import com.github.dm.jrt.function.ConsumerWrapper;
import com.github.dm.jrt.function.Function;
import com.github.dm.jrt.function.FunctionWrapper;
import com.github.dm.jrt.function.OutputConsumerBuilder;
import com.github.dm.jrt.function.Predicate;
import com.github.dm.jrt.function.PredicateWrapper;
import com.github.dm.jrt.function.Supplier;
import com.github.dm.jrt.function.SupplierWrapper;
import com.github.dm.jrt.invocation.CommandInvocation;
import com.github.dm.jrt.invocation.FilterInvocation;
import com.github.dm.jrt.invocation.FunctionInvocation;
import com.github.dm.jrt.invocation.Invocation;
import com.github.dm.jrt.invocation.InvocationFactory;
import com.github.dm.jrt.util.ClassToken;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Functions {
    protected Functions() {
    }

    @NotNull
    public static <IN1, IN2> BiConsumerWrapper<IN1, IN2> biSink() {
        return BiConsumerWrapper.biSink();
    }

    @NotNull
    public static <IN, OUT> FunctionWrapper<IN, OUT> castTo(@NotNull Class<? extends OUT> type) {
        return FunctionWrapper.castTo(type);
    }

    @NotNull
    public static <IN, OUT> FunctionWrapper<IN, OUT> castTo(@NotNull ClassToken<? extends OUT> token) {
        return FunctionWrapper.castTo(token);
    }

    @NotNull
    public static <OUT> SupplierWrapper<OUT> constant(OUT result) {
        return SupplierWrapper.constant(result);
    }

    @NotNull
    public static <OUT> CommandInvocation<OUT> consumerCommand(@NotNull Consumer<? super ResultChannel<OUT>> consumer) {
        return new ConsumerCommandInvocation(Functions.wrapConsumer(consumer));
    }

    @NotNull
    public static <IN, OUT> InvocationFactory<IN, OUT> consumerFactory(@NotNull BiConsumer<? super List<? extends IN>, ? super ResultChannel<OUT>> consumer) {
        return new ConsumerInvocationFactory(Functions.wrapBiConsumer(consumer));
    }

    @NotNull
    public static <IN, OUT> FilterInvocation<IN, OUT> consumerFilter(@NotNull BiConsumer<? super IN, ? super ResultChannel<OUT>> consumer) {
        return new ConsumerFilterInvocation(Functions.wrapBiConsumer(consumer));
    }

    @NotNull
    public static <IN1, IN2> BiFunctionWrapper<IN1, IN2, IN1> first() {
        return BiFunctionWrapper.first();
    }

    @NotNull
    public static <IN, OUT> InvocationFactory<IN, OUT> functionFactory(@NotNull Function<? super List<? extends IN>, OUT> function) {
        return new FunctionInvocationFactory(Functions.wrapFunction(function));
    }

    @NotNull
    public static <IN, OUT> FilterInvocation<IN, OUT> functionFilter(@NotNull Function<? super IN, OUT> function) {
        return new FunctionFilterInvocation(Functions.wrapFunction(function));
    }

    @NotNull
    public static <IN> FunctionWrapper<IN, IN> identity() {
        return FunctionWrapper.identity();
    }

    @NotNull
    public static <IN> PredicateWrapper<IN> isEqual(@Nullable Object targetRef) {
        return PredicateWrapper.isEqual(targetRef);
    }

    @NotNull
    public static <IN> PredicateWrapper<IN> isInstanceOf(@NotNull Class<?> type) {
        return PredicateWrapper.isInstanceOf(type);
    }

    @NotNull
    public static <IN> PredicateWrapper<IN> isNull() {
        return PredicateWrapper.isNull();
    }

    @NotNull
    public static <IN> PredicateWrapper<IN> isSame(@Nullable Object targetRef) {
        return PredicateWrapper.isSame(targetRef);
    }

    @NotNull
    public static <IN> PredicateWrapper<IN> negative() {
        return PredicateWrapper.negative();
    }

    @NotNull
    public static <IN> PredicateWrapper<IN> notNull() {
        return PredicateWrapper.notNull();
    }

    @NotNull
    public static OutputConsumerBuilder<Object> onComplete(@NotNull Consumer<Void> consumer) {
        return new OutputConsumerBuilder<Object>(Functions.wrapConsumer(consumer), Functions.<RoutineException>sink(), Functions.sink());
    }

    @NotNull
    public static OutputConsumerBuilder<Object> onError(@NotNull Consumer<RoutineException> consumer) {
        return new OutputConsumerBuilder<Object>(Functions.<Void>sink(), Functions.wrapConsumer(consumer), Functions.sink());
    }

    @NotNull
    public static <OUT> OutputConsumerBuilder<OUT> onOutput(@NotNull Consumer<OUT> consumer) {
        return new OutputConsumerBuilder<OUT>(Functions.<Void>sink(), Functions.<RoutineException>sink(), Functions.wrapConsumer(consumer));
    }

    @NotNull
    public static <IN> PredicateWrapper<IN> positive() {
        return PredicateWrapper.positive();
    }

    @NotNull
    public static <IN> FilterInvocation<IN, IN> predicateFilter(@NotNull Predicate<? super IN> predicate) {
        return new PredicateFilterInvocation(Functions.wrapPredicate(predicate));
    }

    @NotNull
    public static <IN1, IN2> BiFunctionWrapper<IN1, IN2, IN2> second() {
        return BiFunctionWrapper.second();
    }

    @NotNull
    public static <IN> ConsumerWrapper<IN> sink() {
        return ConsumerWrapper.sink();
    }

    @NotNull
    public static <OUT> CommandInvocation<OUT> supplierCommand(@NotNull Supplier<OUT> supplier) {
        return new SupplierCommandInvocation<OUT>(Functions.wrapSupplier(supplier));
    }

    @NotNull
    public static <IN, OUT> InvocationFactory<IN, OUT> supplierFactory(@NotNull Supplier<? extends Invocation<IN, OUT>> supplier) {
        return new SupplierInvocationFactory(Functions.wrapSupplier(supplier));
    }

    @NotNull
    public static <IN1, IN2> BiConsumerWrapper<IN1, IN2> wrapBiConsumer(@NotNull BiConsumer<IN1, IN2> consumer) {
        if (consumer.getClass() == BiConsumerWrapper.class) {
            return (BiConsumerWrapper)consumer;
        }
        return new BiConsumerWrapper(consumer);
    }

    @NotNull
    public static <IN1, IN2, OUT> BiFunctionWrapper<IN1, IN2, OUT> wrapBiFunction(@NotNull BiFunction<IN1, IN2, OUT> function) {
        if (function.getClass() == BiFunctionWrapper.class) {
            return (BiFunctionWrapper)function;
        }
        return new BiFunctionWrapper(function);
    }

    @NotNull
    public static <IN> ConsumerWrapper<IN> wrapConsumer(@NotNull Consumer<IN> consumer) {
        if (consumer.getClass() == ConsumerWrapper.class) {
            return (ConsumerWrapper)consumer;
        }
        return new ConsumerWrapper(consumer);
    }

    @NotNull
    public static <IN, OUT> FunctionWrapper<IN, OUT> wrapFunction(@NotNull Function<IN, OUT> function) {
        if (function.getClass() == FunctionWrapper.class) {
            return (FunctionWrapper)function;
        }
        return new FunctionWrapper(function);
    }

    @NotNull
    public static <IN> PredicateWrapper<IN> wrapPredicate(@NotNull Predicate<IN> predicate) {
        if (predicate.getClass() == PredicateWrapper.class) {
            return (PredicateWrapper)predicate;
        }
        return new PredicateWrapper<IN>(predicate);
    }

    @NotNull
    public static <OUT> SupplierWrapper<OUT> wrapSupplier(@NotNull Supplier<OUT> supplier) {
        if (supplier.getClass() == SupplierWrapper.class) {
            return (SupplierWrapper)supplier;
        }
        return new SupplierWrapper(supplier);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SupplierInvocationFactory<IN, OUT>
    extends InvocationFactory<IN, OUT> {
        private final SupplierWrapper<? extends Invocation<IN, OUT>> mSupplier;

        private SupplierInvocationFactory(@NotNull SupplierWrapper<? extends Invocation<IN, OUT>> supplier) {
            if (!supplier.hasStaticContext()) {
                throw new IllegalArgumentException("the supplier class must have a static context: " + supplier.getClass());
            }
            this.mSupplier = supplier;
        }

        @Override
        @NotNull
        public Invocation<IN, OUT> newInvocation() {
            return this.mSupplier.get();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SupplierInvocationFactory)) {
                return false;
            }
            SupplierInvocationFactory that = (SupplierInvocationFactory)o;
            return this.mSupplier.equals(that.mSupplier);
        }

        public int hashCode() {
            return this.mSupplier.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SupplierCommandInvocation<OUT>
    extends CommandInvocation<OUT> {
        private final SupplierWrapper<OUT> mSupplier;

        public SupplierCommandInvocation(@NotNull SupplierWrapper<OUT> supplier) {
            if (!supplier.hasStaticContext()) {
                throw new IllegalArgumentException("the supplier class must have a static context: " + supplier.getClass());
            }
            this.mSupplier = supplier;
        }

        public int hashCode() {
            return this.mSupplier.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SupplierCommandInvocation)) {
                return false;
            }
            SupplierCommandInvocation that = (SupplierCommandInvocation)o;
            return this.mSupplier.equals(that.mSupplier);
        }

        @Override
        public void onResult(@NotNull ResultChannel<OUT> result) {
            result.pass(this.mSupplier.get());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PredicateFilterInvocation<IN>
    extends FilterInvocation<IN, IN> {
        private final PredicateWrapper<? super IN> mPredicate;

        private PredicateFilterInvocation(@NotNull PredicateWrapper<? super IN> predicate) {
            if (!predicate.hasStaticContext()) {
                throw new IllegalArgumentException("the predicate class must have a static context: " + predicate.getClass());
            }
            this.mPredicate = predicate;
        }

        public int hashCode() {
            return this.mPredicate.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PredicateFilterInvocation)) {
                return false;
            }
            PredicateFilterInvocation that = (PredicateFilterInvocation)o;
            return this.mPredicate.equals(that.mPredicate);
        }

        @Override
        public void onInput(IN input, @NotNull ResultChannel<IN> result) {
            if (this.mPredicate.test(input)) {
                result.pass(input);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FunctionInvocationFactory<IN, OUT>
    extends InvocationFactory<IN, OUT> {
        private final FunctionWrapper<? super List<? extends IN>, OUT> mFunction;
        private final FunctionInvocation<IN, OUT> mInvocation;

        private FunctionInvocationFactory(final @NotNull FunctionWrapper<? super List<? extends IN>, OUT> function) {
            if (!function.hasStaticContext()) {
                throw new IllegalArgumentException("the function class must have a static context: " + function.getClass());
            }
            this.mFunction = function;
            this.mInvocation = new FunctionInvocation<IN, OUT>(){

                @Override
                protected void onCall(@NotNull List<? extends IN> inputs, @NotNull ResultChannel<OUT> result) {
                    result.pass(function.apply(inputs));
                }
            };
        }

        @Override
        @NotNull
        public Invocation<IN, OUT> newInvocation() {
            return this.mInvocation;
        }

        public int hashCode() {
            return this.mFunction.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FunctionInvocationFactory)) {
                return false;
            }
            FunctionInvocationFactory that = (FunctionInvocationFactory)o;
            return this.mFunction.equals(that.mFunction);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FunctionFilterInvocation<IN, OUT>
    extends FilterInvocation<IN, OUT> {
        private final FunctionWrapper<? super IN, OUT> mFunction;

        private FunctionFilterInvocation(@NotNull FunctionWrapper<? super IN, OUT> function) {
            if (!function.hasStaticContext()) {
                throw new IllegalArgumentException("the function class must have a static context: " + function.getClass());
            }
            this.mFunction = function;
        }

        public int hashCode() {
            return this.mFunction.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FunctionFilterInvocation)) {
                return false;
            }
            FunctionFilterInvocation that = (FunctionFilterInvocation)o;
            return this.mFunction.equals(that.mFunction);
        }

        @Override
        public void onInput(IN input, @NotNull ResultChannel<OUT> result) {
            result.pass(this.mFunction.apply(input));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConsumerInvocationFactory<IN, OUT>
    extends InvocationFactory<IN, OUT> {
        private final BiConsumerWrapper<? super List<? extends IN>, ? super ResultChannel<OUT>> mConsumer;
        private final FunctionInvocation<IN, OUT> mInvocation;

        private ConsumerInvocationFactory(final @NotNull BiConsumerWrapper<? super List<? extends IN>, ? super ResultChannel<OUT>> consumer) {
            if (!consumer.hasStaticContext()) {
                throw new IllegalArgumentException("the bi-consumer class must have a static context: " + consumer.getClass());
            }
            this.mConsumer = consumer;
            this.mInvocation = new FunctionInvocation<IN, OUT>(){

                @Override
                protected void onCall(@NotNull List<? extends IN> inputs, @NotNull ResultChannel<OUT> result) {
                    consumer.accept(inputs, result);
                }
            };
        }

        @Override
        @NotNull
        public Invocation<IN, OUT> newInvocation() {
            return this.mInvocation;
        }

        public int hashCode() {
            return this.mConsumer.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConsumerInvocationFactory)) {
                return false;
            }
            ConsumerInvocationFactory that = (ConsumerInvocationFactory)o;
            return this.mConsumer.equals(that.mConsumer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConsumerFilterInvocation<IN, OUT>
    extends FilterInvocation<IN, OUT> {
        private final BiConsumerWrapper<? super IN, ? super ResultChannel<OUT>> mConsumer;

        private ConsumerFilterInvocation(@NotNull BiConsumerWrapper<? super IN, ? super ResultChannel<OUT>> consumer) {
            if (!consumer.hasStaticContext()) {
                throw new IllegalArgumentException("the bi-consumer class must have a static context: " + consumer.getClass());
            }
            this.mConsumer = consumer;
        }

        @Override
        public void onInput(IN input, @NotNull ResultChannel<OUT> result) {
            this.mConsumer.accept(input, result);
        }

        public int hashCode() {
            return this.mConsumer.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConsumerFilterInvocation)) {
                return false;
            }
            ConsumerFilterInvocation that = (ConsumerFilterInvocation)o;
            return this.mConsumer.equals(that.mConsumer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConsumerCommandInvocation<OUT>
    extends CommandInvocation<OUT> {
        private final ConsumerWrapper<? super ResultChannel<OUT>> mConsumer;

        public ConsumerCommandInvocation(@NotNull ConsumerWrapper<? super ResultChannel<OUT>> consumer) {
            if (!consumer.hasStaticContext()) {
                throw new IllegalArgumentException("the consumer class must have a static context: " + consumer.getClass());
            }
            this.mConsumer = consumer;
        }

        public int hashCode() {
            return this.mConsumer.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConsumerCommandInvocation)) {
                return false;
            }
            ConsumerCommandInvocation that = (ConsumerCommandInvocation)o;
            return this.mConsumer.equals(that.mConsumer);
        }

        @Override
        public void onResult(@NotNull ResultChannel<OUT> result) {
            this.mConsumer.accept(result);
        }
    }
}

