/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.function;

import com.github.dm.jrt.builder.InvocationConfiguration;
import com.github.dm.jrt.builder.RoutineBuilder;
import com.github.dm.jrt.channel.Channel;
import com.github.dm.jrt.channel.ResultChannel;
import com.github.dm.jrt.channel.RoutineException;
import com.github.dm.jrt.channel.StreamingChannel;
import com.github.dm.jrt.core.AbstractRoutine;
import com.github.dm.jrt.core.Channels;
import com.github.dm.jrt.core.DelegatingInvocation;
import com.github.dm.jrt.core.JRoutine;
import com.github.dm.jrt.function.AccumulateInvocation;
import com.github.dm.jrt.function.BiConsumer;
import com.github.dm.jrt.function.BiFunction;
import com.github.dm.jrt.function.Consumer;
import com.github.dm.jrt.function.Function;
import com.github.dm.jrt.function.FunctionalRoutine;
import com.github.dm.jrt.function.FunctionalRoutineBuilder;
import com.github.dm.jrt.function.Functions;
import com.github.dm.jrt.function.Predicate;
import com.github.dm.jrt.function.Supplier;
import com.github.dm.jrt.invocation.CommandInvocation;
import com.github.dm.jrt.invocation.Invocation;
import com.github.dm.jrt.invocation.InvocationFactory;
import com.github.dm.jrt.routine.Routine;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JFunctional {
    protected JFunctional() {
    }

    @NotNull
    public static FunctionalRoutineBuilder startRoutine() {
        return new DefaultFunctionalRoutineBuilder();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultFunctionalRoutineBuilder
    implements FunctionalRoutineBuilder,
    InvocationConfiguration.Configurable<FunctionalRoutineBuilder> {
        private InvocationConfiguration mConfiguration = InvocationConfiguration.DEFAULT_CONFIGURATION;

        private DefaultFunctionalRoutineBuilder() {
        }

        @Override
        @NotNull
        public <OUT> FunctionalRoutine<Void, OUT> from(@NotNull CommandInvocation<OUT> invocation) {
            return this.fromFactory(invocation, DelegatingInvocation.DelegationType.SYNC);
        }

        @Override
        @NotNull
        public <OUT> FunctionalRoutine<Void, OUT> from(@NotNull Consumer<? super ResultChannel<OUT>> consumer) {
            return this.fromFactory(Functions.consumerCommand(consumer), DelegatingInvocation.DelegationType.SYNC);
        }

        @Override
        @NotNull
        public <OUT> FunctionalRoutine<Void, OUT> from(@NotNull Supplier<OUT> supplier) {
            return this.fromFactory(Functions.supplierCommand(supplier), DelegatingInvocation.DelegationType.SYNC);
        }

        @Override
        @NotNull
        public <DATA> FunctionalRoutine<DATA, DATA> thenAsyncAccumulate(@NotNull BiFunction<? super DATA, ? super DATA, DATA> function) {
            return this.fromFactory(AccumulateInvocation.functionFactory(function), DelegatingInvocation.DelegationType.ASYNC);
        }

        @Override
        @NotNull
        public <DATA> FunctionalRoutine<DATA, DATA> thenAsyncFilter(@NotNull Predicate<? super DATA> predicate) {
            return this.fromFactory(Functions.predicateFilter(predicate), DelegatingInvocation.DelegationType.ASYNC);
        }

        @Override
        @NotNull
        public <IN, OUT> FunctionalRoutine<IN, OUT> thenAsyncMap(@NotNull BiConsumer<? super IN, ? super ResultChannel<OUT>> consumer) {
            return this.fromFactory(Functions.consumerFilter(consumer), DelegatingInvocation.DelegationType.ASYNC);
        }

        @Override
        @NotNull
        public <IN, OUT> FunctionalRoutine<IN, OUT> thenAsyncMap(@NotNull Function<? super IN, OUT> function) {
            return this.fromFactory(Functions.functionFilter(function), DelegatingInvocation.DelegationType.ASYNC);
        }

        @Override
        @NotNull
        public <IN, OUT> FunctionalRoutine<IN, OUT> thenAsyncMap(@NotNull InvocationFactory<IN, OUT> factory) {
            return this.fromFactory(factory, DelegatingInvocation.DelegationType.ASYNC);
        }

        @Override
        @NotNull
        public <IN, OUT> FunctionalRoutine<IN, OUT> thenAsyncMap(@NotNull Routine<IN, OUT> routine) {
            return new DefaultFunctionalRoutine(routine, DelegatingInvocation.DelegationType.ASYNC);
        }

        @Override
        @NotNull
        public <IN, OUT> FunctionalRoutine<IN, OUT> thenAsyncReduce(@NotNull BiConsumer<? super List<? extends IN>, ? super ResultChannel<OUT>> consumer) {
            return this.fromFactory(Functions.consumerFactory(consumer), DelegatingInvocation.DelegationType.ASYNC);
        }

        @Override
        @NotNull
        public <IN, OUT> FunctionalRoutine<IN, OUT> thenAsyncReduce(@NotNull Function<? super List<? extends IN>, OUT> function) {
            return this.fromFactory(Functions.functionFactory(function), DelegatingInvocation.DelegationType.ASYNC);
        }

        @Override
        @NotNull
        public <DATA> FunctionalRoutine<DATA, DATA> thenParallelFilter(@NotNull Predicate<? super DATA> predicate) {
            return this.fromFactory(Functions.predicateFilter(predicate), DelegatingInvocation.DelegationType.PARALLEL);
        }

        @Override
        @NotNull
        public <IN, OUT> FunctionalRoutine<IN, OUT> thenParallelMap(@NotNull BiConsumer<? super IN, ? super ResultChannel<OUT>> consumer) {
            return this.fromFactory(Functions.consumerFilter(consumer), DelegatingInvocation.DelegationType.PARALLEL);
        }

        @Override
        @NotNull
        public <IN, OUT> FunctionalRoutine<IN, OUT> thenParallelMap(@NotNull Function<? super IN, OUT> function) {
            return this.fromFactory(Functions.functionFilter(function), DelegatingInvocation.DelegationType.PARALLEL);
        }

        @Override
        @NotNull
        public <IN, OUT> FunctionalRoutine<IN, OUT> thenParallelMap(@NotNull InvocationFactory<IN, OUT> factory) {
            return this.fromFactory(factory, DelegatingInvocation.DelegationType.PARALLEL);
        }

        @Override
        @NotNull
        public <IN, OUT> FunctionalRoutine<IN, OUT> thenParallelMap(@NotNull Routine<IN, OUT> routine) {
            return new DefaultFunctionalRoutine(routine, DelegatingInvocation.DelegationType.PARALLEL);
        }

        @Override
        @NotNull
        public <DATA> FunctionalRoutine<DATA, DATA> thenSyncAccumulate(@NotNull BiFunction<? super DATA, ? super DATA, DATA> function) {
            return this.fromFactory(AccumulateInvocation.functionFactory(function), DelegatingInvocation.DelegationType.SYNC);
        }

        @Override
        @NotNull
        public <DATA> FunctionalRoutine<DATA, DATA> thenSyncFilter(@NotNull Predicate<? super DATA> predicate) {
            return this.fromFactory(Functions.predicateFilter(predicate), DelegatingInvocation.DelegationType.SYNC);
        }

        @Override
        @NotNull
        public <IN, OUT> FunctionalRoutine<IN, OUT> thenSyncMap(@NotNull BiConsumer<? super IN, ? super ResultChannel<OUT>> consumer) {
            return this.fromFactory(Functions.consumerFilter(consumer), DelegatingInvocation.DelegationType.SYNC);
        }

        @Override
        @NotNull
        public <IN, OUT> FunctionalRoutine<IN, OUT> thenSyncMap(@NotNull Function<? super IN, OUT> function) {
            return this.fromFactory(Functions.functionFilter(function), DelegatingInvocation.DelegationType.SYNC);
        }

        @Override
        @NotNull
        public <IN, OUT> FunctionalRoutine<IN, OUT> thenSyncMap(@NotNull InvocationFactory<IN, OUT> factory) {
            return this.fromFactory(factory, DelegatingInvocation.DelegationType.SYNC);
        }

        @Override
        @NotNull
        public <IN, OUT> FunctionalRoutine<IN, OUT> thenSyncMap(@NotNull Routine<IN, OUT> routine) {
            return new DefaultFunctionalRoutine(routine, DelegatingInvocation.DelegationType.SYNC);
        }

        @Override
        @NotNull
        public <IN, OUT> FunctionalRoutine<IN, OUT> thenSyncReduce(@NotNull BiConsumer<? super List<? extends IN>, ? super ResultChannel<OUT>> consumer) {
            return this.fromFactory(Functions.consumerFactory(consumer), DelegatingInvocation.DelegationType.SYNC);
        }

        @Override
        @NotNull
        public <IN, OUT> FunctionalRoutine<IN, OUT> thenSyncReduce(@NotNull Function<? super List<? extends IN>, OUT> function) {
            return this.fromFactory(Functions.functionFactory(function), DelegatingInvocation.DelegationType.SYNC);
        }

        @NotNull
        private <IN, OUT> FunctionalRoutine<IN, OUT> fromFactory(@NotNull InvocationFactory<IN, OUT> factory, @NotNull DelegatingInvocation.DelegationType delegationType) {
            return new DefaultFunctionalRoutine(((RoutineBuilder)JRoutine.on(factory).invocations().with(this.mConfiguration).set()).buildRoutine(), delegationType);
        }

        @Override
        @NotNull
        public InvocationConfiguration.Builder<? extends FunctionalRoutineBuilder> invocations() {
            return new InvocationConfiguration.Builder<FunctionalRoutineBuilder>(this, this.mConfiguration);
        }

        @Override
        @NotNull
        public FunctionalRoutineBuilder setConfiguration(@NotNull InvocationConfiguration configuration) {
            if (configuration == null) {
                throw new NullPointerException("the invocation configuration must not be null");
            }
            this.mConfiguration = configuration;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultFunctionalRoutine<IN, OUT>
    extends AbstractFunctionalRoutine<IN, OUT> {
        private final InvocationFactory<IN, OUT> mFactory;

        private DefaultFunctionalRoutine(@NotNull Routine<IN, OUT> routine, @NotNull DelegatingInvocation.DelegationType delegationType) {
            this.mFactory = DelegatingInvocation.factoryFrom(routine, delegationType);
        }

        @Override
        @NotNull
        protected <AFTER> FunctionalRoutine<IN, AFTER> andThen(@NotNull Routine<? super OUT, AFTER> routine, @NotNull DelegatingInvocation.DelegationType delegationType) {
            return new AfterFunctionalRoutine(this, routine, delegationType);
        }

        @Override
        @NotNull
        protected Invocation<IN, OUT> newInvocation(@NotNull AbstractRoutine.InvocationType type) {
            return this.mFactory.newInvocation();
        }

        @Override
        @NotNull
        public <BEFORE, AFTER> FunctionalRoutine<BEFORE, AFTER> thenLift(@NotNull Function<? super FunctionalRoutine<IN, OUT>, ? extends Routine<BEFORE, AFTER>> function) {
            return new DefaultFunctionalRoutine<BEFORE, AFTER>(function.apply(this), DelegatingInvocation.DelegationType.SYNC);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class AfterInvocation<IN, OUT, AFTER>
        implements Invocation<IN, AFTER> {
            private final Routine<? super OUT, AFTER> mAfterRoutine;
            private final DelegatingInvocation.DelegationType mDelegationType;
            private final FunctionalRoutine<IN, OUT> mRoutine;
            private StreamingChannel<IN, OUT> mInputChannel;
            private Channel.OutputChannel<AFTER> mOutputChannel;

            private AfterInvocation(@NotNull FunctionalRoutine<IN, OUT> routine, @NotNull Routine<? super OUT, AFTER> afterRoutine, @NotNull DelegatingInvocation.DelegationType delegationType) {
                this.mRoutine = routine;
                this.mAfterRoutine = afterRoutine;
                this.mDelegationType = delegationType;
            }

            @Override
            public void onAbort(@Nullable RoutineException reason) {
                this.mInputChannel.abort(reason);
            }

            @Override
            public void onDestroy() {
                this.mInputChannel = null;
                this.mOutputChannel = null;
            }

            @Override
            public void onInitialize() {
                StreamingChannel<IN, OUT> streamingChannel = Channels.syncStream(this.mRoutine);
                DelegatingInvocation.DelegationType delegationType = this.mDelegationType;
                this.mInputChannel = streamingChannel;
                this.mOutputChannel = delegationType == DelegatingInvocation.DelegationType.ASYNC ? streamingChannel.passTo(this.mAfterRoutine.asyncInvoke()).result() : (delegationType == DelegatingInvocation.DelegationType.PARALLEL ? streamingChannel.passTo(this.mAfterRoutine.parallelInvoke()).result() : streamingChannel.passTo(this.mAfterRoutine.syncInvoke()).result());
            }

            @Override
            public void onInput(IN input, @NotNull ResultChannel<AFTER> result) {
                Channel.OutputChannel<AFTER> channel = this.mOutputChannel;
                if (!channel.isBound()) {
                    channel.passTo(result);
                }
                this.mInputChannel.pass(input);
            }

            @Override
            public void onResult(@NotNull ResultChannel<AFTER> result) {
                Channel.OutputChannel<AFTER> channel = this.mOutputChannel;
                if (!channel.isBound()) {
                    channel.passTo(result);
                }
                this.mInputChannel.close();
            }

            @Override
            public void onTerminate() {
                this.mInputChannel = null;
                this.mOutputChannel = null;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class AfterFunctionalRoutine<IN, OUT, AFTER>
        extends AbstractFunctionalRoutine<IN, AFTER> {
            private final Routine<? super OUT, AFTER> mAfterRoutine;
            private final DelegatingInvocation.DelegationType mDelegationType;
            private final FunctionalRoutine<IN, OUT> mRoutine;

            private AfterFunctionalRoutine(@NotNull FunctionalRoutine<IN, OUT> routine, @NotNull Routine<? super OUT, AFTER> afterRoutine, @NotNull DelegatingInvocation.DelegationType delegationType) {
                if (afterRoutine == null) {
                    throw new NullPointerException("the concatenated routine must not be null");
                }
                this.mRoutine = routine;
                this.mAfterRoutine = afterRoutine;
                this.mDelegationType = delegationType;
            }

            @Override
            @NotNull
            protected <NEXT> FunctionalRoutine<IN, NEXT> andThen(@NotNull Routine<? super AFTER, NEXT> routine, @NotNull DelegatingInvocation.DelegationType delegationType) {
                return new AfterFunctionalRoutine<IN, AFTER, NEXT>(this, routine, delegationType);
            }

            @Override
            @NotNull
            public <BEFORE, NEXT> FunctionalRoutine<BEFORE, NEXT> thenLift(@NotNull Function<? super FunctionalRoutine<IN, AFTER>, ? extends Routine<BEFORE, NEXT>> function) {
                return new DefaultFunctionalRoutine(function.apply(this), DelegatingInvocation.DelegationType.SYNC);
            }

            @Override
            @NotNull
            protected Invocation<IN, AFTER> newInvocation(@NotNull AbstractRoutine.InvocationType type) {
                return new AfterInvocation(this.mRoutine, this.mAfterRoutine, this.mDelegationType);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractFunctionalRoutine<IN, OUT>
    extends AbstractRoutine<IN, OUT>
    implements FunctionalRoutine<IN, OUT>,
    InvocationConfiguration.Configurable<FunctionalRoutine<IN, OUT>> {
        private InvocationConfiguration mConfiguration = InvocationConfiguration.DEFAULT_CONFIGURATION;

        private AbstractFunctionalRoutine() {
            super(InvocationConfiguration.DEFAULT_CONFIGURATION);
        }

        @Override
        @NotNull
        public InvocationConfiguration.Builder<? extends FunctionalRoutine<IN, OUT>> invocations() {
            return new InvocationConfiguration.Builder(this, this.mConfiguration);
        }

        @Override
        @NotNull
        public FunctionalRoutine<IN, OUT> setConfiguration(@NotNull InvocationConfiguration configuration) {
            if (configuration == null) {
                throw new NullPointerException("the invocation configuration must not be null");
            }
            this.mConfiguration = configuration;
            return this;
        }

        @Override
        @NotNull
        public FunctionalRoutine<IN, OUT> thenAsyncAccumulate(@NotNull BiFunction<? super OUT, ? super OUT, ? extends OUT> function) {
            return this.fromFactory(AccumulateInvocation.functionFactory(function), DelegatingInvocation.DelegationType.ASYNC);
        }

        @Override
        @NotNull
        public FunctionalRoutine<IN, OUT> thenAsyncFilter(@NotNull Predicate<? super OUT> predicate) {
            return this.fromFactory(Functions.predicateFilter(predicate), DelegatingInvocation.DelegationType.ASYNC);
        }

        @Override
        @NotNull
        public <AFTER> FunctionalRoutine<IN, AFTER> thenAsyncMap(@NotNull BiConsumer<? super OUT, ? super ResultChannel<AFTER>> consumer) {
            return this.fromFactory(Functions.consumerFilter(consumer), DelegatingInvocation.DelegationType.ASYNC);
        }

        @Override
        @NotNull
        public <AFTER> FunctionalRoutine<IN, AFTER> thenAsyncMap(@NotNull Function<? super OUT, AFTER> function) {
            return this.fromFactory(Functions.functionFilter(function), DelegatingInvocation.DelegationType.ASYNC);
        }

        @Override
        @NotNull
        public <AFTER> FunctionalRoutine<IN, AFTER> thenAsyncMap(@NotNull InvocationFactory<? super OUT, AFTER> factory) {
            return this.fromFactory(factory, DelegatingInvocation.DelegationType.ASYNC);
        }

        @Override
        @NotNull
        public <AFTER> FunctionalRoutine<IN, AFTER> thenAsyncMap(@NotNull Routine<? super OUT, AFTER> routine) {
            return this.andThen(routine, DelegatingInvocation.DelegationType.ASYNC);
        }

        @Override
        @NotNull
        public <AFTER> FunctionalRoutine<IN, AFTER> thenAsyncReduce(@NotNull BiConsumer<? super List<? extends OUT>, ? super ResultChannel<AFTER>> consumer) {
            return this.fromFactory(Functions.consumerFactory(consumer), DelegatingInvocation.DelegationType.ASYNC);
        }

        @Override
        @NotNull
        public <AFTER> FunctionalRoutine<IN, AFTER> thenAsyncReduce(@NotNull Function<? super List<? extends OUT>, AFTER> function) {
            return this.fromFactory(Functions.functionFactory(function), DelegatingInvocation.DelegationType.ASYNC);
        }

        @Override
        @NotNull
        public <BEFORE, AFTER> FunctionalRoutine<BEFORE, AFTER> thenFlatLift(@NotNull Function<? super FunctionalRoutine<IN, OUT>, ? extends FunctionalRoutine<BEFORE, AFTER>> function) {
            return function.apply(this);
        }

        @NotNull
        protected abstract <AFTER> FunctionalRoutine<IN, AFTER> andThen(@NotNull Routine<? super OUT, AFTER> var1, @NotNull DelegatingInvocation.DelegationType var2);

        @NotNull
        private <AFTER> FunctionalRoutine<IN, AFTER> fromFactory(@NotNull InvocationFactory<? super OUT, AFTER> factory, @NotNull DelegatingInvocation.DelegationType delegationType) {
            return this.andThen(((RoutineBuilder)JRoutine.on(factory).invocations().with(this.mConfiguration).set()).buildRoutine(), delegationType);
        }

        @Override
        @NotNull
        public FunctionalRoutine<IN, OUT> thenParallelFilter(@NotNull Predicate<? super OUT> predicate) {
            return this.fromFactory(Functions.predicateFilter(predicate), DelegatingInvocation.DelegationType.PARALLEL);
        }

        @Override
        @NotNull
        public <AFTER> FunctionalRoutine<IN, AFTER> thenParallelMap(@NotNull BiConsumer<? super OUT, ? super ResultChannel<AFTER>> consumer) {
            return this.fromFactory(Functions.consumerFilter(consumer), DelegatingInvocation.DelegationType.PARALLEL);
        }

        @Override
        @NotNull
        public <AFTER> FunctionalRoutine<IN, AFTER> thenParallelMap(@NotNull Function<? super OUT, AFTER> function) {
            return this.fromFactory(Functions.functionFilter(function), DelegatingInvocation.DelegationType.PARALLEL);
        }

        @Override
        @NotNull
        public <AFTER> FunctionalRoutine<IN, AFTER> thenParallelMap(@NotNull InvocationFactory<? super OUT, AFTER> factory) {
            return this.fromFactory(factory, DelegatingInvocation.DelegationType.PARALLEL);
        }

        @Override
        @NotNull
        public <AFTER> FunctionalRoutine<IN, AFTER> thenParallelMap(@NotNull Routine<? super OUT, AFTER> routine) {
            return this.andThen(routine, DelegatingInvocation.DelegationType.PARALLEL);
        }

        @Override
        @NotNull
        public FunctionalRoutine<IN, OUT> thenSyncAccumulate(@NotNull BiFunction<? super OUT, ? super OUT, ? extends OUT> function) {
            return this.fromFactory(AccumulateInvocation.functionFactory(function), DelegatingInvocation.DelegationType.SYNC);
        }

        @Override
        @NotNull
        public FunctionalRoutine<IN, OUT> thenSyncFilter(@NotNull Predicate<? super OUT> predicate) {
            return this.fromFactory(Functions.predicateFilter(predicate), DelegatingInvocation.DelegationType.SYNC);
        }

        @Override
        @NotNull
        public <AFTER> FunctionalRoutine<IN, AFTER> thenSyncMap(@NotNull BiConsumer<? super OUT, ? super ResultChannel<AFTER>> consumer) {
            return this.fromFactory(Functions.consumerFilter(consumer), DelegatingInvocation.DelegationType.SYNC);
        }

        @Override
        @NotNull
        public <AFTER> FunctionalRoutine<IN, AFTER> thenSyncMap(@NotNull Function<? super OUT, AFTER> function) {
            return this.fromFactory(Functions.functionFilter(function), DelegatingInvocation.DelegationType.SYNC);
        }

        @Override
        @NotNull
        public <AFTER> FunctionalRoutine<IN, AFTER> thenSyncMap(@NotNull InvocationFactory<? super OUT, AFTER> factory) {
            return this.fromFactory(factory, DelegatingInvocation.DelegationType.SYNC);
        }

        @Override
        @NotNull
        public <AFTER> FunctionalRoutine<IN, AFTER> thenSyncMap(@NotNull Routine<? super OUT, AFTER> routine) {
            return this.andThen(routine, DelegatingInvocation.DelegationType.SYNC);
        }

        @Override
        @NotNull
        public <AFTER> FunctionalRoutine<IN, AFTER> thenSyncReduce(@NotNull BiConsumer<? super List<? extends OUT>, ? super ResultChannel<AFTER>> consumer) {
            return this.fromFactory(Functions.consumerFactory(consumer), DelegatingInvocation.DelegationType.SYNC);
        }

        @Override
        @NotNull
        public <AFTER> FunctionalRoutine<IN, AFTER> thenSyncReduce(@NotNull Function<? super List<? extends OUT>, AFTER> function) {
            return this.fromFactory(Functions.functionFactory(function), DelegatingInvocation.DelegationType.SYNC);
        }
    }
}

