/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.function;

import com.github.dm.jrt.channel.OutputConsumer;
import com.github.dm.jrt.channel.RoutineException;
import com.github.dm.jrt.function.Consumer;
import com.github.dm.jrt.function.ConsumerWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputConsumerBuilder<OUT>
implements OutputConsumer<OUT> {
    private final ConsumerWrapper<Void> mOnComplete;
    private final ConsumerWrapper<RoutineException> mOnError;
    private final ConsumerWrapper<OUT> mOnOutput;

    OutputConsumerBuilder(@NotNull ConsumerWrapper<Void> onComplete, @NotNull ConsumerWrapper<RoutineException> onError, @NotNull ConsumerWrapper<OUT> onOutput) {
        if (onComplete == null) {
            throw new NullPointerException("the complete consumer must not be null");
        }
        if (onError == null) {
            throw new NullPointerException("the error consumer must not be null");
        }
        if (onOutput == null) {
            throw new NullPointerException("the output consumer must not be null");
        }
        this.mOnOutput = onOutput;
        this.mOnError = onError;
        this.mOnComplete = onComplete;
    }

    @Override
    public void onComplete() {
        this.mOnComplete.accept(null);
    }

    @Override
    public void onError(@Nullable RoutineException error) {
        this.mOnError.accept(error);
    }

    @Override
    public void onOutput(OUT output) {
        this.mOnOutput.accept(output);
    }

    @NotNull
    public OutputConsumerBuilder<OUT> thenOnComplete(@NotNull Consumer<Void> consumer) {
        return new OutputConsumerBuilder<OUT>(this.mOnComplete.andThen(consumer), this.mOnError, this.mOnOutput);
    }

    @NotNull
    public OutputConsumerBuilder<OUT> thenOnError(@NotNull Consumer<? super RoutineException> consumer) {
        return new OutputConsumerBuilder<OUT>(this.mOnComplete, this.mOnError.andThen(consumer), this.mOnOutput);
    }

    @NotNull
    public OutputConsumerBuilder<OUT> thenOnOutput(@NotNull Consumer<? super OUT> consumer) {
        return new OutputConsumerBuilder<OUT>(this.mOnComplete, this.mOnError, this.mOnOutput.andThen(consumer));
    }
}

