/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.function;

import com.github.dm.jrt.function.Predicate;
import com.github.dm.jrt.util.Reflection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicateWrapper<IN>
implements Predicate<IN> {
    private static final LogicalPredicate AND_PREDICATE = new LogicalPredicate();
    private static final LogicalPredicate CLOSE_PREDICATE = new LogicalPredicate();
    private static final LogicalPredicate NEGATE_PREDICATE = new LogicalPredicate();
    private static final LogicalPredicate OPEN_PREDICATE = new LogicalPredicate();
    private static final LogicalPredicate OR_PREDICATE = new LogicalPredicate();
    private static final PredicateWrapper<Object> sNegative = new PredicateWrapper<Object>(new Predicate<Object>(){

        @Override
        public boolean test(Object o) {
            return false;
        }
    });
    private static final PredicateWrapper<Object> sNotNull = new PredicateWrapper<Object>(new Predicate<Object>(){

        @Override
        public boolean test(Object o) {
            return o != null;
        }
    });
    private final Predicate<? super IN> mPredicate;
    private final List<Predicate<?>> mPredicates;
    private static final PredicateWrapper<Object> sIsNull = sNotNull.negate();
    private static final PredicateWrapper<Object> sPositive = sNegative.negate();

    PredicateWrapper(@NotNull Predicate<? super IN> predicate) {
        this(predicate, Collections.singletonList(predicate));
        if (predicate == null) {
            throw new NullPointerException("the predicate must not be null");
        }
    }

    private PredicateWrapper(@NotNull Predicate<? super IN> predicate, @NotNull List<Predicate<?>> predicates) {
        this.mPredicate = predicate;
        this.mPredicates = predicates;
    }

    @NotNull
    public static <IN> PredicateWrapper<IN> isEqual(@Nullable Object targetRef) {
        if (targetRef == null) {
            return PredicateWrapper.isNull();
        }
        return new PredicateWrapper(new EqualToPredicate(targetRef));
    }

    @NotNull
    public static <IN> PredicateWrapper<IN> isInstanceOf(@NotNull Class<?> type) {
        if (type == null) {
            throw new NullPointerException("the type must not be null");
        }
        return new PredicateWrapper(new InstanceOfPredicate(type));
    }

    @NotNull
    public static <IN> PredicateWrapper<IN> isNull() {
        return sIsNull;
    }

    @NotNull
    public static <IN> PredicateWrapper<IN> isSame(@Nullable Object targetRef) {
        if (targetRef == null) {
            return PredicateWrapper.isNull();
        }
        return new PredicateWrapper(new SameAsPredicate(targetRef));
    }

    @NotNull
    public static <IN> PredicateWrapper<IN> negative() {
        return sNegative;
    }

    @NotNull
    public static <IN> PredicateWrapper<IN> notNull() {
        return sNotNull;
    }

    @NotNull
    public static <IN> PredicateWrapper<IN> positive() {
        return sPositive;
    }

    @NotNull
    public PredicateWrapper<IN> and(@NotNull Predicate<? super IN> other) {
        Class<?> otherClass = other.getClass();
        List<Predicate<?>> predicates = this.mPredicates;
        ArrayList newPredicates = new ArrayList(predicates.size() + 4);
        newPredicates.add(OPEN_PREDICATE);
        newPredicates.addAll(predicates);
        newPredicates.add(AND_PREDICATE);
        if (otherClass == PredicateWrapper.class) {
            newPredicates.addAll(((PredicateWrapper)other).mPredicates);
        } else {
            newPredicates.add(other);
        }
        newPredicates.add(CLOSE_PREDICATE);
        return new PredicateWrapper(new AndPredicate(this.mPredicate, other), newPredicates);
    }

    public boolean hasStaticContext() {
        for (Predicate<?> predicate : this.mPredicates) {
            if (Reflection.hasStaticContext(predicate.getClass())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.mPredicates.hashCode();
    }

    @NotNull
    public PredicateWrapper<IN> negate() {
        List<Predicate<?>> predicates = this.mPredicates;
        int size = predicates.size();
        ArrayList newPredicates = new ArrayList(size + 1);
        if (size == 1) {
            newPredicates.add(NEGATE_PREDICATE);
            newPredicates.add(predicates.get(0));
        } else {
            Predicate<?> first = predicates.get(0);
            if (first == NEGATE_PREDICATE) {
                newPredicates.add(predicates.get(1));
            } else {
                newPredicates.add(first);
                for (int i = 1; i < size; ++i) {
                    Predicate<?> predicate = predicates.get(i);
                    if (predicate == NEGATE_PREDICATE) {
                        ++i;
                        continue;
                    }
                    if (predicate == OR_PREDICATE) {
                        newPredicates.add(AND_PREDICATE);
                        continue;
                    }
                    if (predicate == AND_PREDICATE) {
                        newPredicates.add(OR_PREDICATE);
                        continue;
                    }
                    if (predicate != OPEN_PREDICATE && predicate != CLOSE_PREDICATE) {
                        newPredicates.add(NEGATE_PREDICATE);
                    }
                    newPredicates.add(predicate);
                }
            }
        }
        Predicate<? super IN> predicate = this.mPredicate;
        if (predicate instanceof NegatePredicate) {
            return new PredicateWrapper<IN>(((NegatePredicate)predicate).mPredicate, newPredicates);
        }
        return new PredicateWrapper(new NegatePredicate(predicate), newPredicates);
    }

    @NotNull
    public PredicateWrapper<IN> or(@NotNull Predicate<? super IN> other) {
        Class<?> otherClass = other.getClass();
        List<Predicate<?>> predicates = this.mPredicates;
        ArrayList newPredicates = new ArrayList(predicates.size() + 4);
        newPredicates.add(OPEN_PREDICATE);
        newPredicates.addAll(predicates);
        newPredicates.add(OR_PREDICATE);
        if (otherClass == PredicateWrapper.class) {
            newPredicates.addAll(((PredicateWrapper)other).mPredicates);
        } else {
            newPredicates.add(other);
        }
        newPredicates.add(CLOSE_PREDICATE);
        return new PredicateWrapper(new OrPredicate(this.mPredicate, other), newPredicates);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredicateWrapper that = (PredicateWrapper)o;
        return this.mPredicates.equals(that.mPredicates);
    }

    @Override
    public boolean test(IN in) {
        return this.mPredicate.test(in);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SameAsPredicate<IN>
    implements Predicate<IN> {
        private final Object mOther;

        private SameAsPredicate(@NotNull Object other) {
            this.mOther = other;
        }

        @Override
        public boolean test(IN in) {
            return this.mOther == in;
        }

        public int hashCode() {
            return this.mOther.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SameAsPredicate that = (SameAsPredicate)o;
            return this.mOther == that.mOther;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class OrPredicate<IN>
    implements Predicate<IN> {
        private final Predicate<? super IN> mOther;
        private final Predicate<? super IN> mPredicate;

        private OrPredicate(@NotNull Predicate<? super IN> predicate, @NotNull Predicate<? super IN> other) {
            this.mPredicate = predicate;
            this.mOther = other;
        }

        @Override
        public boolean test(IN in) {
            return this.mPredicate.test(in) || this.mOther.test(in);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NegatePredicate<IN>
    implements Predicate<IN> {
        private final Predicate<? super IN> mPredicate;

        private NegatePredicate(@NotNull Predicate<? super IN> predicate) {
            this.mPredicate = predicate;
        }

        @Override
        public boolean test(IN in) {
            return !this.mPredicate.test(in);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LogicalPredicate
    implements Predicate<Object> {
        private LogicalPredicate() {
        }

        @Override
        public boolean test(Object o) {
            throw new UnsupportedOperationException("should never be called");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstanceOfPredicate<IN>
    implements Predicate<IN> {
        private final Class<?> mType;

        private InstanceOfPredicate(@NotNull Class<?> type) {
            this.mType = type;
        }

        public int hashCode() {
            return this.mType.hashCode();
        }

        @Override
        public boolean test(IN in) {
            return this.mType.isInstance(in);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InstanceOfPredicate that = (InstanceOfPredicate)o;
            return this.mType.equals(that.mType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EqualToPredicate<IN>
    implements Predicate<IN> {
        private final Object mOther;

        private EqualToPredicate(@NotNull Object other) {
            this.mOther = other;
        }

        public int hashCode() {
            return this.mOther.hashCode();
        }

        @Override
        public boolean test(IN in) {
            return this.mOther.equals(in);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EqualToPredicate that = (EqualToPredicate)o;
            return this.mOther.equals(that.mOther);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AndPredicate<IN>
    implements Predicate<IN> {
        private final Predicate<? super IN> mOther;
        private final Predicate<? super IN> mPredicate;

        private AndPredicate(@NotNull Predicate<? super IN> predicate, @NotNull Predicate<? super IN> other) {
            this.mPredicate = predicate;
            this.mOther = other;
        }

        @Override
        public boolean test(IN in) {
            return this.mPredicate.test(in) && this.mOther.test(in);
        }
    }
}

