/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.function;

import com.github.dm.jrt.function.Function;
import com.github.dm.jrt.function.FunctionWrapper;
import com.github.dm.jrt.function.Supplier;
import com.github.dm.jrt.util.Reflection;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupplierWrapper<OUT>
implements Supplier<OUT> {
    private final FunctionWrapper<?, OUT> mFunction;
    private final Supplier<?> mSupplier;

    SupplierWrapper(@NotNull Supplier<?> supplier) {
        this(supplier, FunctionWrapper.identity());
        if (supplier == null) {
            throw new NullPointerException("the supplier instance must not be null");
        }
    }

    private SupplierWrapper(@NotNull Supplier<?> supplier, @NotNull FunctionWrapper<?, OUT> function) {
        this.mSupplier = supplier;
        this.mFunction = function;
    }

    @NotNull
    public static <OUT> SupplierWrapper<OUT> constant(OUT result) {
        return new SupplierWrapper<OUT>(new ConstantSupplier(result));
    }

    @NotNull
    public <AFTER> SupplierWrapper<AFTER> andThen(@NotNull Function<? super OUT, AFTER> after) {
        return new SupplierWrapper<AFTER>(this.mSupplier, this.mFunction.andThen(after));
    }

    @Override
    public OUT get() {
        return this.mFunction.apply(this.mSupplier.get());
    }

    public boolean hasStaticContext() {
        Supplier<?> supplier = this.mSupplier;
        return Reflection.hasStaticContext(supplier.getClass()) && this.mFunction.hasStaticContext();
    }

    public int hashCode() {
        int result = this.mFunction.hashCode();
        result = 31 * result + this.mSupplier.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupplierWrapper that = (SupplierWrapper)o;
        return this.mFunction.equals(that.mFunction) && this.mSupplier.equals(that.mSupplier);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstantSupplier<OUT>
    implements Supplier<OUT> {
        private final OUT mResult;

        private ConstantSupplier(OUT result) {
            this.mResult = result;
        }

        @Override
        public OUT get() {
            return this.mResult;
        }

        public int hashCode() {
            return this.mResult != null ? this.mResult.hashCode() : 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConstantSupplier that = (ConstantSupplier)o;
            return this.mResult == that.mResult;
        }
    }
}

