/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.invocation;

import com.github.dm.jrt.invocation.Invocation;
import com.github.dm.jrt.invocation.InvocationException;
import com.github.dm.jrt.invocation.InvocationFactory;
import com.github.dm.jrt.util.ClassToken;
import com.github.dm.jrt.util.Reflection;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invocations {
    protected Invocations() {
    }

    @NotNull
    public static <IN, OUT> InvocationFactory<IN, OUT> factoryOf(@NotNull Class<? extends Invocation<IN, OUT>> invocationClass) {
        return Invocations.factoryOf(invocationClass, (Object[])null);
    }

    @NotNull
    public static <IN, OUT> InvocationFactory<IN, OUT> factoryOf(@NotNull Class<? extends Invocation<IN, OUT>> invocationClass, Object ... args) {
        return new DefaultInvocationFactory(invocationClass, args);
    }

    @NotNull
    public static <IN, OUT> InvocationFactory<IN, OUT> factoryOf(@NotNull ClassToken<? extends Invocation<IN, OUT>> invocationToken) {
        return Invocations.factoryOf(invocationToken.getRawClass());
    }

    @NotNull
    public static <IN, OUT> InvocationFactory<IN, OUT> factoryOf(@NotNull ClassToken<? extends Invocation<IN, OUT>> invocationToken, Object ... args) {
        return Invocations.factoryOf(invocationToken.getRawClass(), args);
    }

    @NotNull
    public static <IN, OUT> InvocationFactory<IN, OUT> factoryOf(@NotNull Invocation<IN, OUT> invocation) {
        return Invocations.factoryOf(invocation.getClass());
    }

    @NotNull
    public static <IN, OUT> InvocationFactory<IN, OUT> factoryOf(@NotNull Invocation<IN, OUT> invocation, Object ... args) {
        return Invocations.factoryOf(invocation.getClass(), args);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultInvocationFactory<IN, OUT>
    extends InvocationFactory<IN, OUT> {
        private final Object[] mArgs;
        private final Constructor<? extends Invocation<IN, OUT>> mConstructor;

        private DefaultInvocationFactory(@NotNull Class<? extends Invocation<IN, OUT>> invocationClass, @Nullable Object[] args) {
            this.mArgs = args != null ? (Object[])args.clone() : Reflection.NO_ARGS;
            Object[] invocationArgs = this.mArgs;
            this.mConstructor = Reflection.findConstructor(invocationClass, invocationArgs);
        }

        public int hashCode() {
            int result = Arrays.deepHashCode(this.mArgs);
            result = 31 * result + this.mConstructor.hashCode();
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DefaultInvocationFactory)) {
                return false;
            }
            DefaultInvocationFactory that = (DefaultInvocationFactory)o;
            return Arrays.deepEquals(this.mArgs, that.mArgs) && this.mConstructor.equals(that.mConstructor);
        }

        @Override
        @NotNull
        public Invocation<IN, OUT> newInvocation() {
            try {
                return this.mConstructor.newInstance(this.mArgs);
            }
            catch (Throwable t) {
                throw InvocationException.wrapIfNeeded(t);
            }
        }
    }
}

