/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.log;

import com.github.dm.jrt.log.Log;
import com.github.dm.jrt.log.Logs;
import com.github.dm.jrt.log.SystemLog;
import com.github.dm.jrt.util.Reflection;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logger {
    private static final int DEBUG_LEVEL = Log.Level.DEBUG.ordinal();
    private static final int ERROR_LEVEL = Log.Level.ERROR.ordinal();
    private static final int WARNING_LEVEL = Log.Level.WARNING.ordinal();
    private static final AtomicReference<Log> sLog = new AtomicReference<SystemLog>(Logs.systemLog());
    private static final AtomicReference<Log.Level> sLogLevel = new AtomicReference<Log.Level>(Log.Level.ERROR);
    private final List<Object> mContextList;
    private final Object[] mContexts;
    private final int mLevel;
    private final Log mLog;
    private final Log.Level mLogLevel;

    private Logger(@NotNull Object[] contexts, @Nullable Log log, @Nullable Log.Level level) {
        this.mContexts = (Object[])contexts.clone();
        this.mLog = log == null ? sLog.get() : log;
        this.mLogLevel = level == null ? sLogLevel.get() : level;
        this.mLevel = this.mLogLevel.ordinal();
        this.mContextList = Arrays.asList(this.mContexts);
    }

    @NotNull
    public static Log.Level getDefaultLevel() {
        return sLogLevel.get();
    }

    public static void setDefaultLevel(@NotNull Log.Level level) {
        if (level == null) {
            throw new NullPointerException("the default log level must not be null");
        }
        sLogLevel.set(level);
    }

    @NotNull
    public static Log getDefaultLog() {
        return sLog.get();
    }

    public static void setDefaultLog(@NotNull Log log) {
        if (log == null) {
            throw new NullPointerException("the default log instance must not be null");
        }
        sLog.set(log);
    }

    @NotNull
    public static Logger newLogger(@Nullable Log log, @Nullable Log.Level level, @NotNull Object context) {
        if (context == null) {
            throw new NullPointerException("the context must not be null");
        }
        return new Logger(Reflection.asArgs(context), log, level);
    }

    public void dbg(@Nullable String message) {
        if (this.mLevel <= DEBUG_LEVEL) {
            this.mLog.dbg(this.mContextList, message, null);
        }
    }

    public void dbg(@NotNull String format, @Nullable Object arg1) {
        if (this.mLevel <= DEBUG_LEVEL) {
            this.mLog.dbg(this.mContextList, String.format(format, arg1), null);
        }
    }

    public void dbg(@NotNull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (this.mLevel <= DEBUG_LEVEL) {
            this.mLog.dbg(this.mContextList, String.format(format, arg1, arg2), null);
        }
    }

    public void dbg(@NotNull String format, @Nullable Object arg1, @Nullable Object arg2, @Nullable Object arg3) {
        if (this.mLevel <= DEBUG_LEVEL) {
            this.mLog.dbg(this.mContextList, String.format(format, arg1, arg2, arg3), null);
        }
    }

    public void dbg(@NotNull String format, @Nullable Object arg1, @Nullable Object arg2, @Nullable Object arg3, @Nullable Object arg4) {
        if (this.mLevel <= DEBUG_LEVEL) {
            this.mLog.dbg(this.mContextList, String.format(format, arg1, arg2, arg3, arg4), null);
        }
    }

    public void dbg(@NotNull String format, Object ... args) {
        if (this.mLevel <= DEBUG_LEVEL) {
            this.mLog.dbg(this.mContextList, String.format(format, args), null);
        }
    }

    public void dbg(@Nullable Throwable throwable) {
        if (this.mLevel <= DEBUG_LEVEL) {
            this.mLog.dbg(this.mContextList, "", throwable);
        }
    }

    public void dbg(@Nullable Throwable throwable, @Nullable String message) {
        if (this.mLevel <= DEBUG_LEVEL) {
            this.mLog.dbg(this.mContextList, message, throwable);
        }
    }

    public void dbg(@NotNull Throwable throwable, @NotNull String format, @Nullable Object arg1) {
        if (this.mLevel <= DEBUG_LEVEL) {
            this.mLog.dbg(this.mContextList, String.format(format, arg1), throwable);
        }
    }

    public void dbg(@NotNull Throwable throwable, @NotNull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (this.mLevel <= DEBUG_LEVEL) {
            this.mLog.dbg(this.mContextList, String.format(format, arg1, arg2), throwable);
        }
    }

    public void dbg(@NotNull Throwable throwable, @NotNull String format, @Nullable Object arg1, @Nullable Object arg2, @Nullable Object arg3) {
        if (this.mLevel <= DEBUG_LEVEL) {
            this.mLog.dbg(this.mContextList, String.format(format, arg1, arg2, arg3), throwable);
        }
    }

    public void dbg(@NotNull Throwable throwable, @NotNull String format, @Nullable Object arg1, @Nullable Object arg2, @Nullable Object arg3, @Nullable Object arg4) {
        if (this.mLevel <= DEBUG_LEVEL) {
            this.mLog.dbg(this.mContextList, String.format(format, arg1, arg2, arg3, arg4), throwable);
        }
    }

    public void dbg(@NotNull Throwable throwable, @NotNull String format, Object ... args) {
        if (this.mLevel <= DEBUG_LEVEL) {
            this.mLog.dbg(this.mContextList, String.format(format, args), throwable);
        }
    }

    public void err(@Nullable String message) {
        if (this.mLevel <= ERROR_LEVEL) {
            this.mLog.err(this.mContextList, message, null);
        }
    }

    public void err(@NotNull String format, @Nullable Object arg1) {
        if (this.mLevel <= ERROR_LEVEL) {
            this.mLog.err(this.mContextList, String.format(format, arg1), null);
        }
    }

    public void err(@NotNull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (this.mLevel <= ERROR_LEVEL) {
            this.mLog.err(this.mContextList, String.format(format, arg1, arg2), null);
        }
    }

    public void err(@NotNull String format, @Nullable Object arg1, @Nullable Object arg2, @Nullable Object arg3) {
        if (this.mLevel <= ERROR_LEVEL) {
            this.mLog.err(this.mContextList, String.format(format, arg1, arg2, arg3), null);
        }
    }

    public void err(@NotNull String format, @Nullable Object arg1, @Nullable Object arg2, @Nullable Object arg3, @Nullable Object arg4) {
        if (this.mLevel <= ERROR_LEVEL) {
            this.mLog.err(this.mContextList, String.format(format, arg1, arg2, arg3, arg4), null);
        }
    }

    public void err(@NotNull String format, Object ... args) {
        if (this.mLevel <= ERROR_LEVEL) {
            this.mLog.err(this.mContextList, String.format(format, args), null);
        }
    }

    public void err(@NotNull Throwable throwable) {
        if (this.mLevel <= ERROR_LEVEL) {
            this.mLog.err(this.mContextList, "", throwable);
        }
    }

    public void err(@NotNull Throwable throwable, @Nullable String message) {
        if (this.mLevel <= ERROR_LEVEL) {
            this.mLog.err(this.mContextList, message, throwable);
        }
    }

    public void err(@NotNull Throwable throwable, @NotNull String format, @Nullable Object arg1) {
        if (this.mLevel <= ERROR_LEVEL) {
            this.mLog.err(this.mContextList, String.format(format, arg1), throwable);
        }
    }

    public void err(@NotNull Throwable throwable, @NotNull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (this.mLevel <= ERROR_LEVEL) {
            this.mLog.err(this.mContextList, String.format(format, arg1, arg2), throwable);
        }
    }

    public void err(@NotNull Throwable throwable, @NotNull String format, @Nullable Object arg1, @Nullable Object arg2, @Nullable Object arg3) {
        if (this.mLevel <= ERROR_LEVEL) {
            this.mLog.err(this.mContextList, String.format(format, arg1, arg2, arg3), throwable);
        }
    }

    public void err(@NotNull Throwable throwable, @NotNull String format, @Nullable Object arg1, @Nullable Object arg2, @Nullable Object arg3, @Nullable Object arg4) {
        if (this.mLevel <= ERROR_LEVEL) {
            this.mLog.err(this.mContextList, String.format(format, arg1, arg2, arg3, arg4), throwable);
        }
    }

    public void err(@NotNull Throwable throwable, @NotNull String format, Object ... args) {
        if (this.mLevel <= ERROR_LEVEL) {
            this.mLog.err(this.mContextList, String.format(format, args), throwable);
        }
    }

    @NotNull
    public List<Object> getContextList() {
        return this.mContextList;
    }

    @NotNull
    public Log getLog() {
        return this.mLog;
    }

    @NotNull
    public Log.Level getLogLevel() {
        return this.mLogLevel;
    }

    @NotNull
    public Logger subContextLogger(@NotNull Object context) {
        if (context == null) {
            throw new NullPointerException("the context must not be null");
        }
        Object[] thisContexts = this.mContexts;
        int thisLength = thisContexts.length;
        Object[] newContexts = new Object[thisLength + 1];
        System.arraycopy(thisContexts, 0, newContexts, 0, thisLength);
        newContexts[thisLength] = context;
        return new Logger(newContexts, this.mLog, this.mLogLevel);
    }

    public void wrn(@Nullable String message) {
        if (this.mLevel <= WARNING_LEVEL) {
            this.mLog.wrn(this.mContextList, message, null);
        }
    }

    public void wrn(@NotNull String format, @Nullable Object arg1) {
        if (this.mLevel <= WARNING_LEVEL) {
            this.mLog.wrn(this.mContextList, String.format(format, arg1), null);
        }
    }

    public void wrn(@NotNull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (this.mLevel <= WARNING_LEVEL) {
            this.mLog.wrn(this.mContextList, String.format(format, arg1, arg2), null);
        }
    }

    public void wrn(@NotNull String format, @Nullable Object arg1, @Nullable Object arg2, @Nullable Object arg3) {
        if (this.mLevel <= WARNING_LEVEL) {
            this.mLog.wrn(this.mContextList, String.format(format, arg1, arg2, arg3), null);
        }
    }

    public void wrn(@NotNull String format, @Nullable Object arg1, @Nullable Object arg2, @Nullable Object arg3, @Nullable Object arg4) {
        if (this.mLevel <= WARNING_LEVEL) {
            this.mLog.wrn(this.mContextList, String.format(format, arg1, arg2, arg3, arg4), null);
        }
    }

    public void wrn(@NotNull String format, Object ... args) {
        if (this.mLevel <= WARNING_LEVEL) {
            this.mLog.wrn(this.mContextList, String.format(format, args), null);
        }
    }

    public void wrn(@NotNull Throwable throwable) {
        if (this.mLevel <= WARNING_LEVEL) {
            this.mLog.wrn(this.mContextList, "", throwable);
        }
    }

    public void wrn(@NotNull Throwable throwable, @Nullable String message) {
        if (this.mLevel <= WARNING_LEVEL) {
            this.mLog.wrn(this.mContextList, message, throwable);
        }
    }

    public void wrn(@NotNull Throwable throwable, @NotNull String format, @Nullable Object arg1) {
        if (this.mLevel <= WARNING_LEVEL) {
            this.mLog.wrn(this.mContextList, String.format(format, arg1), throwable);
        }
    }

    public void wrn(@NotNull Throwable throwable, @NotNull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (this.mLevel <= WARNING_LEVEL) {
            this.mLog.wrn(this.mContextList, String.format(format, arg1, arg2), throwable);
        }
    }

    public void wrn(@NotNull Throwable throwable, @NotNull String format, @Nullable Object arg1, @Nullable Object arg2, @Nullable Object arg3) {
        if (this.mLevel <= WARNING_LEVEL) {
            this.mLog.wrn(this.mContextList, String.format(format, arg1, arg2, arg3), throwable);
        }
    }

    public void wrn(@NotNull Throwable throwable, @NotNull String format, @Nullable Object arg1, @Nullable Object arg2, @Nullable Object arg3, @Nullable Object arg4) {
        if (this.mLevel <= WARNING_LEVEL) {
            this.mLog.wrn(this.mContextList, String.format(format, arg1, arg2, arg3, arg4), throwable);
        }
    }

    public void wrn(@NotNull Throwable throwable, @NotNull String format, Object ... args) {
        if (this.mLevel <= WARNING_LEVEL) {
            this.mLog.wrn(this.mContextList, String.format(format, args), throwable);
        }
    }
}

