/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.log;

import com.github.dm.jrt.log.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TemplateLog
implements Log {
    private static final String DATE_FORMAT = "MM/dd HH:mm:ss.SSS z";
    private static final String EXCEPTION_FORMAT = " > caused by:%n%s";
    private static final String LOG_FORMAT = "%s\t%s\t%s\t%s> %s";

    @NotNull
    public static String printStackTrace(@NotNull Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private static String format(@NotNull Log.Level level, @NotNull List<Object> contexts, @Nullable String message) {
        return String.format(LOG_FORMAT, new Object[]{new SimpleDateFormat(DATE_FORMAT, Locale.getDefault()).format(new Date()), Thread.currentThread().getName(), contexts.toString(), level, message});
    }

    @Override
    public void dbg(@NotNull List<Object> contexts, @Nullable String message, @Nullable Throwable throwable) {
        this.log(Log.Level.DEBUG, contexts, message, throwable);
    }

    @Override
    public void err(@NotNull List<Object> contexts, @Nullable String message, @Nullable Throwable throwable) {
        this.log(Log.Level.ERROR, contexts, message, throwable);
    }

    @Override
    public void wrn(@NotNull List<Object> contexts, @Nullable String message, @Nullable Throwable throwable) {
        this.log(Log.Level.WARNING, contexts, message, throwable);
    }

    protected void log(@NotNull Log.Level level, @NotNull List<Object> contexts, @Nullable String message, @Nullable Throwable throwable) {
        String formatted = TemplateLog.format(level, contexts, message);
        if (throwable != null) {
            formatted = formatted + String.format(EXCEPTION_FORMAT, TemplateLog.printStackTrace(throwable));
        }
        this.log(formatted);
    }

    protected void log(@NotNull String message) {
    }
}

