/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.runner;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DynamicScheduledThreadExecutor
extends ScheduledThreadPoolExecutor {
    private final ThreadPoolExecutor mExecutor;

    DynamicScheduledThreadExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, @NotNull TimeUnit keepAliveUnit) {
        super(1);
        RejectingBlockingQueue internalQueue = new RejectingBlockingQueue();
        QueueRejectedExecutionHandler rejectedExecutionHandler = new QueueRejectedExecutionHandler(internalQueue);
        this.mExecutor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, keepAliveUnit, (BlockingQueue<Runnable>)internalQueue, rejectedExecutionHandler);
    }

    @Override
    @NotNull
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return super.schedule(new CommandRunnable(this.mExecutor, command), delay, unit);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RejectingBlockingQueue
    extends LinkedBlockingQueue<Runnable> {
        private static final long serialVersionUID = -1L;

        private RejectingBlockingQueue() {
            super(Integer.MAX_VALUE);
        }

        @Override
        public boolean add(Runnable runnable) {
            return false;
        }

        @Override
        public boolean addAll(Collection<? extends Runnable> c) {
            return false;
        }

        @Override
        public int remainingCapacity() {
            return 0;
        }

        @Override
        public void put(Runnable runnable) throws InterruptedException {
            throw new InterruptedException();
        }

        @Override
        public boolean offer(Runnable runnable, long timeout, TimeUnit timeUnit) throws InterruptedException {
            return false;
        }

        @Override
        public boolean offer(@NotNull Runnable runnable) {
            return false;
        }

        private boolean push(@NotNull Runnable runnable) {
            return super.offer(runnable);
        }
    }

    private static class QueueRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private final RejectingBlockingQueue mQueue;

        private QueueRejectedExecutionHandler(@NotNull RejectingBlockingQueue queue) {
            this.mQueue = queue;
        }

        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            this.mQueue.push(runnable);
        }
    }

    private static class CommandRunnable
    implements Runnable {
        private final Runnable mCommand;
        private final ThreadPoolExecutor mExecutor;

        private CommandRunnable(@NotNull ThreadPoolExecutor executor, @NotNull Runnable command) {
            this.mExecutor = executor;
            this.mCommand = command;
        }

        public void run() {
            this.mExecutor.execute(this.mCommand);
        }
    }
}

