/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.runner;

import com.github.dm.jrt.invocation.InvocationInterruptedException;
import com.github.dm.jrt.runner.Execution;
import com.github.dm.jrt.runner.TemplateExecution;
import com.github.dm.jrt.util.TimeDuration;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalQueue {
    private static final EmptyExecution EMPTY_EXECUTION = new EmptyExecution();
    private static final int INITIAL_CAPACITY = 10;
    private static final LocalQueueThreadLocal sQueue = new LocalQueueThreadLocal();
    private TimeUnit[] mDelayUnits;
    private long[] mDelays;
    private long[] mExecutionTimeNs = new long[10];
    private Execution[] mExecutions = new Execution[10];
    private int mFirst;
    private boolean mIsRunning;
    private int mLast;

    private LocalQueue() {
        this.mDelays = new long[10];
        this.mDelayUnits = new TimeUnit[10];
    }

    public static void cancel(@NotNull Execution execution) {
        ((LocalQueue)sQueue.get()).removeExecution(execution);
    }

    public static void run(@NotNull Execution execution, long delay, @NotNull TimeUnit timeUnit) {
        ((LocalQueue)sQueue.get()).addExecution(execution, delay, timeUnit);
    }

    private static void resizeArray(@NotNull long[] src, @NotNull long[] dst, int first) {
        int remainder = src.length - first;
        System.arraycopy(src, 0, dst, 0, first);
        System.arraycopy(src, first, dst, dst.length - remainder, remainder);
    }

    private static <T> void resizeArray(@NotNull T[] src, @NotNull T[] dst, int first) {
        int remainder = src.length - first;
        System.arraycopy(src, 0, dst, 0, first);
        System.arraycopy(src, first, dst, dst.length - remainder, remainder);
    }

    private void add(@NotNull Execution execution, long delay, @NotNull TimeUnit timeUnit) {
        int i = this.mLast;
        this.mExecutionTimeNs[i] = System.nanoTime();
        this.mExecutions[i] = execution;
        this.mDelays[i] = delay;
        this.mDelayUnits[i] = timeUnit;
        int newLast = i >= this.mExecutions.length - 1 || i == Integer.MAX_VALUE ? 0 : i + 1;
        if (this.mFirst == newLast) {
            this.ensureCapacity(this.mExecutions.length + 1);
        }
        this.mLast = newLast;
    }

    private void addExecution(@NotNull Execution execution, long delay, @NotNull TimeUnit timeUnit) {
        this.add(execution, delay, timeUnit);
        if (!this.mIsRunning) {
            this.run();
        }
    }

    private void ensureCapacity(int capacity) {
        int size = this.mExecutions.length;
        if (capacity <= size) {
            return;
        }
        int newSize = size;
        while (newSize < capacity) {
            if ((newSize <<= 1) >= size) continue;
            throw new OutOfMemoryError();
        }
        int first = this.mFirst;
        int last = this.mLast;
        long[] newExecutionTimeNs = new long[newSize];
        LocalQueue.resizeArray(this.mExecutionTimeNs, newExecutionTimeNs, first);
        Execution[] newExecutions = new Execution[newSize];
        LocalQueue.resizeArray(this.mExecutions, newExecutions, first);
        long[] newDelays = new long[newSize];
        LocalQueue.resizeArray(this.mDelays, newDelays, first);
        TimeUnit[] newDelayUnits = new TimeUnit[newSize];
        LocalQueue.resizeArray(this.mDelayUnits, newDelayUnits, first);
        this.mExecutionTimeNs = newExecutionTimeNs;
        this.mExecutions = newExecutions;
        this.mDelays = newDelays;
        this.mDelayUnits = newDelayUnits;
        int shift = newSize - size;
        this.mFirst = first + shift;
        this.mLast = last < first ? last : last + shift;
    }

    private void removeExecution(@NotNull Execution execution) {
        Execution[] executions = this.mExecutions;
        int length = executions.length;
        int last = this.mLast;
        int i = this.mFirst;
        while (i != last) {
            if (executions[i] == execution) {
                executions[i] = EMPTY_EXECUTION;
                this.mDelays[i] = 0L;
                this.mDelayUnits[i] = TimeUnit.NANOSECONDS;
            }
            if (++i < length) continue;
            i = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void run() {
        this.mIsRunning = true;
        try {
            while (this.mFirst != this.mLast) {
                int newFirst;
                int i = this.mFirst;
                int last = this.mLast;
                long[] executionTimeNs = this.mExecutionTimeNs;
                Execution[] executions = this.mExecutions;
                long[] delays = this.mDelays;
                TimeUnit[] delayUnits = this.mDelayUnits;
                long timeNs = executionTimeNs[i];
                Execution execution = executions[i];
                long delay = delays[i];
                TimeUnit delayUnit = delayUnits[i];
                long currentTimeNs = System.nanoTime();
                long delayNs = timeNs - currentTimeNs + delayUnit.toNanos(delay);
                if (delayNs > 0L) {
                    int length = executions.length;
                    long minDelay = delayNs;
                    int s = i;
                    int j = i + 1;
                    if (j >= length) {
                        j = 0;
                    }
                    while (j != last) {
                        long nextDelayNs = executionTimeNs[j] - currentTimeNs + delayUnits[j].toNanos(delays[j]);
                        if (nextDelayNs <= 0L) {
                            s = j;
                            break;
                        }
                        if (nextDelayNs < minDelay) {
                            minDelay = nextDelayNs;
                            s = j;
                        }
                        if (++j < length) continue;
                        j = 0;
                    }
                    if (s != i) {
                        timeNs = executionTimeNs[s];
                        execution = executions[s];
                        delay = delays[s];
                        delayUnit = delayUnits[s];
                        executionTimeNs[s] = executionTimeNs[i];
                        executions[s] = executions[i];
                        delays[s] = delays[i];
                        delayUnits[s] = delayUnits[i];
                    }
                    delayNs = timeNs - System.nanoTime() + delayUnit.toNanos(delay);
                }
                if (delayNs > 0L) {
                    try {
                        TimeDuration.nanos(delayNs).sleepAtLeast();
                    }
                    catch (InterruptedException e) {
                        throw new InvocationInterruptedException(e);
                    }
                }
                try {
                    execution.run();
                    int n = this.mFirst;
                    this.mExecutions[n] = null;
                    this.mDelays[n] = 0L;
                    this.mDelayUnits[n] = TimeUnit.NANOSECONDS;
                    newFirst = n + 1;
                }
                catch (Throwable throwable) {
                    int n = this.mFirst;
                    this.mExecutions[n] = null;
                    this.mDelays[n] = 0L;
                    this.mDelayUnits[n] = TimeUnit.NANOSECONDS;
                    int newFirst2 = n + 1;
                    this.mFirst = newFirst2 < this.mExecutions.length ? newFirst2 : 0;
                    throw throwable;
                    return;
                }
                this.mFirst = newFirst < this.mExecutions.length ? newFirst : 0;
            }
        }
        finally {
            this.mIsRunning = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalQueueThreadLocal
    extends ThreadLocal<LocalQueue> {
        private LocalQueueThreadLocal() {
        }

        @Override
        protected LocalQueue initialValue() {
            return new LocalQueue();
        }
    }

    private static class EmptyExecution
    extends TemplateExecution {
        private EmptyExecution() {
        }

        public void run() {
        }
    }
}

