/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.runner;

import com.github.dm.jrt.runner.Execution;
import com.github.dm.jrt.runner.Runner;
import com.github.dm.jrt.runner.TemplateExecution;
import com.github.dm.jrt.util.WeakIdentityHashMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

public class PriorityRunner {
    private static final PriorityExecutionComparator PRIORITY_EXECUTION_COMPARATOR = new PriorityExecutionComparator();
    private static final WeakIdentityHashMap<Runner, PriorityRunner> sRunners = new WeakIdentityHashMap();
    private final AtomicLong mAge = new AtomicLong(9223372034707292160L);
    private final Map<PriorityExecution, DelayedExecution> mDelayedExecutions = Collections.synchronizedMap(new WeakIdentityHashMap());
    private final WeakIdentityHashMap<Execution, WeakHashMap<PriorityExecution, Void>> mExecutions = new WeakIdentityHashMap();
    private final PriorityBlockingQueue<PriorityExecution> mQueue;
    private final TemplateExecution mExecution = new TemplateExecution(){

        public void run() {
            PriorityExecution execution = (PriorityExecution)PriorityRunner.this.mQueue.poll();
            if (execution != null) {
                execution.run();
            }
        }
    };
    private final Runner mRunner;
    private final WeakHashMap<QueuingRunner, Void> mRunners = new WeakHashMap();

    private PriorityRunner(@NotNull Runner wrapped) {
        if (wrapped == null) {
            throw new NullPointerException("the wrapped runner must not be null");
        }
        this.mRunner = wrapped;
        this.mQueue = new PriorityBlockingQueue<PriorityExecution>(10, PRIORITY_EXECUTION_COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static PriorityRunner getInstance(@NotNull Runner wrapped) {
        if (wrapped instanceof QueuingRunner) {
            return ((QueuingRunner)wrapped).enclosingRunner();
        }
        WeakIdentityHashMap<Runner, PriorityRunner> weakIdentityHashMap = sRunners;
        synchronized (weakIdentityHashMap) {
            WeakIdentityHashMap<Runner, PriorityRunner> runners = sRunners;
            PriorityRunner runner = runners.get(wrapped);
            if (runner == null) {
                runner = new PriorityRunner(wrapped);
                runners.put(wrapped, runner);
            }
            return runner;
        }
    }

    private static int compareLong(long l1, long l2) {
        return l1 < l2 ? -1 : (l1 == l2 ? 0 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Runner getRunner(int priority) {
        WeakHashMap<QueuingRunner, Void> weakHashMap = this.mRunners;
        synchronized (weakHashMap) {
            WeakHashMap<QueuingRunner, Void> runners = this.mRunners;
            for (QueuingRunner runner : runners.keySet()) {
                if (runner.mPriority != priority) continue;
                return runner;
            }
            QueuingRunner runner = new QueuingRunner(priority);
            runners.put(runner, null);
            return runner;
        }
    }

    private class QueuingRunner
    implements Runner {
        private final int mPriority;

        private QueuingRunner(int priority) {
            this.mPriority = priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(@NotNull Execution execution) {
            WeakIdentityHashMap weakIdentityHashMap = PriorityRunner.this.mExecutions;
            synchronized (weakIdentityHashMap) {
                WeakHashMap priorityExecutions = (WeakHashMap)PriorityRunner.this.mExecutions.remove(execution);
                if (priorityExecutions != null) {
                    Runner runner = PriorityRunner.this.mRunner;
                    PriorityBlockingQueue queue = PriorityRunner.this.mQueue;
                    Map delayedExecutions = PriorityRunner.this.mDelayedExecutions;
                    for (PriorityExecution priorityExecution : priorityExecutions.keySet()) {
                        if (queue.remove(priorityExecution)) continue;
                        runner.cancel((Execution)delayedExecutions.remove(priorityExecution));
                    }
                }
            }
        }

        public boolean isExecutionThread() {
            return PriorityRunner.this.mRunner.isExecutionThread();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull Execution execution, long delay, @NotNull TimeUnit timeUnit) {
            boolean mayBeCanceled = execution.mayBeCanceled();
            PriorityExecution priorityExecution = new PriorityExecution(execution, this.mPriority, PriorityRunner.this.mAge.getAndDecrement());
            if (mayBeCanceled) {
                WeakIdentityHashMap weakIdentityHashMap = PriorityRunner.this.mExecutions;
                synchronized (weakIdentityHashMap) {
                    WeakIdentityHashMap executions = PriorityRunner.this.mExecutions;
                    WeakHashMap<PriorityExecution, Object> priorityExecutions = (WeakHashMap<PriorityExecution, Object>)executions.get(execution);
                    if (priorityExecutions == null) {
                        priorityExecutions = new WeakHashMap<PriorityExecution, Object>();
                        executions.put(execution, priorityExecutions);
                    }
                    priorityExecutions.put(priorityExecution, null);
                }
            }
            if (delay == 0L) {
                PriorityRunner.this.mQueue.put(priorityExecution);
                PriorityRunner.this.mRunner.run(PriorityRunner.this.mExecution, 0L, timeUnit);
            } else {
                DelayedExecution delayedExecution = new DelayedExecution(PriorityRunner.this.mQueue, priorityExecution);
                if (mayBeCanceled) {
                    PriorityRunner.this.mDelayedExecutions.put(priorityExecution, delayedExecution);
                }
                PriorityRunner.this.mRunner.run(delayedExecution, delay, timeUnit);
            }
        }

        private PriorityRunner enclosingRunner() {
            return PriorityRunner.this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PriorityExecutionComparator
    implements Comparator<PriorityExecution>,
    Serializable {
        private static final long serialVersionUID = -1L;

        private PriorityExecutionComparator() {
        }

        @Override
        public int compare(PriorityExecution e1, PriorityExecution e2) {
            int thisPriority = e1.mPriority;
            long thisAge = e1.mAge;
            int thatPriority = e2.mPriority;
            long thatAge = e2.mAge;
            int compare = PriorityRunner.compareLong(thatAge + (long)thatPriority, thisAge + (long)thisPriority);
            return compare == 0 ? PriorityRunner.compareLong(thatAge, thisAge) : compare;
        }
    }

    private static class PriorityExecution
    implements Execution {
        private final long mAge;
        private final Execution mExecution;
        private final int mPriority;

        private PriorityExecution(@NotNull Execution execution, int priority, long age) {
            this.mExecution = execution;
            this.mPriority = priority;
            this.mAge = age;
        }

        public boolean mayBeCanceled() {
            return this.mExecution.mayBeCanceled();
        }

        public void run() {
            this.mExecution.run();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelayedExecution
    implements Execution {
        private final PriorityExecution mExecution;
        private final PriorityBlockingQueue<PriorityExecution> mQueue;

        private DelayedExecution(@NotNull PriorityBlockingQueue<PriorityExecution> queue, @NotNull PriorityExecution execution) {
            this.mQueue = queue;
            this.mExecution = execution;
        }

        @Override
        public boolean mayBeCanceled() {
            return this.mExecution.mayBeCanceled();
        }

        @Override
        public void run() {
            PriorityBlockingQueue<PriorityExecution> queue = this.mQueue;
            queue.put(this.mExecution);
            PriorityExecution execution = queue.poll();
            if (execution != null) {
                execution.run();
            }
        }
    }
}

