/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.runner;

import com.github.dm.jrt.runner.DynamicScheduledThreadExecutor;
import com.github.dm.jrt.runner.PriorityRunner;
import com.github.dm.jrt.runner.QueuedRunner;
import com.github.dm.jrt.runner.Runner;
import com.github.dm.jrt.runner.ScheduledRunner;
import com.github.dm.jrt.runner.ThrottlingRunner;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class Runners {
    private static final Object sMutex = new Object();
    private static final QueuedRunner sQueuedRunner = new QueuedRunner();
    private static Runner sSharedRunner;

    protected Runners() {
    }

    @NotNull
    public static Runner dynamicPoolRunner(int corePoolSize, int maximumPoolSize, long keepAliveTime, @NotNull TimeUnit keepAliveUnit) {
        return Runners.scheduledRunner(new DynamicScheduledThreadExecutor(corePoolSize, maximumPoolSize, keepAliveTime, keepAliveUnit));
    }

    @NotNull
    public static Runner poolRunner() {
        return Runners.poolRunner(Runtime.getRuntime().availableProcessors() << 1);
    }

    @NotNull
    public static Runner poolRunner(int poolSize) {
        return Runners.scheduledRunner(Executors.newScheduledThreadPool(poolSize));
    }

    @NotNull
    public static PriorityRunner priorityRunner(@NotNull Runner wrapped) {
        return PriorityRunner.getInstance(wrapped);
    }

    @NotNull
    public static Runner scheduledRunner(@NotNull ScheduledExecutorService service) {
        return new ScheduledRunner(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Runner sharedRunner() {
        Object object = sMutex;
        synchronized (object) {
            if (sSharedRunner == null) {
                int processors = Runtime.getRuntime().availableProcessors();
                sSharedRunner = Runners.dynamicPoolRunner(processors <= 2 ? processors : processors - 1, (processors << 3) - 1, 3L, TimeUnit.SECONDS);
            }
            return sSharedRunner;
        }
    }

    @NotNull
    public static Runner syncRunner() {
        return sQueuedRunner;
    }

    @NotNull
    public static Runner throttlingRunner(@NotNull Runner wrapped, int maxExecutions) {
        return new ThrottlingRunner(wrapped, maxExecutions);
    }
}

