/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.runner;

import com.github.dm.jrt.runner.Execution;
import com.github.dm.jrt.runner.Runner;
import com.github.dm.jrt.util.WeakIdentityHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

class ScheduledRunner
implements Runner {
    private final WeakIdentityHashMap<Execution, WeakHashMap<ScheduledFuture<?>, Void>> mFutures = new WeakIdentityHashMap();
    private final ScheduledExecutorService mService;
    private final Map<Thread, Void> mThreads = Collections.synchronizedMap(new WeakIdentityHashMap());

    ScheduledRunner(@NotNull ScheduledExecutorService service) {
        if (service == null) {
            throw new NullPointerException("the executor service must not be null");
        }
        this.mService = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(@NotNull Execution execution) {
        WeakIdentityHashMap<Execution, WeakHashMap<ScheduledFuture<?>, Void>> weakIdentityHashMap = this.mFutures;
        synchronized (weakIdentityHashMap) {
            WeakHashMap<ScheduledFuture<?>, Void> scheduledFutures = this.mFutures.remove(execution);
            if (scheduledFutures != null) {
                for (ScheduledFuture<?> future : scheduledFutures.keySet()) {
                    future.cancel(false);
                }
            }
        }
    }

    public boolean isExecutionThread() {
        return this.mThreads.containsKey(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull Execution execution, long delay, @NotNull TimeUnit timeUnit) {
        ScheduledFuture<?> future = this.mService.schedule(new ExecutionWrapper(execution, this.mThreads), delay, timeUnit);
        if (execution.mayBeCanceled()) {
            WeakIdentityHashMap<Execution, WeakHashMap<ScheduledFuture<?>, Void>> weakIdentityHashMap = this.mFutures;
            synchronized (weakIdentityHashMap) {
                WeakIdentityHashMap<Execution, WeakHashMap<ScheduledFuture<?>, Void>> futures = this.mFutures;
                WeakHashMap<ScheduledFuture<Object>, Void> scheduledFutures = futures.get(execution);
                if (scheduledFutures == null) {
                    scheduledFutures = new WeakHashMap();
                    futures.put(execution, scheduledFutures);
                }
                scheduledFutures.put(future, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExecutionWrapper
    implements Runnable {
        private final Thread mCurrentThread;
        private final Execution mExecution;
        private final Map<Thread, Void> mThreads;

        private ExecutionWrapper(@NotNull Execution wrapped, @NotNull Map<Thread, Void> threads) {
            this.mExecution = wrapped;
            this.mThreads = threads;
            this.mCurrentThread = Thread.currentThread();
        }

        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            if (currentThread != this.mCurrentThread) {
                this.mThreads.put(currentThread, null);
            }
            this.mExecution.run();
        }
    }
}

