/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.runner;

import com.github.dm.jrt.runner.Execution;
import com.github.dm.jrt.runner.Runner;
import com.github.dm.jrt.runner.TemplateExecution;
import com.github.dm.jrt.util.WeakIdentityHashMap;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

class ThrottlingRunner
implements Runner {
    private final WeakIdentityHashMap<Execution, WeakReference<ThrottlingExecution>> mExecutions = new WeakIdentityHashMap();
    private final int mMaxRunning;
    private final Object mMutex = new Object();
    private final LinkedList<PendingExecution> mQueue = new LinkedList();
    private final Runner mRunner;
    private int mRunningCount;

    ThrottlingRunner(@NotNull Runner wrapped, int maxExecutions) {
        if (wrapped == null) {
            throw new NullPointerException("the wrapped runner must not be null");
        }
        if (maxExecutions < 1) {
            throw new IllegalArgumentException("the maximum number of running executions must be at least 1, while it was: " + maxExecutions);
        }
        this.mRunner = wrapped;
        this.mMaxRunning = maxExecutions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(@NotNull Execution execution) {
        ThrottlingExecution throttlingExecution = null;
        Object object = this.mMutex;
        synchronized (object) {
            Iterator iterator = this.mQueue.iterator();
            while (iterator.hasNext()) {
                PendingExecution pendingExecution = (PendingExecution)iterator.next();
                if (pendingExecution.mExecution != execution) continue;
                iterator.remove();
            }
            WeakReference<ThrottlingExecution> executionReference = this.mExecutions.get(execution);
            if (executionReference != null) {
                throttlingExecution = (ThrottlingExecution)executionReference.get();
            }
        }
        if (throttlingExecution != null) {
            this.mRunner.cancel(throttlingExecution);
        }
    }

    public boolean isExecutionThread() {
        return this.mRunner.isExecutionThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull Execution execution, long delay, @NotNull TimeUnit timeUnit) {
        ThrottlingExecution throttlingExecution = null;
        Object object = this.mMutex;
        synchronized (object) {
            LinkedList<PendingExecution> queue = this.mQueue;
            if (this.mRunningCount + queue.size() >= this.mMaxRunning) {
                queue.add(new PendingExecution(execution, delay, timeUnit));
            } else {
                throttlingExecution = this.getThrottlingExecution(execution);
            }
        }
        if (throttlingExecution != null) {
            this.mRunner.run(throttlingExecution, delay, timeUnit);
        }
    }

    @NotNull
    private ThrottlingExecution getThrottlingExecution(@NotNull Execution execution) {
        ThrottlingExecution throttlingExecution;
        WeakReference<ThrottlingExecution> executionReference = this.mExecutions.get(execution);
        ThrottlingExecution throttlingExecution2 = throttlingExecution = executionReference != null ? (ThrottlingExecution)executionReference.get() : null;
        if (throttlingExecution == null) {
            throttlingExecution = new ThrottlingExecution(execution);
            if (execution.mayBeCanceled()) {
                this.mExecutions.put(execution, new WeakReference<ThrottlingExecution>(throttlingExecution));
            }
        }
        return throttlingExecution;
    }

    private class ThrottlingExecution
    implements Execution {
        private final Execution mExecution;

        private ThrottlingExecution(Execution execution) {
            this.mExecution = execution;
        }

        public boolean mayBeCanceled() {
            return this.mExecution.mayBeCanceled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            int maxRunning = ThrottlingRunner.this.mMaxRunning;
            Execution execution = this.mExecution;
            LinkedList queue = ThrottlingRunner.this.mQueue;
            Object object = ThrottlingRunner.this.mMutex;
            synchronized (object) {
                if (ThrottlingRunner.this.mRunningCount >= maxRunning) {
                    queue.addFirst(new PendingExecution(execution, 0L, TimeUnit.MILLISECONDS));
                    return;
                }
                ++ThrottlingRunner.this.mRunningCount;
            }
            try {
                execution.run();
            }
            finally {
                PendingExecution pendingExecution = null;
                Object object2 = ThrottlingRunner.this.mMutex;
                synchronized (object2) {
                    if (--ThrottlingRunner.this.mRunningCount < maxRunning && !queue.isEmpty()) {
                        pendingExecution = (PendingExecution)queue.removeFirst();
                    }
                }
                if (pendingExecution != null) {
                    pendingExecution.run();
                }
            }
        }
    }

    private class PendingExecution
    extends TemplateExecution {
        private final long mDelay;
        private final Execution mExecution;
        private final TimeUnit mTimeUnit;

        private PendingExecution(Execution execution, @NotNull long delay, TimeUnit timeUnit) {
            this.mExecution = execution;
            this.mDelay = delay;
            this.mTimeUnit = timeUnit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ThrottlingExecution throttlingExecution;
            Object object = ThrottlingRunner.this.mMutex;
            synchronized (object) {
                throttlingExecution = ThrottlingRunner.this.getThrottlingExecution(this.mExecution);
            }
            ThrottlingRunner.this.mRunner.run(throttlingExecution, this.mDelay, this.mTimeUnit);
        }
    }
}

