/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassToken<TYPE> {
    private Type mGenericType;
    private Class<TYPE> mRawClass;

    @NotNull
    public static <TYPE> ClassToken<TYPE> tokenOf(@NotNull Class<TYPE> rawClass) {
        if (rawClass == null) {
            throw new NullPointerException("the classification raw type must not be null");
        }
        DefaultClassToken classToken = new DefaultClassToken();
        classToken.mGenericType = rawClass;
        classToken.mRawClass = rawClass;
        return classToken;
    }

    @NotNull
    public static <TYPE> ClassToken<TYPE> tokenOf(@NotNull TYPE object) {
        return ClassToken.tokenOf(object.getClass());
    }

    public final TYPE cast(Object object) {
        return (TYPE)object;
    }

    @NotNull
    public final Type getGenericType() {
        if (this.mGenericType == null) {
            Class<?> subClass = this.getClass();
            Class<?> superClass = subClass.getSuperclass();
            while (!ClassToken.class.equals(superClass)) {
                subClass = superClass;
                superClass = subClass.getSuperclass();
            }
            Type type = subClass.getGenericSuperclass();
            if (type instanceof ParameterizedType) {
                ParameterizedType paramType = (ParameterizedType)type;
                this.mGenericType = paramType.getActualTypeArguments()[0];
            } else {
                this.mGenericType = Object.class;
            }
        }
        return this.mGenericType;
    }

    @NotNull
    public final Class<TYPE> getRawClass() {
        if (this.mRawClass == null) {
            Type type = this.getGenericType();
            if (type instanceof Class) {
                this.mRawClass = (Class)type;
            } else if (type instanceof ParameterizedType) {
                this.mRawClass = (Class)((ParameterizedType)type).getRawType();
            } else {
                throw new IllegalStateException("the class does not correctly extend a class token: " + this.getClass().getName());
            }
        }
        return this.mRawClass;
    }

    public int hashCode() {
        return this.getRawClass().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassToken)) {
            return false;
        }
        ClassToken that = (ClassToken)o;
        return this.getRawClass().equals(that.getRawClass());
    }

    public final boolean isAssignableFrom(@NotNull ClassToken<?> other) {
        return this.getRawClass().isAssignableFrom(other.getRawClass());
    }

    public final boolean isInterface() {
        return this.getRawClass().isInterface();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultClassToken<TYPE>
    extends ClassToken<TYPE> {
        private DefaultClassToken() {
        }
    }
}

