/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflection {
    public static final Object[] NO_ARGS = new Object[0];
    private static final HashMap<Class<?>, Class<?>> sBoxingClasses = new HashMap(9);

    protected Reflection() {
    }

    @NotNull
    public static Object[] asArgs(Object ... args) {
        return args != null ? args : NO_ARGS;
    }

    @NotNull
    public static Class<?> boxingClass(@NotNull Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        return sBoxingClasses.get(type);
    }

    @NotNull
    public static <TYPE> Constructor<TYPE> findConstructor(@NotNull Class<TYPE> type, Object ... args) {
        Constructor<?> constructor = Reflection.findBestMatchingConstructor(type.getConstructors(), args);
        if (constructor == null && (constructor = Reflection.findBestMatchingConstructor(type.getDeclaredConstructors(), args)) == null) {
            throw new IllegalArgumentException("no suitable constructor found for type: " + type.getName());
        }
        return Reflection.makeAccessible(constructor);
    }

    @NotNull
    public static Method findMethod(@NotNull Class<?> type, @NotNull String name, Class<?> ... parameterTypes) {
        Method method;
        try {
            method = type.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException ignored) {
            try {
                method = type.getDeclaredMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return method;
    }

    public static boolean hasStaticContext(@NotNull Class<?> type) {
        return type.getEnclosingClass() == null || Modifier.isStatic(type.getModifiers());
    }

    @NotNull
    public static Constructor<?> makeAccessible(@NotNull Constructor<?> constructor) {
        if (!constructor.isAccessible()) {
            AccessController.doPrivileged(new SetAccessibleConstructorAction(constructor));
        }
        return constructor;
    }

    @NotNull
    public static Method makeAccessible(@NotNull Method method) {
        if (!method.isAccessible()) {
            AccessController.doPrivileged(new SetAccessibleMethodAction(method));
        }
        return method;
    }

    @Nullable
    private static Constructor<?> findBestMatchingConstructor(@NotNull Constructor<?>[] constructors, @NotNull Object[] args) {
        int argsLength = args.length;
        Constructor<?> bestMatch = null;
        int maxConfidence = 0;
        for (Constructor<?> constructor : constructors) {
            Class<?>[] params = constructor.getParameterTypes();
            int length = params.length;
            if (length != argsLength) continue;
            boolean isValid = true;
            int confidence = 0;
            for (int i = 0; i < argsLength; ++i) {
                Object contextArg = args[i];
                Class<?> param = params[i];
                if (contextArg != null) {
                    Class<?> boxingClass = Reflection.boxingClass(param);
                    if (!boxingClass.isInstance(contextArg)) {
                        isValid = false;
                        break;
                    }
                    if (!contextArg.getClass().equals(boxingClass)) continue;
                    ++confidence;
                    continue;
                }
                if (!param.isPrimitive()) continue;
                isValid = false;
                break;
            }
            if (!isValid) continue;
            if (bestMatch == null || confidence > maxConfidence) {
                bestMatch = constructor;
                maxConfidence = confidence;
                continue;
            }
            if (confidence != maxConfidence) continue;
            throw new IllegalArgumentException("more than one constructor found for arguments: " + Arrays.toString(args));
        }
        return bestMatch;
    }

    static {
        HashMap<Class<?>, Class<?>> boxMap = sBoxingClasses;
        boxMap.put(Boolean.TYPE, Boolean.class);
        boxMap.put(Byte.TYPE, Byte.class);
        boxMap.put(Character.TYPE, Character.class);
        boxMap.put(Double.TYPE, Double.class);
        boxMap.put(Float.TYPE, Float.class);
        boxMap.put(Integer.TYPE, Integer.class);
        boxMap.put(Long.TYPE, Long.class);
        boxMap.put(Short.TYPE, Short.class);
        boxMap.put(Void.TYPE, Void.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetAccessibleMethodAction
    implements PrivilegedAction<Void> {
        private final Method mMethod;

        private SetAccessibleMethodAction(@NotNull Method method) {
            this.mMethod = method;
        }

        @Override
        public Void run() {
            this.mMethod.setAccessible(true);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetAccessibleConstructorAction
    implements PrivilegedAction<Void> {
        private final Constructor<?> mmConstructor;

        private SetAccessibleConstructorAction(@NotNull Constructor<?> constructor) {
            this.mmConstructor = constructor;
        }

        @Override
        public Void run() {
            this.mmConstructor.setAccessible(true);
            return null;
        }
    }
}

