/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.util;

import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class Time {
    public static final long HOURS_IN_DAY = 24L;
    public static final long MINUTES_IN_HOUR = 60L;
    public static final long MINUTES_IN_DAY = 1440L;
    public static final long SECONDS_IN_MINUTE = 60L;
    public static final long SECONDS_IN_HOUR = 3600L;
    public static final long SECONDS_IN_DAY = 86400L;
    protected static final long MAX_DAYS = 106751991167300L;
    protected static final long MAX_HOURS = 2562047788015215L;
    protected static final long MAX_MINUTES = 0x222222222222222L;
    public final long time;
    public final TimeUnit unit;

    protected Time(long time, @NotNull TimeUnit unit) {
        this.time = time;
        this.unit = unit;
    }

    @NotNull
    public static Time current() {
        return Time.millis(System.currentTimeMillis());
    }

    @NotNull
    public static Time currentNano() {
        return Time.nanos(System.nanoTime());
    }

    @NotNull
    public static Time days(long days) {
        if (days > 106751991167300L || days < -106751991167300L) {
            throw new IllegalArgumentException("time value overflow: " + days + " days");
        }
        return new Time(days * 86400L, TimeUnit.SECONDS);
    }

    @NotNull
    public static Time fromUnit(long time, @NotNull TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("the time unit must not be null");
        }
        return new Time(time, unit);
    }

    @NotNull
    public static Time hours(long hours) {
        if (hours > 2562047788015215L || hours < -2562047788015215L) {
            throw new IllegalArgumentException("time value overflow: " + hours + " hours");
        }
        return new Time(hours * 3600L, TimeUnit.SECONDS);
    }

    @NotNull
    public static Time micros(long micros) {
        return new Time(micros, TimeUnit.MICROSECONDS);
    }

    @NotNull
    public static Time millis(long millis) {
        return new Time(millis, TimeUnit.MILLISECONDS);
    }

    @NotNull
    public static Time minutes(long minutes) {
        if (minutes > 0x222222222222222L || minutes < -153722867280912930L) {
            throw new IllegalArgumentException("time value overflow: " + minutes + " minutes");
        }
        return new Time(minutes * 60L, TimeUnit.SECONDS);
    }

    @NotNull
    public static Time nanos(long nanos) {
        return new Time(nanos, TimeUnit.NANOSECONDS);
    }

    @NotNull
    public static Time seconds(long seconds) {
        return new Time(seconds, TimeUnit.SECONDS);
    }

    @NotNull
    public Time daysTime() {
        return Time.days(this.toDays());
    }

    public int hashCode() {
        int result = (int)(this.time ^ this.time >>> 32);
        result = 31 * result + this.unit.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Time)) {
            return false;
        }
        Time that = (Time)o;
        if (this.unit != that.unit) {
            return this.to(that.unit) == that.time && that.to(this.unit) == this.time;
        }
        return this.time == that.time;
    }

    public String toString() {
        return this.time + " " + this.unit.toString();
    }

    @NotNull
    public Time hoursTime() {
        return Time.hours(this.toHours());
    }

    public boolean isZero() {
        return this.time == 0L;
    }

    @NotNull
    public Time microsTime() {
        return Time.micros(this.toMicros());
    }

    @NotNull
    public Time millisTime() {
        return Time.millis(this.toMillis());
    }

    @NotNull
    public Time minus(@NotNull Time time) {
        if (this.unit.compareTo(time.unit) > 0) {
            return Time.fromUnit(time.unit.convert(this.time, this.unit) - time.time, time.unit);
        }
        return Time.fromUnit(this.time - this.unit.convert(time.time, time.unit), this.unit);
    }

    @NotNull
    public Time minutesTime() {
        return Time.minutes(this.toMinutes());
    }

    @NotNull
    public Time nanosTime() {
        return Time.nanos(this.toNanos());
    }

    @NotNull
    public Time plus(@NotNull Time time) {
        if (this.unit.compareTo(time.unit) > 0) {
            return Time.fromUnit(time.unit.convert(this.time, this.unit) + time.time, time.unit);
        }
        return Time.fromUnit(this.time + this.unit.convert(time.time, time.unit), this.unit);
    }

    @NotNull
    public Time secondsTime() {
        return Time.seconds(this.toSeconds());
    }

    public long to(@NotNull TimeUnit timeUnit) {
        return timeUnit.convert(this.time, this.unit);
    }

    public long toDays() {
        return this.unit.toSeconds(this.time) / 86400L;
    }

    public long toHours() {
        return this.unit.toSeconds(this.time) / 3600L;
    }

    public long toMicros() {
        return this.unit.toMicros(this.time);
    }

    public long toMillis() {
        return this.unit.toMillis(this.time);
    }

    public long toMinutes() {
        return this.unit.toSeconds(this.time) / 60L;
    }

    public long toNanos() {
        return this.unit.toNanos(this.time);
    }

    public long toSeconds() {
        return this.unit.toSeconds(this.time);
    }
}

