/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.util;

import com.github.dm.jrt.util.Time;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class TimeDuration
extends Time {
    public static final TimeDuration INFINITY = TimeDuration.seconds(Long.MAX_VALUE);
    public static final TimeDuration ZERO = TimeDuration.seconds(0L);
    private static final long MILLI_DAYS_OVERFLOW = 106751991167L;
    private static final long NANO_DAYS_OVERFLOW = 106750L;
    private static final long ONE_MILLI_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);

    protected TimeDuration(long duration, @NotNull TimeUnit unit) {
        super(duration, unit);
        if (duration < 0L) {
            throw new IllegalArgumentException("the time duration cannot be negative: " + duration);
        }
    }

    @NotNull
    public static TimeDuration days(long days) {
        if (days > 106751991167300L || days < -106751991167300L) {
            throw new IllegalArgumentException("time value overflow: " + days + " days");
        }
        return new TimeDuration(days * 86400L, TimeUnit.SECONDS);
    }

    @NotNull
    public static TimeDuration fromUnit(long time, @NotNull TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("the time unit must not be null");
        }
        return new TimeDuration(time, unit);
    }

    @NotNull
    public static TimeDuration hours(long hours) {
        if (hours > 2562047788015215L || hours < -2562047788015215L) {
            throw new IllegalArgumentException("time value overflow: " + hours + " hours");
        }
        return new TimeDuration(hours * 3600L, TimeUnit.SECONDS);
    }

    @NotNull
    public static TimeDuration micros(long micros) {
        return new TimeDuration(micros, TimeUnit.MICROSECONDS);
    }

    @NotNull
    public static TimeDuration millis(long millis) {
        return new TimeDuration(millis, TimeUnit.MILLISECONDS);
    }

    @NotNull
    public static TimeDuration minutes(long minutes) {
        if (minutes > 0x222222222222222L || minutes < -153722867280912930L) {
            throw new IllegalArgumentException("time value overflow: " + minutes + " minutes");
        }
        return new TimeDuration(minutes * 60L, TimeUnit.SECONDS);
    }

    @NotNull
    public static TimeDuration nanos(long nanos) {
        return new TimeDuration(nanos, TimeUnit.NANOSECONDS);
    }

    @NotNull
    public static TimeDuration seconds(long seconds) {
        return new TimeDuration(seconds, TimeUnit.SECONDS);
    }

    @NotNull
    public static TimeDuration timeSinceMillis(long milliTime) {
        long millis = System.currentTimeMillis() - milliTime;
        return millis > 0L ? TimeDuration.millis(millis) : ZERO;
    }

    @NotNull
    public static TimeDuration timeSinceNanos(long nanoTime) {
        long nanos = System.nanoTime() - nanoTime;
        return nanos > 0L ? TimeDuration.nanos(nanos) : ZERO;
    }

    @NotNull
    public static TimeDuration timeUntilMillis(long milliTime) {
        long millis = milliTime - System.currentTimeMillis();
        return millis > 0L ? TimeDuration.millis(millis) : ZERO;
    }

    @NotNull
    public static TimeDuration timeUntilNanos(long nanoTime) {
        long nanos = nanoTime - System.nanoTime();
        return nanos > 0L ? TimeDuration.nanos(nanos) : ZERO;
    }

    @NotNull
    public TimeDuration daysTime() {
        return TimeDuration.days(this.toDays());
    }

    @NotNull
    public TimeDuration hoursTime() {
        return TimeDuration.hours(this.toHours());
    }

    @NotNull
    public TimeDuration microsTime() {
        return TimeDuration.micros(this.toMicros());
    }

    @NotNull
    public TimeDuration millisTime() {
        return TimeDuration.millis(this.toMillis());
    }

    @NotNull
    public TimeDuration minus(@NotNull Time time) {
        if (this.unit.compareTo(time.unit) > 0) {
            return TimeDuration.fromUnit(Math.max(0L, time.unit.convert(this.time, this.unit) - time.time), time.unit);
        }
        return TimeDuration.fromUnit(Math.max(0L, this.time - this.unit.convert(time.time, time.unit)), this.unit);
    }

    @NotNull
    public TimeDuration minutesTime() {
        return TimeDuration.minutes(this.toMinutes());
    }

    @NotNull
    public TimeDuration nanosTime() {
        return TimeDuration.nanos(this.toNanos());
    }

    @NotNull
    public TimeDuration plus(@NotNull Time time) {
        if (this.unit.compareTo(time.unit) > 0) {
            return TimeDuration.fromUnit(Math.max(0L, time.unit.convert(this.time, this.unit) + time.time), time.unit);
        }
        return TimeDuration.fromUnit(Math.max(0L, this.time + this.unit.convert(time.time, time.unit)), this.unit);
    }

    @NotNull
    public TimeDuration secondsTime() {
        return TimeDuration.seconds(this.toSeconds());
    }

    public boolean isInfinity() {
        return this.equals(INFINITY);
    }

    public void join(@NotNull Thread target) throws InterruptedException {
        this.unit.timedJoin(target, this.time);
    }

    public void sleep() throws InterruptedException {
        this.unit.sleep(this.time);
    }

    public void sleepAtLeast() throws InterruptedException {
        if (this.isZero()) {
            return;
        }
        if (this.toNanos() % ONE_MILLI_NANOS == 0L || this.toDays() > 106750L) {
            long startMillis = System.currentTimeMillis();
            while (this.sleepSinceMillis(startMillis)) {
            }
            return;
        }
        long startNanos = System.nanoTime();
        while (this.sleepSinceNanos(startNanos)) {
        }
    }

    public boolean sleepSinceMillis(long milliTime) throws InterruptedException {
        if (this.isZero()) {
            return false;
        }
        if (this.toDays() > 106751991167L) {
            throw new IllegalStateException("the duration overflows the maximum sleep time: " + this.toDays() + " days");
        }
        long millisToSleep = milliTime - System.currentTimeMillis() + this.toMillis();
        if (millisToSleep <= 0L) {
            return false;
        }
        TimeUnit.MILLISECONDS.sleep(millisToSleep);
        return true;
    }

    public boolean sleepSinceNanos(long nanoTime) throws InterruptedException {
        if (this.isZero()) {
            return false;
        }
        if (this.toDays() > 106750L) {
            throw new IllegalStateException("the duration overflows the maximum sleep time: " + this.toDays() + " days");
        }
        long nanosToSleep = nanoTime - System.nanoTime() + this.toNanos();
        if (nanosToSleep <= 0L) {
            return false;
        }
        TimeUnit.NANOSECONDS.sleep(nanosToSleep);
        return true;
    }

    public void wait(@NotNull Object target) throws InterruptedException {
        if (this.isZero()) {
            return;
        }
        if (this.isInfinity()) {
            target.wait();
            return;
        }
        this.unit.timedWait(target, this.time);
    }

    public boolean waitSinceMillis(@NotNull Object target, long milliTime) throws InterruptedException {
        if (this.isZero()) {
            return false;
        }
        if (this.isInfinity() || this.toDays() > 106751991167L) {
            target.wait();
            return true;
        }
        long millisToWait = milliTime - System.currentTimeMillis() + this.toMillis();
        if (millisToWait <= 0L) {
            return false;
        }
        TimeUnit.MILLISECONDS.timedWait(target, millisToWait);
        return true;
    }

    public boolean waitSinceNanos(@NotNull Object target, long nanoTime) throws InterruptedException {
        if (this.isZero()) {
            return false;
        }
        if (this.isInfinity() || this.toDays() > 106750L) {
            target.wait();
            return true;
        }
        long nanosToWait = nanoTime - System.nanoTime() + this.toNanos();
        if (nanosToWait <= 0L) {
            return false;
        }
        TimeUnit.NANOSECONDS.timedWait(target, nanosToWait);
        return true;
    }

    public boolean waitTrue(@NotNull Object target, @NotNull Check check) throws InterruptedException {
        if (this.isZero()) {
            return check.isTrue();
        }
        if (this.isInfinity()) {
            while (!check.isTrue()) {
                target.wait();
            }
            return true;
        }
        if (this.toNanos() % ONE_MILLI_NANOS == 0L) {
            long startMillis = System.currentTimeMillis();
            while (!check.isTrue()) {
                if (this.waitSinceMillis(target, startMillis)) continue;
                return false;
            }
        } else {
            long startNanos = System.nanoTime();
            while (!check.isTrue()) {
                if (this.waitSinceNanos(target, startNanos)) continue;
                return false;
            }
        }
        return true;
    }

    public static interface Check {
        public boolean isTrue();
    }
}

