/*
 * Decompiled with CFR 0.152.
 */
package com.github.dm.jrt.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakIdentityHashMap<K, V>
implements Map<K, V> {
    private final HashMap<IdentityWeakReference, V> mMap;
    private final ReferenceQueue<Object> mQueue = new ReferenceQueue();
    private AbstractSet<Map.Entry<K, V>> mEntrySet;
    private AbstractSet<K> mKeySet;

    public WeakIdentityHashMap() {
        this.mMap = new HashMap();
    }

    public WeakIdentityHashMap(@NotNull Map<? extends K, ? extends V> map) {
        this.mMap = new HashMap(map.size());
        this.putAll(map);
    }

    public WeakIdentityHashMap(int initialCapacity) {
        this.mMap = new HashMap(initialCapacity);
    }

    public WeakIdentityHashMap(int initialCapacity, float loadFactor) {
        this.mMap = new HashMap(initialCapacity, loadFactor);
    }

    @Override
    public int hashCode() {
        return this.mMap.hashCode();
    }

    @Override
    public int size() {
        this.cleanUp();
        return this.mMap.size();
    }

    @Override
    public boolean isEmpty() {
        this.cleanUp();
        return this.mMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        this.cleanUp();
        return this.mMap.containsKey(new IdentityWeakReference(o));
    }

    @Override
    public boolean containsValue(Object o) {
        this.cleanUp();
        return this.mMap.containsValue(o);
    }

    @Override
    public V get(Object o) {
        this.cleanUp();
        return this.mMap.get(new IdentityWeakReference(o));
    }

    @Override
    public V put(K k, V v) {
        this.cleanUp();
        return this.mMap.put(new IdentityWeakReference(k, this.mQueue), v);
    }

    @Override
    public V remove(Object o) {
        this.cleanUp();
        return this.mMap.remove(new IdentityWeakReference(o));
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> map) {
        this.cleanUp();
        ReferenceQueue<Object> queue = this.mQueue;
        HashMap<IdentityWeakReference, V> referenceMap = this.mMap;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            referenceMap.put(new IdentityWeakReference(entry.getKey(), queue), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.mMap.clear();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        if (this.mKeySet == null) {
            this.mKeySet = new AbstractSet<K>(){

                @Override
                @NotNull
                public Iterator<K> iterator() {
                    return new KeyIterator();
                }

                @Override
                public int size() {
                    return WeakIdentityHashMap.this.mMap.size();
                }
            };
        }
        return this.mKeySet;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.mMap.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.mEntrySet == null) {
            this.mEntrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                @NotNull
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new EntryIterator();
                }

                @Override
                public int size() {
                    return WeakIdentityHashMap.this.mMap.size();
                }
            };
        }
        return this.mEntrySet;
    }

    private void cleanUp() {
        HashMap<IdentityWeakReference, V> map = this.mMap;
        ReferenceQueue<Object> queue = this.mQueue;
        IdentityWeakReference reference = (IdentityWeakReference)queue.poll();
        while (reference != null) {
            map.remove(reference);
            reference = (IdentityWeakReference)queue.poll();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WeakIdentityHashMap)) {
            return o instanceof Map && o.equals(this);
        }
        WeakIdentityHashMap that = (WeakIdentityHashMap)o;
        return this.mMap.equals(that.mMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WeakEntry
    implements Map.Entry<K, V> {
        private final IdentityWeakReference mReference;

        private WeakEntry(IdentityWeakReference key) {
            this.mReference = key;
        }

        @Override
        public K getKey() {
            return this.mReference.get();
        }

        @Override
        public V getValue() {
            return WeakIdentityHashMap.this.mMap.get(this.mReference);
        }

        @Override
        public V setValue(V v) {
            return WeakIdentityHashMap.this.mMap.put(this.mReference, v);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyIterator
    implements Iterator<K> {
        private final Iterator<IdentityWeakReference> mIterator;

        private KeyIterator() {
            this.mIterator = WeakIdentityHashMap.this.mMap.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.mIterator.hasNext();
        }

        @Override
        public K next() {
            return this.mIterator.next().get();
        }

        @Override
        public void remove() {
            this.mIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<IdentityWeakReference> mIterator;

        private EntryIterator() {
            this.mIterator = WeakIdentityHashMap.this.mMap.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.mIterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            return new WeakEntry(this.mIterator.next());
        }

        @Override
        public void remove() {
            this.mIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IdentityWeakReference
    extends WeakReference<Object> {
        private final int mHashCode;

        private IdentityWeakReference(Object referent, ReferenceQueue<? super Object> queue) {
            super(referent, queue);
            this.mHashCode = System.identityHashCode(referent);
        }

        private IdentityWeakReference(Object referent) {
            super(referent);
            this.mHashCode = System.identityHashCode(referent);
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IdentityWeakReference)) {
                return false;
            }
            IdentityWeakReference that = (IdentityWeakReference)obj;
            if (this.mHashCode != that.mHashCode) {
                return false;
            }
            Object referent = this.get();
            return referent != null && referent == that.get();
        }
    }
}

