/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.configurer;

import com.github.davidfantasy.mybatisplus.generatorui.common.Result;
import com.github.davidfantasy.mybatisplus.generatorui.common.ResultCode;
import com.github.davidfantasy.mybatisplus.generatorui.common.ServiceException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
public class WebControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(WebControllerAdvice.class);

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Result exceptionHandler(HttpServletRequest request, Exception e) {
        Result result = new Result();
        log.info("\u672a\u6355\u83b7\u7684\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        if (e instanceof ServiceException) {
            result.setCode(ResultCode.FAIL).setMessage(e.getMessage());
        } else if (e instanceof NoHandlerFoundException) {
            result.setCode(ResultCode.NOT_FOUND).setMessage("\u63a5\u53e3 [" + request.getRequestURI() + "] \u4e0d\u5b58\u5728");
        } else if (e instanceof ServletException) {
            result.setCode(ResultCode.FAIL).setMessage(e.getMessage());
        } else {
            result.setCode(ResultCode.INTERNAL_SERVER_ERROR).setMessage("\u7cfb\u7edf\u53d1\u751f\u5185\u90e8\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            log.error("\u7cfb\u7edf\u53d1\u751f\u5185\u90e8\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u63a7\u5236\u53f0\u65e5\u5fd7\u4e86\u89e3\u8be6\u60c5", (Throwable)e);
        }
        return result;
    }
}

