/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidfantasy.mybatisplus.generatorui.dto.DtoFieldInfo;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;

public class GenDtoConfig {
    private boolean enableParseDynamicParams;
    private String fullPackage;
    private boolean enableLombok;
    private boolean enablePageQuery;
    private String comment;
    private String author;
    private String createDate;
    private String mapperMethod;
    private String mapperLocation;
    private String mapperLocationPrefix;
    private Boolean enableCreateDaoMethod;
    private String daoMethodParamType;
    private String daoMethodParamDto;
    private boolean autoCreatedResultDto;
    private Set<String> importPackages = Sets.newHashSet();
    @JsonIgnore
    private List<DtoFieldInfo> fields;

    public String getPkg() {
        if (Strings.isNullOrEmpty((String)this.fullPackage)) {
            return "";
        }
        return this.fullPackage.substring(0, this.fullPackage.lastIndexOf("."));
    }

    public String getDtoName() {
        if (Strings.isNullOrEmpty((String)this.fullPackage)) {
            return "";
        }
        return this.fullPackage.substring(this.fullPackage.lastIndexOf(".") + 1, this.fullPackage.length());
    }

    public String getMapperElementId() {
        if (Strings.isNullOrEmpty((String)this.mapperLocation)) {
            return "";
        }
        return this.mapperLocation.substring(this.mapperLocation.lastIndexOf(".") + 1, this.mapperLocation.length());
    }

    public String getMapperPackage() {
        if (Strings.isNullOrEmpty((String)this.mapperLocation)) {
            return "";
        }
        String pkg = this.mapperLocation.substring(0, this.mapperLocation.lastIndexOf("."));
        if (!Strings.isNullOrEmpty((String)this.mapperLocationPrefix) && !"java".equals("mapperLocationPrefix")) {
            pkg = this.mapperLocationPrefix + ":" + pkg;
        }
        return pkg;
    }

    public String getResultType() {
        if (Strings.isNullOrEmpty((String)this.getFullPackage())) {
            return "java.util.Map";
        }
        return this.getFullPackage();
    }

    public String getResultMap() {
        if (!Strings.isNullOrEmpty((String)this.getFullPackage()) && this.autoCreatedResultDto) {
            if (this.getFields() == null) {
                return null;
            }
            for (DtoFieldInfo fieldInfo : this.getFields()) {
                if (fieldInfo.getPropertyName().equals(fieldInfo.getColumnName())) continue;
                return this.getDtoName() + "Map";
            }
        }
        return null;
    }

    public boolean isEnableParseDynamicParams() {
        return this.enableParseDynamicParams;
    }

    public String getFullPackage() {
        return this.fullPackage;
    }

    public boolean isEnableLombok() {
        return this.enableLombok;
    }

    public boolean isEnablePageQuery() {
        return this.enablePageQuery;
    }

    public String getComment() {
        return this.comment;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getCreateDate() {
        return this.createDate;
    }

    public String getMapperMethod() {
        return this.mapperMethod;
    }

    public String getMapperLocation() {
        return this.mapperLocation;
    }

    public String getMapperLocationPrefix() {
        return this.mapperLocationPrefix;
    }

    public Boolean getEnableCreateDaoMethod() {
        return this.enableCreateDaoMethod;
    }

    public String getDaoMethodParamType() {
        return this.daoMethodParamType;
    }

    public String getDaoMethodParamDto() {
        return this.daoMethodParamDto;
    }

    public boolean isAutoCreatedResultDto() {
        return this.autoCreatedResultDto;
    }

    public Set<String> getImportPackages() {
        return this.importPackages;
    }

    public List<DtoFieldInfo> getFields() {
        return this.fields;
    }

    public void setEnableParseDynamicParams(boolean enableParseDynamicParams) {
        this.enableParseDynamicParams = enableParseDynamicParams;
    }

    public void setFullPackage(String fullPackage) {
        this.fullPackage = fullPackage;
    }

    public void setEnableLombok(boolean enableLombok) {
        this.enableLombok = enableLombok;
    }

    public void setEnablePageQuery(boolean enablePageQuery) {
        this.enablePageQuery = enablePageQuery;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public void setMapperMethod(String mapperMethod) {
        this.mapperMethod = mapperMethod;
    }

    public void setMapperLocation(String mapperLocation) {
        this.mapperLocation = mapperLocation;
    }

    public void setMapperLocationPrefix(String mapperLocationPrefix) {
        this.mapperLocationPrefix = mapperLocationPrefix;
    }

    public void setEnableCreateDaoMethod(Boolean enableCreateDaoMethod) {
        this.enableCreateDaoMethod = enableCreateDaoMethod;
    }

    public void setDaoMethodParamType(String daoMethodParamType) {
        this.daoMethodParamType = daoMethodParamType;
    }

    public void setDaoMethodParamDto(String daoMethodParamDto) {
        this.daoMethodParamDto = daoMethodParamDto;
    }

    public void setAutoCreatedResultDto(boolean autoCreatedResultDto) {
        this.autoCreatedResultDto = autoCreatedResultDto;
    }

    public void setImportPackages(Set<String> importPackages) {
        this.importPackages = importPackages;
    }

    @JsonIgnore
    public void setFields(List<DtoFieldInfo> fields) {
        this.fields = fields;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenDtoConfig)) {
            return false;
        }
        GenDtoConfig other = (GenDtoConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnableParseDynamicParams() != other.isEnableParseDynamicParams()) {
            return false;
        }
        if (this.isEnableLombok() != other.isEnableLombok()) {
            return false;
        }
        if (this.isEnablePageQuery() != other.isEnablePageQuery()) {
            return false;
        }
        if (this.isAutoCreatedResultDto() != other.isAutoCreatedResultDto()) {
            return false;
        }
        Boolean this$enableCreateDaoMethod = this.getEnableCreateDaoMethod();
        Boolean other$enableCreateDaoMethod = other.getEnableCreateDaoMethod();
        if (this$enableCreateDaoMethod == null ? other$enableCreateDaoMethod != null : !((Object)this$enableCreateDaoMethod).equals(other$enableCreateDaoMethod)) {
            return false;
        }
        String this$fullPackage = this.getFullPackage();
        String other$fullPackage = other.getFullPackage();
        if (this$fullPackage == null ? other$fullPackage != null : !this$fullPackage.equals(other$fullPackage)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        String this$createDate = this.getCreateDate();
        String other$createDate = other.getCreateDate();
        if (this$createDate == null ? other$createDate != null : !this$createDate.equals(other$createDate)) {
            return false;
        }
        String this$mapperMethod = this.getMapperMethod();
        String other$mapperMethod = other.getMapperMethod();
        if (this$mapperMethod == null ? other$mapperMethod != null : !this$mapperMethod.equals(other$mapperMethod)) {
            return false;
        }
        String this$mapperLocation = this.getMapperLocation();
        String other$mapperLocation = other.getMapperLocation();
        if (this$mapperLocation == null ? other$mapperLocation != null : !this$mapperLocation.equals(other$mapperLocation)) {
            return false;
        }
        String this$mapperLocationPrefix = this.getMapperLocationPrefix();
        String other$mapperLocationPrefix = other.getMapperLocationPrefix();
        if (this$mapperLocationPrefix == null ? other$mapperLocationPrefix != null : !this$mapperLocationPrefix.equals(other$mapperLocationPrefix)) {
            return false;
        }
        String this$daoMethodParamType = this.getDaoMethodParamType();
        String other$daoMethodParamType = other.getDaoMethodParamType();
        if (this$daoMethodParamType == null ? other$daoMethodParamType != null : !this$daoMethodParamType.equals(other$daoMethodParamType)) {
            return false;
        }
        String this$daoMethodParamDto = this.getDaoMethodParamDto();
        String other$daoMethodParamDto = other.getDaoMethodParamDto();
        if (this$daoMethodParamDto == null ? other$daoMethodParamDto != null : !this$daoMethodParamDto.equals(other$daoMethodParamDto)) {
            return false;
        }
        Set<String> this$importPackages = this.getImportPackages();
        Set<String> other$importPackages = other.getImportPackages();
        if (this$importPackages == null ? other$importPackages != null : !((Object)this$importPackages).equals(other$importPackages)) {
            return false;
        }
        List<DtoFieldInfo> this$fields = this.getFields();
        List<DtoFieldInfo> other$fields = other.getFields();
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenDtoConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnableParseDynamicParams() ? 79 : 97);
        result = result * 59 + (this.isEnableLombok() ? 79 : 97);
        result = result * 59 + (this.isEnablePageQuery() ? 79 : 97);
        result = result * 59 + (this.isAutoCreatedResultDto() ? 79 : 97);
        Boolean $enableCreateDaoMethod = this.getEnableCreateDaoMethod();
        result = result * 59 + ($enableCreateDaoMethod == null ? 43 : ((Object)$enableCreateDaoMethod).hashCode());
        String $fullPackage = this.getFullPackage();
        result = result * 59 + ($fullPackage == null ? 43 : $fullPackage.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        String $createDate = this.getCreateDate();
        result = result * 59 + ($createDate == null ? 43 : $createDate.hashCode());
        String $mapperMethod = this.getMapperMethod();
        result = result * 59 + ($mapperMethod == null ? 43 : $mapperMethod.hashCode());
        String $mapperLocation = this.getMapperLocation();
        result = result * 59 + ($mapperLocation == null ? 43 : $mapperLocation.hashCode());
        String $mapperLocationPrefix = this.getMapperLocationPrefix();
        result = result * 59 + ($mapperLocationPrefix == null ? 43 : $mapperLocationPrefix.hashCode());
        String $daoMethodParamType = this.getDaoMethodParamType();
        result = result * 59 + ($daoMethodParamType == null ? 43 : $daoMethodParamType.hashCode());
        String $daoMethodParamDto = this.getDaoMethodParamDto();
        result = result * 59 + ($daoMethodParamDto == null ? 43 : $daoMethodParamDto.hashCode());
        Set<String> $importPackages = this.getImportPackages();
        result = result * 59 + ($importPackages == null ? 43 : ((Object)$importPackages).hashCode());
        List<DtoFieldInfo> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }

    public String toString() {
        return "GenDtoConfig(enableParseDynamicParams=" + this.isEnableParseDynamicParams() + ", fullPackage=" + this.getFullPackage() + ", enableLombok=" + this.isEnableLombok() + ", enablePageQuery=" + this.isEnablePageQuery() + ", comment=" + this.getComment() + ", author=" + this.getAuthor() + ", createDate=" + this.getCreateDate() + ", mapperMethod=" + this.getMapperMethod() + ", mapperLocation=" + this.getMapperLocation() + ", mapperLocationPrefix=" + this.getMapperLocationPrefix() + ", enableCreateDaoMethod=" + this.getEnableCreateDaoMethod() + ", daoMethodParamType=" + this.getDaoMethodParamType() + ", daoMethodParamDto=" + this.getDaoMethodParamDto() + ", autoCreatedResultDto=" + this.isAutoCreatedResultDto() + ", importPackages=" + this.getImportPackages() + ", fields=" + this.getFields() + ")";
    }
}

