/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.controller;

import cn.hutool.core.io.IoUtil;
import com.github.davidfantasy.mybatisplus.generatorui.common.Result;
import com.github.davidfantasy.mybatisplus.generatorui.common.ResultGenerator;
import com.github.davidfantasy.mybatisplus.generatorui.common.ServiceException;
import com.github.davidfantasy.mybatisplus.generatorui.dto.OutputFileInfo;
import com.github.davidfantasy.mybatisplus.generatorui.dto.UserConfig;
import com.github.davidfantasy.mybatisplus.generatorui.service.OutputFileInfoService;
import com.github.davidfantasy.mybatisplus.generatorui.service.UserConfigStore;
import com.github.davidfantasy.mybatisplus.generatorui.util.TemplateUtil;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/template"})
public class TemplateController {
    private static final Logger log = LoggerFactory.getLogger(TemplateController.class);
    @Autowired
    private UserConfigStore userConfigStore;
    @Autowired
    private OutputFileInfoService outputFileInfoService;

    @GetMapping(value={"/download"})
    public ResponseEntity<byte[]> download(@RequestParam String fileType) throws IOException {
        if (Strings.isNullOrEmpty((String)fileType)) {
            log.error("fileType\u4e0d\u80fd\u4e3a\u7a7a");
            return ResponseEntity.badRequest().build();
        }
        UserConfig userConfig = this.userConfigStore.getUserConfigFromFile();
        if (userConfig == null) {
            InputStream tplIn = TemplateUtil.getBuiltInTemplate(fileType);
            return this.toDownloadEntity(tplIn);
        }
        List<OutputFileInfo> fileInfos = userConfig.getOutputFiles();
        for (OutputFileInfo fileInfo : fileInfos) {
            File tplFile;
            if (!fileType.equals(fileInfo.getFileType())) continue;
            if (fileInfo.isBuiltIn() && Strings.isNullOrEmpty((String)fileInfo.getTemplatePath())) {
                InputStream tplIn = TemplateUtil.getBuiltInTemplate(fileType);
                return this.toDownloadEntity(tplIn);
            }
            String tplPath = fileInfo.getTemplatePath();
            if (tplPath.startsWith("file:")) {
                tplPath = tplPath.replaceFirst("file:", "");
            }
            if ((tplFile = new File(tplPath)).exists()) {
                return this.toDownloadEntity(Files.newInputStream(tplFile.toPath(), new OpenOption[0]));
            }
            throw new ServiceException("\u672a\u627e\u5230\u6a21\u677f\u6587\u4ef6\uff1a" + fileInfo.getTemplatePath());
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/upload"})
    public Result upload(@RequestParam(value="file") MultipartFile file, @RequestParam(value="fileType") String fileType) {
        HashMap params = Maps.newHashMap();
        String storePath = this.userConfigStore.uploadTemplate(file);
        params.put("templatePath", storePath);
        params.put("templateName", file.getOriginalFilename());
        return ResultGenerator.genSuccessResult(params);
    }

    private ResponseEntity<byte[]> toDownloadEntity(InputStream tplIn) {
        if (tplIn == null) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok().contentType(MediaType.MULTIPART_FORM_DATA).body((Object)IoUtil.readBytes((InputStream)tplIn));
    }
}

