/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations;

import com.jmathanim.Animations.Strategies.Transform.Optimizers.OptimizePathsStrategy;
import com.jmathanim.Utils.UsefulLambdas;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.DoubleUnaryOperator;

public abstract class Animation {
    private String debugName = "";
    private Status status = Status.NOT_INITIALIZED;
    public static final double DEFAULT_TIME = 1.0;
    private double t;
    private double dt;
    protected double runTime;
    protected double fps;
    protected JMathAnimScene scene;
    protected OptimizePathsStrategy optimizeStrategy = null;
    protected DoubleUnaryOperator lambda;
    protected Boolean useObjectState;
    protected Boolean shouldAddObjectsToScene;
    protected Boolean shouldInterpolateStyles;
    private final HashMap<MathObject, MathObject> backups;

    protected Animation(double runTime) {
        this.runTime = runTime;
        this.useObjectState = true;
        this.shouldAddObjectsToScene = true;
        this.shouldInterpolateStyles = true;
        this.lambda = UsefulLambdas.smooth(0.9);
        this.backups = new HashMap();
    }

    public Boolean isShouldInterpolateStyles() {
        return this.shouldInterpolateStyles;
    }

    public <T extends Animation> T setShouldInterpolateStyles(boolean interpolateStyles) {
        this.shouldInterpolateStyles = interpolateStyles;
        return (T)this;
    }

    public Boolean isUseObjectState() {
        return this.useObjectState;
    }

    public <T extends Animation> T setUseObjectState(boolean shouldSaveState) {
        this.useObjectState = shouldSaveState;
        return (T)this;
    }

    public <T extends Animation> T setAddObjectsToScene(boolean addToScene) {
        this.shouldAddObjectsToScene = addToScene;
        return (T)this;
    }

    protected void setFps(double fps) {
        this.fps = fps;
        this.dt = 1.0 / (this.runTime * fps);
        this.t = 0.0;
    }

    public boolean processAnimation() {
        boolean resul;
        if (this.status == Status.FINISHED) {
            return true;
        }
        if (this.status == Status.NOT_INITIALIZED) {
            JMathAnimScene.logger.error("Animation " + this.getClass().getCanonicalName() + " not initialized. Animation will not be done");
            return true;
        }
        if (this.t <= 1.0 && this.t >= 0.0) {
            this.doAnim(this.t);
            resul = false;
        } else {
            resul = true;
        }
        this.t += this.dt;
        if (this.t < 1.0 && 1.0 - this.t < this.dt) {
            this.t = 1.0;
        }
        return resul;
    }

    public void initialize(JMathAnimScene scene) {
        this.scene = scene;
        this.setFps(scene.getConfig().fps);
        this.status = Status.INITIALIZED;
    }

    public abstract void doAnim(double var1);

    public void finishAnimation() {
        this.status = Status.FINISHED;
    }

    public <T extends Animation> T setOptimizationStrategy(OptimizePathsStrategy strategy) {
        this.optimizeStrategy = strategy;
        return (T)this;
    }

    public DoubleUnaryOperator getLambda() {
        return this.lambda;
    }

    public <T extends Animation> T setLambda(DoubleUnaryOperator lambda) {
        this.lambda = lambda;
        return (T)this;
    }

    protected void saveStates(MathObject ... mathObjects) {
        if (this.isUseObjectState().booleanValue()) {
            this.backups.clear();
            for (MathObject obj : mathObjects) {
                this.backups.put(obj, (MathObject)obj.copy());
            }
        }
    }

    protected void restoreStates(MathObject ... mathObjects) {
        if (this.isUseObjectState().booleanValue()) {
            int n = 0;
            for (MathObject obj : mathObjects) {
                obj.copyStateFrom(this.backups.get(obj));
                ++n;
            }
        }
    }

    protected void addObjectsToscene(MathObject ... mathObjects) {
        if (this.shouldAddObjectsToScene.booleanValue()) {
            this.scene.add(mathObjects);
        }
    }

    protected void removeObjectsFromScene(MathObject ... mathObjects) {
        if (this.shouldAddObjectsToScene.booleanValue()) {
            this.scene.remove(mathObjects);
        }
    }

    protected void removeObjectsFromScene(ArrayList<MathObject> removeThisAtTheEnd) {
        this.removeObjectsFromScene(removeThisAtTheEnd.toArray(new MathObject[0]));
    }

    protected void addObjectsToscene(ArrayList<MathObject> addThisAtTheEnd) {
        this.addObjectsToscene(addThisAtTheEnd.toArray(new MathObject[0]));
    }

    public Boolean isShouldAddObjectsToScene() {
        return this.shouldAddObjectsToScene;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setT(double time) {
        this.t = time;
    }

    protected void copyAnimationParametersTo(Animation anim) {
        if (this.getLambda() != null) {
            anim.setLambda(this.getLambda());
        }
        if (null != this.isShouldAddObjectsToScene()) {
            anim.setAddObjectsToScene(this.isShouldAddObjectsToScene());
        }
        if (null != this.isShouldInterpolateStyles()) {
            anim.setShouldInterpolateStyles(this.isShouldInterpolateStyles());
        }
        if (null != this.isShouldAddObjectsToScene()) {
            anim.setAddObjectsToScene(this.isShouldAddObjectsToScene());
        }
    }

    public String getDebugName() {
        return this.debugName;
    }

    public final void setDebugName(String debugName) {
        this.debugName = debugName;
    }

    public double getRunTime() {
        return this.runTime;
    }

    public <T extends Animation> T setRunTime(double runTime) {
        this.runTime = runTime;
        return (T)this;
    }

    public static enum Status {
        NOT_INITIALIZED,
        INITIALIZED,
        RUNNING,
        FINISHED;

    }
}

