/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations;

import com.jmathanim.Utils.AffineJTransform;
import com.jmathanim.Utils.UsefulLambdas;
import com.jmathanim.mathobjects.FunctionGraph;
import com.jmathanim.mathobjects.JMPath;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.SVGMathObject;
import com.jmathanim.mathobjects.Shape;
import java.util.HashMap;

public class AnimationEffect {
    protected Double jumpHeight = null;
    protected Integer numTurns = null;
    protected Double alphaScaleEffect = null;
    protected Double scaleEffect = null;
    private final HashMap<MathObject, JMPath> jumpPaths = new HashMap();
    JumpType jumpType = null;

    public void addJumpEffect(double height) {
        this.jumpHeight = height;
        this.jumpType = JumpType.PARABOLICAL;
    }

    public void addJumpEffect(double height, JumpType type) {
        this.jumpHeight = height;
        this.jumpType = type;
    }

    public void addRotationEffect(int numTurns) {
        this.numTurns = numTurns;
    }

    public void addAlphaEffect(double alphaScale) {
        this.alphaScaleEffect = alphaScale;
    }

    public void addScaleEffect(double scale) {
        this.scaleEffect = scale;
    }

    protected void applyScaleEffect(double t, MathObject obj) {
        if (this.scaleEffect != null && this.scaleEffect != 1.0) {
            double L = 4.0 * (1.0 - this.scaleEffect);
            double scalelt = 1.0 - t * (1.0 - t) * L;
            obj.scale(scalelt);
        }
    }

    protected void applyRotationEffect(double t, MathObject obj) {
        if (this.numTurns != null && this.numTurns != 0) {
            double rotateAngle = Math.PI * 2 * (double)this.numTurns.intValue();
            obj.rotate(rotateAngle * t);
        }
    }

    protected void applyAlphaScaleEffect(double t, MathObject obj) {
        if (this.alphaScaleEffect != null && this.alphaScaleEffect != 1.0) {
            double L = 4.0 * (1.0 - this.alphaScaleEffect);
            double alphaScalelt = 1.0 - t * (1.0 - t) * L;
            obj.drawAlpha(alphaScalelt);
            obj.fillAlpha(alphaScalelt);
        }
    }

    protected void prepareJumpPath(Point A, Point B, MathObject obj) {
        if (this.jumpHeight == null || this.jumpHeight == 0.0 || A.to(B).norm() == 0.0) {
            return;
        }
        double dist = A.to(B).norm();
        Shape jumpPath = null;
        switch (this.jumpType) {
            case SEMICIRCLE: {
                jumpPath = (Shape)Shape.arc(Math.PI).scale(1.0, Math.signum(this.jumpHeight));
                jumpPath.getPath().reverse();
                break;
            }
            case ELLIPTICAL: {
                jumpPath = (Shape)Shape.arc(Math.PI).scale(0.5);
                jumpPath.getPath().reverse();
                break;
            }
            case TRIANGULAR: {
                jumpPath = Shape.polyLine(Point.origin(), Point.at(0.7, 0.7), Point.at(1.0, 1.0), Point.at(1.3, 0.7), Point.at(2.0, 0.0));
                break;
            }
            case FOLIUM: {
                jumpPath = (Shape)SVGMathObject.make("#foliumJumpPath.svg").get(0).scale(1.0, -1.0);
                break;
            }
            case PARABOLICAL: {
                jumpPath = new Shape(FunctionGraph.make(t -> 4.0 * t * (1.0 - t), 0.0, 1.0).getPath());
                break;
            }
            case SINUSOIDAL: {
                jumpPath = new Shape(FunctionGraph.make(t -> Math.sin(Math.PI * t), 0.0, 1.0).getPath());
                break;
            }
            case SINUSOIDAL2: {
                jumpPath = new Shape(FunctionGraph.make(t -> Math.sin(Math.PI * 2 * t), 0.0, 1.0).getPath());
                break;
            }
            case CRANE: {
                jumpPath = Shape.polyLine(Point.origin(), Point.at(0.0, 0.7), Point.at(0.0, 1.0), Point.at(0.3, 1.0), Point.at(0.7, 1.0), Point.at(1.0, 1.0), Point.at(1.0, 0.7), Point.at(1.0, 0.0));
                break;
            }
            case BOUNCE1: {
                jumpPath = new Shape(FunctionGraph.make(UsefulLambdas.backAndForthBounce1(), 0.0, 1.0).getPath());
                break;
            }
            case BOUNCE2: {
                jumpPath = new Shape(FunctionGraph.make(UsefulLambdas.backAndForthBounce2(), 0.0, 1.0).getPath());
            }
        }
        if (jumpPath != null) {
            if (this.jumpType != JumpType.SEMICIRCLE) {
                jumpPath.scale(1.0, jumpPath.getWidth() * this.jumpHeight / (jumpPath.getHeight() * dist));
            }
            if (this.jumpType == JumpType.ELLIPTICAL) {
                jumpPath.scale(1.0, 1.25);
            }
            AffineJTransform.createDirect2DHomothecy(jumpPath.getPoint(0), jumpPath.getPoint(-1), A, B, 1.0).applyTransform(jumpPath);
            this.jumpPaths.put(obj, jumpPath.getPath());
        }
    }

    protected void applyJumpEffect(double t, MathObject obj) {
        if (this.jumpPaths.containsKey(obj)) {
            obj.moveTo(this.jumpPaths.get((Object)obj).getJMPointAt((double)t).p);
        }
    }

    protected void applyAnimationEffects(double lt, MathObject obj) {
        this.applyJumpEffect(lt, obj);
        this.applyScaleEffect(lt, obj);
        this.applyRotationEffect(lt, obj);
        this.applyAlphaScaleEffect(lt, obj);
    }

    public void copyEffectParametersFrom(AnimationEffect obj) {
        if (obj.jumpHeight != null) {
            this.addJumpEffect(obj.jumpHeight, obj.jumpType);
        }
        if (obj.alphaScaleEffect != null) {
            this.addAlphaEffect(obj.alphaScaleEffect);
        }
        if (obj.numTurns != null) {
            this.addRotationEffect(obj.numTurns);
        }
        if (obj.scaleEffect != null) {
            this.addScaleEffect(obj.scaleEffect);
        }
    }

    public static enum JumpType {
        SEMICIRCLE,
        PARABOLICAL,
        ELLIPTICAL,
        TRIANGULAR,
        FOLIUM,
        SINUSOIDAL,
        SINUSOIDAL2,
        CRANE,
        BOUNCE1,
        BOUNCE2;

    }
}

