/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations;

import com.jmathanim.Animations.Animation;
import com.jmathanim.Animations.AnimationWithEffects;
import com.jmathanim.Utils.UsefulLambdas;
import com.jmathanim.jmathanim.JMathAnimScene;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.DoubleUnaryOperator;

public class AnimationGroup
extends AnimationWithEffects {
    private final ArrayList<Animation> animations;
    private double delayPercentage;

    public ArrayList<Animation> getAnimations() {
        return this.animations;
    }

    public static AnimationGroup make(Animation ... anims) {
        return new AnimationGroup(anims);
    }

    public AnimationGroup(Animation ... animations) {
        super(0.0);
        this.lambda = null;
        this.animations = new ArrayList();
        this.animations.addAll(Arrays.asList(animations));
        this.useObjectState = null;
        this.shouldAddObjectsToScene = null;
        this.shouldInterpolateStyles = null;
    }

    public AnimationGroup(ArrayList<Animation> animations) {
        super(0.0);
        this.animations = animations;
    }

    public <T extends AnimationGroup> T add(Animation ... anims) {
        this.animations.addAll(Arrays.asList(anims));
        return (T)this;
    }

    @Override
    public void initialize(JMathAnimScene scene) {
        super.initialize(scene);
        int size = this.animations.size();
        if (!"".equals(this.getDebugName())) {
            this.setDebugName("Animation group with " + size + " animations");
        }
        int k = 0;
        for (Animation anim : this.animations) {
            this.copyAnimationParametersTo(anim);
        }
        for (Animation anim : this.animations) {
            if (anim == null) continue;
            if (anim instanceof AnimationWithEffects) {
                AnimationWithEffects animEf = (AnimationWithEffects)anim;
                this.copyEffectParametersTo(animEf);
            }
            anim.initialize(scene);
        }
        if (size > 1 && this.delayPercentage > 0.0) {
            for (Animation anim : this.animations) {
                double a = (double)k * this.delayPercentage / (double)(size - 1);
                double b = 1.0 - this.delayPercentage;
                anim.setLambda(anim.getLambda().compose(UsefulLambdas.allocateTo(a, a + b)));
                ++k;
            }
        }
    }

    @Override
    public boolean processAnimation() {
        boolean finishedAll = true;
        for (Animation anim : this.animations) {
            finishedAll &= anim.processAnimation();
        }
        return finishedAll;
    }

    @Override
    public void doAnim(double t) {
        for (Animation anim : this.animations) {
            anim.doAnim(t);
        }
    }

    @Override
    public void finishAnimation() {
        super.finishAnimation();
        for (Animation anim : this.animations) {
            if (anim.getStatus() == Animation.Status.FINISHED) continue;
            anim.finishAnimation();
        }
    }

    public AnimationGroup setLambda(DoubleUnaryOperator lambda) {
        super.setLambda(lambda);
        for (Animation anim : this.animations) {
            anim.setLambda(lambda);
        }
        return this;
    }

    public AnimationGroup setUseObjectState(boolean shouldSaveState) {
        for (Animation anim : this.animations) {
            anim.setUseObjectState(shouldSaveState);
        }
        return this;
    }

    public AnimationGroup setAddObjectsToScene(boolean addToScene) {
        for (Animation anim : this.animations) {
            anim.setAddObjectsToScene(addToScene);
        }
        return this;
    }

    public AnimationGroup setShouldInterpolateStyles(boolean interpolateStyles) {
        for (Animation anim : this.animations) {
            anim.setShouldInterpolateStyles(interpolateStyles);
        }
        return this;
    }

    public <T extends AnimationGroup> T addDelayEffect(double delayPercentage) {
        if (delayPercentage <= 0.0 || delayPercentage >= 1.0) {
            return (T)this;
        }
        this.delayPercentage = delayPercentage;
        return (T)this;
    }
}

