/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations;

import com.jmathanim.Animations.Animation;
import com.jmathanim.Animations.AnimationGroup;
import com.jmathanim.Animations.AnimationWithEffects;
import com.jmathanim.Animations.Concatenate;
import com.jmathanim.Animations.FlipTransform;
import com.jmathanim.Animations.ShiftAnimation;
import com.jmathanim.Animations.ShowCreation;
import com.jmathanim.Cameras.Camera;
import com.jmathanim.Cameras.Camera3D;
import com.jmathanim.Styling.JMColor;
import com.jmathanim.Styling.MODrawProperties;
import com.jmathanim.Styling.PaintStyle;
import com.jmathanim.Utils.AffineJTransform;
import com.jmathanim.Utils.Anchor;
import com.jmathanim.Utils.JMathAnimConfig;
import com.jmathanim.Utils.Layouts.GroupLayout;
import com.jmathanim.Utils.Rect;
import com.jmathanim.Utils.UsefulLambdas;
import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MathObjectGroup;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;
import java.util.ArrayList;
import java.util.HashMap;
import javafx.scene.shape.StrokeLineCap;

public class Commands {
    public static ShiftAnimation shift(double runtime, double dx, double dy, MathObject ... objects) {
        return Commands.shift(runtime, new Vec(dx, dy), objects);
    }

    public static ShiftAnimation shift(double runtime, final Vec sv, final MathObject ... objects) {
        ShiftAnimation resul = new ShiftAnimation(runtime, objects){

            @Override
            public void initialize(JMathAnimScene scene) {
                super.initialize(scene);
                for (MathObject obj : objects) {
                    this.setShiftVector(obj, sv);
                }
            }
        };
        resul.setDebugName("Shift");
        return resul;
    }

    public static Animation highlight(double runtime, MathObject ... objects) {
        return Commands.highlight(runtime, 1.5, objects);
    }

    public static Animation highlight(double runtime, double scale, MathObject ... objects) {
        MathObjectGroup group = MathObjectGroup.make(objects);
        Point center = group.getCenter();
        Animation anim = Commands.scale(runtime, center, scale, group);
        anim.setLambda(UsefulLambdas.backAndForth());
        anim.setDebugName("Highlight");
        return anim;
    }

    public static AnimationGroup twistAndScale(double runtime, MathObject ... objects) {
        return Commands.twistAndScale(runtime, 1.5, 0.2617993877991494, objects);
    }

    public static AnimationGroup twistAndScale(double runtime, double scale, double twistAngle, MathObject ... objects) {
        AnimationGroup ag = new AnimationGroup(new Animation[0]);
        Point center = MathObjectGroup.make(objects).getCenter();
        for (MathObject obj : objects) {
            ag.add(new Animation[]{Commands.rotate(runtime, center, twistAngle, obj).setLambda(t -> Math.sin(Math.PI * 4 * t))});
            ag.add(new Animation[]{((Animation)Commands.scale(runtime, center, scale, obj).setLambda(UsefulLambdas.backAndForth())).setUseObjectState(false)});
        }
        ag.setDebugName("Highlight");
        return ag;
    }

    public static Animation scale(double runtime, double sc, MathObject ... objects) {
        AnimationGroup ag = new AnimationGroup(new Animation[0]);
        Point center = MathObjectGroup.make(objects).getCenter();
        for (MathObject obj : objects) {
            ag.add(Commands.scale(runtime, center, sc, obj));
        }
        return ag;
    }

    public static Animation scale(double runtime, Point c, double sc, MathObject ... objects) {
        return Commands.scale(runtime, c, sc, sc, sc, objects);
    }

    public static Animation scale(double runtime, final Point c, final double scx, final double scy, final double scz, final MathObject ... objects) {
        Animation resul = new Animation(runtime){
            double scalex;
            double scaley;
            double scalez;
            Point scaleCenter;
            MathObject[] mathObjects;
            {
                super(runTime);
                this.scalex = scx;
                this.scaley = scy;
                this.scalez = scz;
                this.scaleCenter = c;
                this.mathObjects = objects;
            }

            @Override
            public void initialize(JMathAnimScene scene) {
                super.initialize(scene);
                this.saveStates(this.mathObjects);
                this.addObjectsToscene(this.mathObjects);
            }

            @Override
            public void doAnim(double t) {
                double lt = this.lambda.applyAsDouble(t);
                this.restoreStates(this.mathObjects);
                for (MathObject obj : this.mathObjects) {
                    double scax = 1.0 - lt + this.scalex * lt;
                    double scay = 1.0 - lt + this.scaley * lt;
                    double scaz = 1.0 - lt + this.scalez * lt;
                    if (this.scaleCenter != null) {
                        obj.scale(this.scaleCenter, scax, scay, scaz);
                        continue;
                    }
                    obj.scale(obj.getCenter(), scax, scay, scaz);
                }
            }

            @Override
            public void finishAnimation() {
                super.finishAnimation();
                this.doAnim(1.0);
            }
        };
        resul.setDebugName("Scale");
        return resul;
    }

    public static AnimationWithEffects rotate(double runtime, double ang, MathObject ... objects) {
        return Commands.rotate(runtime, null, ang, objects);
    }

    public static AnimationWithEffects rotate(double runtime, final Point c, final double ang, final MathObject ... objects) {
        AnimationWithEffects resul = new AnimationWithEffects(runtime){
            double angle;
            Point rotationCenter;
            MathObject[] mathObjects;
            {
                super(runTime);
                this.angle = ang;
                this.rotationCenter = null;
                this.mathObjects = objects;
            }

            @Override
            public void initialize(JMathAnimScene scene) {
                super.initialize(scene);
                this.saveStates(this.mathObjects);
                if (c != null) {
                    this.rotationCenter = c;
                }
                this.addObjectsToscene(this.mathObjects);
            }

            @Override
            public void doAnim(double t) {
                double lt = this.lambda.applyAsDouble(t);
                this.restoreStates(this.mathObjects);
                for (MathObject obj : this.mathObjects) {
                    if (this.rotationCenter == null) {
                        obj.rotate(obj.getCenter(), this.angle * lt);
                    } else {
                        obj.rotate(this.rotationCenter, this.angle * lt);
                    }
                    this.applyAnimationEffects(lt, obj);
                }
            }

            @Override
            public void finishAnimation() {
                super.finishAnimation();
                this.doAnim(1.0);
            }
        };
        resul.setDebugName("Rotate");
        return resul;
    }

    public static Animation rotate3d(double runtime, double angx, double angy, double angz, MathObject ... objects) {
        return Commands.rotate3d(runtime, null, angx, angy, angz, objects);
    }

    public static Animation rotate3d(double runtime, final Point c, final double angx, final double angy, final double angz, final MathObject ... objects) {
        return new Animation(runtime){
            double anglex;
            double angley;
            double anglez;
            Point rotationCenter;
            MathObject[] mathObjects;
            {
                super(runTime);
                this.anglex = angx;
                this.angley = angy;
                this.anglez = angz;
                this.rotationCenter = null;
                this.mathObjects = objects;
            }

            @Override
            public void initialize(JMathAnimScene scene) {
                super.initialize(scene);
                this.saveStates(this.mathObjects);
                if (c != null) {
                    this.rotationCenter = c;
                }
                this.addObjectsToscene(this.mathObjects);
            }

            @Override
            public void doAnim(double t) {
                double lt = this.lambda.applyAsDouble(t);
                this.restoreStates(this.mathObjects);
                for (MathObject obj : this.mathObjects) {
                    if (this.rotationCenter == null) {
                        obj.rotate3d(obj.getCenter(), this.anglex * lt, this.angley * lt, this.anglez * lt);
                        continue;
                    }
                    obj.rotate3d(this.rotationCenter, this.anglex * lt, this.angley * lt, this.anglez * lt);
                }
            }

            @Override
            public void finishAnimation() {
                super.finishAnimation();
                this.doAnim(1.0);
            }
        };
    }

    public static AnimationWithEffects affineTransform(double runtime, final Point a, final Point b, final Point c, final Point d, final Point e, final Point f, final MathObject ... objects) {
        AnimationWithEffects resul = new AnimationWithEffects(runtime){
            Point orig1;
            Point orig2;
            Point orig3;
            Point dst1;
            Point dst2;
            Point dst3;
            MathObject[] mathObjects;
            AffineJTransform tr;
            {
                super(runTime);
                this.orig1 = a.copy();
                this.orig2 = b.copy();
                this.orig3 = c.copy();
                this.dst1 = d.copy();
                this.dst2 = e.copy();
                this.dst3 = f.copy();
                this.mathObjects = objects;
            }

            @Override
            public void initialize(JMathAnimScene scene) {
                super.initialize(scene);
                this.saveStates(this.mathObjects);
                this.addObjectsToscene(this.mathObjects);
                for (MathObject obj : this.mathObjects) {
                    this.tr = AffineJTransform.createAffineTransformation(this.orig1, this.orig2, this.orig3, this.dst1, this.dst2, this.dst3, 1.0);
                    Point center = obj.getCenter();
                    this.prepareJumpPath(center, (Point)this.tr.getTransformedObject(center), obj);
                }
            }

            @Override
            public void doAnim(double t) {
                this.restoreStates(this.mathObjects);
                double lt = this.lambda.applyAsDouble(t);
                for (MathObject obj : this.mathObjects) {
                    this.tr = AffineJTransform.createAffineTransformation(this.orig1, this.orig2, this.orig3, this.dst1, this.dst2, this.dst3, lt);
                    this.tr.applyTransform(obj);
                    this.applyAnimationEffects(lt, obj);
                }
            }

            @Override
            public void finishAnimation() {
                super.finishAnimation();
                this.doAnim(1.0);
            }
        };
        resul.setDebugName("Affine Transform");
        return resul;
    }

    public static AnimationWithEffects homothecy(double runtime, final Point a, final Point b, final Point c, final Point d, final MathObject ... objects) {
        AnimationWithEffects resul = new AnimationWithEffects(runtime){
            Point A;
            Point B;
            Point C;
            Point D;
            AffineJTransform tr;
            MathObject[] mathObjects;
            {
                super(runTime);
                this.A = a.copy();
                this.B = b.copy();
                this.C = c.copy();
                this.D = d.copy();
                this.mathObjects = objects;
            }

            @Override
            public void initialize(JMathAnimScene scene) {
                super.initialize(scene);
                this.saveStates(this.mathObjects);
                this.addObjectsToscene(this.mathObjects);
                this.tr = AffineJTransform.createDirect2DHomothecy(this.A, this.B, this.C, this.D, 1.0);
                for (MathObject obj : this.mathObjects) {
                    Point center = obj.getCenter();
                    this.prepareJumpPath(center, (Point)this.tr.getTransformedObject(center), obj);
                }
            }

            @Override
            public void doAnim(double t) {
                double lt = this.getLambda().applyAsDouble(t);
                this.restoreStates(this.mathObjects);
                this.tr = AffineJTransform.createDirect2DHomothecy(this.A, this.B, this.C, this.D, lt);
                for (MathObject obj : this.mathObjects) {
                    this.tr.applyTransform(obj);
                    this.applyAnimationEffects(lt, obj);
                }
            }

            @Override
            public void finishAnimation() {
                super.finishAnimation();
                this.doAnim(1.0);
            }
        };
        resul.setDebugName("Homothecy Transform");
        return resul;
    }

    public static AnimationWithEffects reflection(double runtime, final Point A, final Point B, final MathObject ... objects) {
        AnimationWithEffects resul = new AnimationWithEffects(runtime){
            MathObject[] mathObjects;
            Point axis1;
            Point axis2;
            AffineJTransform tr;
            {
                super(runTime);
                this.mathObjects = objects;
                this.axis1 = A.copy();
                this.axis2 = B.copy();
            }

            @Override
            public void initialize(JMathAnimScene scene) {
                super.initialize(scene);
                this.saveStates(this.mathObjects);
                this.addObjectsToscene(this.mathObjects);
                for (MathObject obj : this.mathObjects) {
                    this.tr = AffineJTransform.createReflection(this.axis1, this.axis2, 1.0);
                    Point center = obj.getCenter();
                    this.prepareJumpPath(center, (Point)this.tr.getTransformedObject(center), obj);
                }
            }

            @Override
            public void doAnim(double t) {
                double lt = this.getLambda().applyAsDouble(t);
                this.restoreStates(this.mathObjects);
                for (MathObject obj : this.mathObjects) {
                    this.tr = AffineJTransform.createReflection(this.axis1, this.axis2, lt);
                    this.tr.applyTransform(obj);
                    this.applyAnimationEffects(lt, obj);
                }
            }

            @Override
            public void finishAnimation() {
                super.finishAnimation();
                this.doAnim(1.0);
            }
        };
        resul.setDebugName("Reflection Transform");
        return resul;
    }

    public static AnimationWithEffects reflectionByAxis(double runtime, final Point a, final Point b, final MathObject ... objects) {
        AnimationWithEffects resul = new AnimationWithEffects(runtime){
            MathObject[] mathObjects;
            Point axisPoint1;
            Point axisPoint2;
            AffineJTransform tr;
            {
                super(runTime);
                this.mathObjects = objects;
                this.axisPoint1 = a.copy();
                this.axisPoint2 = b.copy();
            }

            @Override
            public void initialize(JMathAnimScene scene) {
                super.initialize(scene);
                this.saveStates(this.mathObjects);
                this.addObjectsToscene(this.mathObjects);
                for (MathObject obj : this.mathObjects) {
                    this.tr = AffineJTransform.createReflectionByAxis(this.axisPoint1, this.axisPoint2, 1.0);
                    Point center = obj.getCenter();
                    this.prepareJumpPath(center, (Point)this.tr.getTransformedObject(center), obj);
                }
            }

            @Override
            public void doAnim(double t) {
                double lt = this.getLambda().applyAsDouble(t);
                this.restoreStates(this.mathObjects);
                for (MathObject obj : this.mathObjects) {
                    this.tr = AffineJTransform.createReflectionByAxis(this.axisPoint1, this.axisPoint2, lt);
                    this.tr.applyTransform(obj);
                    this.applyAnimationEffects(lt, obj);
                }
            }

            @Override
            public void finishAnimation() {
                super.finishAnimation();
                this.doAnim(1.0);
            }
        };
        resul.setDebugName("Reflexion by Axis Transform");
        return resul;
    }

    public static AnimationGroup setColor(double runtime, PaintStyle drawColor, PaintStyle fillColor, MathObject ... objects) {
        AnimationGroup ag = new AnimationGroup(new Animation[0]);
        for (MathObject ob : objects) {
            MODrawProperties mpDst = MODrawProperties.makeNullValues();
            if (drawColor != null) {
                mpDst.setDrawColor(drawColor);
            }
            if (fillColor != null) {
                mpDst.setFillColor(fillColor);
            }
            Animation cmd = Commands.setMP(runtime, mpDst, ob);
            ag.add(cmd);
        }
        ag.setDebugName("setColor");
        return ag;
    }

    public static Animation setMP(double runtime, final MODrawProperties mp, final MathObject ... objects) {
        Animation resul = new Animation(runtime){
            MathObject[] mathObjects;
            MODrawProperties mpDst;
            {
                super(runTime);
                this.mathObjects = objects;
                this.mpDst = mp;
            }

            @Override
            public void initialize(JMathAnimScene scene) {
                super.initialize(scene);
                this.saveStates(this.mathObjects);
                this.addObjectsToscene(this.mathObjects);
            }

            @Override
            public void doAnim(double t) {
                double lt = this.getLambda().applyAsDouble(t);
                this.restoreStates(this.mathObjects);
                for (MathObject obj : this.mathObjects) {
                    obj.getMp().interpolateFrom(this.mpDst, lt);
                }
            }

            @Override
            public void finishAnimation() {
                super.finishAnimation();
                this.doAnim(1.0);
            }
        };
        resul.setDebugName("setMP");
        return resul;
    }

    public static Animation setStyle(double runtime, String styleName, MathObject ... objects) {
        Animation resul = Commands.setMP(runtime, MODrawProperties.createFromStyle(styleName), objects);
        resul.setDebugName("setStyle");
        return resul;
    }

    public static Animation cameraZoomToRect(double runtime, final Camera camera, final Rect rectToZoom) {
        Animation resul;
        if (camera instanceof Camera3D) {
            Camera3D camera3d = (Camera3D)camera;
            Vec vecLook = camera3d.look.to(rectToZoom.getCenter());
            Vec vecEye = camera3d.eye.to(rectToZoom.getCenter());
            vecEye.addInSite(Vec.to(0.0, 0.0, camera3d.getProperEyeHeight(rectToZoom)));
            resul = AnimationGroup.make(Commands.shift(runtime, vecEye, camera3d.eye), Commands.shift(runtime, vecLook, camera3d.look));
        } else {
            resul = new Animation(runtime){
                Camera cam;
                Rect rDst;
                Rect rSource;
                {
                    super(runTime);
                    this.cam = camera;
                    this.rDst = this.cam.getRectThatContains(rectToZoom);
                }

                @Override
                public void initialize(JMathAnimScene scene) {
                    super.initialize(scene);
                    this.rSource = this.cam.getMathView();
                }

                @Override
                public void doAnim(double t) {
                    double lt = this.getLambda().applyAsDouble(t);
                    Rect r = this.rSource.interpolate(this.rDst, lt);
                    this.cam.setMathView(r);
                }

                @Override
                public void finishAnimation() {
                    super.finishAnimation();
                    this.doAnim(1.0);
                }
            };
        }
        resul.setDebugName("cameraZoomToRect");
        return resul;
    }

    public static Animation cameraShift(double runtime, Camera camera, Vec shiftVector) {
        Animation resul = null;
        if (camera != null) {
            if (camera instanceof Camera3D) {
                Camera3D camera3d = (Camera3D)camera;
                resul = Commands.shift(runtime, shiftVector, camera3d.eye, camera3d.look);
            } else {
                Rect r = camera.getMathView().shifted(shiftVector);
                resul = Commands.cameraZoomToRect(runtime, camera, r);
            }
            resul.setDebugName("cameraShift");
        }
        return resul;
    }

    public static Animation cameraScale(double runtime, Camera cam, double scale) {
        Animation resul;
        if (cam instanceof Camera3D) {
            Camera3D camera3d = (Camera3D)cam;
            Vec shiftVector = camera3d.look.to(camera3d.eye).multInSite(scale - 1.0);
            resul = Commands.shift(runtime, shiftVector, camera3d.eye);
        } else {
            resul = Commands.cameraZoomToRect(runtime, cam, cam.getMathView().scale(scale, scale));
        }
        resul.setDebugName("cameraScale");
        return resul;
    }

    public static Animation camera3DRotate(double runtime, Camera3D cam, double angle) {
        return Commands.camera3DRotate(runtime, cam, angle, Axis.Z);
    }

    public static Animation camera3DRotate(double runtime, Camera3D cam, double angle, Axis axis) {
        double anglex = axis == Axis.X ? angle : 0.0;
        double angley = axis == Axis.Y ? angle : 0.0;
        double anglez = axis == Axis.Z ? angle : 0.0;
        Animation resul = Commands.rotate3d(runtime, cam.look, anglex, angley, anglez, cam.eye);
        resul.setDebugName("camera3DRotate");
        return resul;
    }

    public static Animation shrinkOut(double runtime, MathObject ... objects) {
        return Commands.shrinkOut(runtime, 0.0, objects);
    }

    public static Animation shrinkOut(double runtime, final double angle, final MathObject ... objects) {
        Animation anim = new Animation(runtime){
            MathObject[] mathObjects;
            {
                super(runTime);
                this.mathObjects = objects;
            }

            @Override
            public void initialize(JMathAnimScene scene) {
                super.initialize(scene);
                this.saveStates(this.mathObjects);
                this.addObjectsToscene(this.mathObjects);
            }

            @Override
            public void doAnim(double t) {
                double lt = this.getLambda().applyAsDouble(t);
                this.restoreStates(this.mathObjects);
                for (MathObject obj : this.mathObjects) {
                    obj.scale(1.0 - lt);
                    obj.multDrawAlpha(1.0 - lt);
                    obj.multFillAlpha(1.0 - lt);
                    obj.rotate(lt * angle);
                }
            }

            @Override
            public void finishAnimation() {
                super.finishAnimation();
                this.doAnim(1.0);
                this.removeObjectsFromScene(this.mathObjects);
            }
        };
        anim.setLambda(t -> t);
        anim.setDebugName("shrinkOut");
        return anim;
    }

    public static Animation growIn(double runtime, MathObject ... objects) {
        return Commands.growIn(runtime, 0.0, objects);
    }

    public static Animation growIn(double runtime, final double angle, final MathObject ... objects) {
        Animation anim = new Animation(runtime){
            MathObject[] mathObjects;
            {
                super(runTime);
                this.mathObjects = objects;
            }

            @Override
            public void initialize(JMathAnimScene scene) {
                super.initialize(scene);
                this.saveStates(this.mathObjects);
                this.addObjectsToscene(this.mathObjects);
                for (MathObject obj : this.mathObjects) {
                    obj.visible(false);
                }
            }

            @Override
            public void doAnim(double t) {
                double lt = this.getLambda().applyAsDouble(t);
                this.restoreStates(this.mathObjects);
                for (MathObject obj : this.mathObjects) {
                    obj.scale(lt);
                    obj.multDrawAlpha(lt);
                    obj.multFillAlpha(lt);
                    obj.rotate((1.0 - lt) * angle);
                }
            }

            @Override
            public void finishAnimation() {
                super.finishAnimation();
                this.doAnim(1.0);
            }
        };
        anim.setLambda(t -> t);
        anim.setDebugName("growIn");
        return anim;
    }

    public static AnimationWithEffects fadeIn(double runtime, final MathObject ... objects) {
        AnimationWithEffects anim = new AnimationWithEffects(runtime){
            MathObject[] mathObjects;
            {
                super(runTime);
                this.mathObjects = objects;
            }

            @Override
            public void initialize(JMathAnimScene scene) {
                super.initialize(scene);
                this.mathObjects = objects;
                this.saveStates(this.mathObjects);
                this.addObjectsToscene(this.mathObjects);
                for (MathObject obj : this.mathObjects) {
                    obj.visible(false);
                }
            }

            @Override
            public void doAnim(double t) {
                double lt = this.getLambda().applyAsDouble(t);
                this.restoreStates(this.mathObjects);
                for (MathObject obj : this.mathObjects) {
                    obj.multDrawAlpha(lt);
                    obj.multFillAlpha(lt);
                    this.applyAnimationEffects(lt, obj);
                }
            }

            @Override
            public void finishAnimation() {
                super.finishAnimation();
                this.doAnim(1.0);
            }
        };
        anim.setLambda(t -> t);
        anim.setDebugName("fadeIn");
        return anim;
    }

    public static AnimationWithEffects fadeOut(double runtime, final MathObject ... objects) {
        AnimationWithEffects anim = new AnimationWithEffects(runtime){
            MathObject[] mathObjects;
            {
                super(runTime);
                this.mathObjects = objects;
            }

            @Override
            public void initialize(JMathAnimScene sc) {
                super.initialize(sc);
                this.saveStates(this.mathObjects);
                sc.add(this.mathObjects);
            }

            @Override
            public void doAnim(double t) {
                double lt = this.getLambda().applyAsDouble(t);
                this.restoreStates(this.mathObjects);
                for (MathObject obj : this.mathObjects) {
                    obj.multDrawAlpha(1.0 - lt);
                    obj.multFillAlpha(1.0 - lt);
                    this.applyAnimationEffects(lt, obj);
                }
            }

            @Override
            public void finishAnimation() {
                super.finishAnimation();
                this.restoreStates(this.mathObjects);
                this.removeObjectsFromScene(this.mathObjects);
            }
        };
        anim.setLambda(t -> t);
        anim.setDebugName("fadeOut");
        return anim;
    }

    public static ShiftAnimation setLayout(double runtime, MathObject corner, MathObjectGroup.Layout layout, double gap, MathObjectGroup group) {
        group.saveState();
        group.setLayout(corner, layout, gap);
        final HashMap<MathObject, Point> centers = new HashMap<MathObject, Point>();
        int n = 0;
        for (MathObject ob : group) {
            centers.put(ob, ob.getCenter());
            ++n;
        }
        group.restoreState();
        final MathObject[] mathobjects = group.getObjects().toArray(new MathObject[group.size()]);
        ShiftAnimation resul = new ShiftAnimation(runtime, mathobjects){

            @Override
            public void initialize(JMathAnimScene scene) {
                super.initialize(scene);
                JMathAnimScene.logger.debug("Initialized setLayout animation");
                for (MathObject obj : mathobjects) {
                    Point dst = (Point)centers.get(obj);
                    this.setShiftVector(obj, obj.getCenter().to(dst));
                }
            }
        };
        resul.setDebugName("setLayout");
        return resul;
    }

    public static ShiftAnimation setLayout(double runtime, GroupLayout layout, MathObjectGroup group) {
        MathObjectGroup state = group.copy();
        group.setLayout(layout);
        final HashMap<MathObject, Point> centers = new HashMap<MathObject, Point>();
        int n = 0;
        for (MathObject ob : group) {
            centers.put(ob, ob.getCenter());
            ++n;
        }
        group.copyStateFrom(state);
        final MathObject[] mathobjects = group.getObjects().toArray(new MathObject[group.size()]);
        ShiftAnimation resul = new ShiftAnimation(runtime, mathobjects){

            @Override
            public void initialize(JMathAnimScene scene) {
                super.initialize(scene);
                JMathAnimScene.logger.debug("Initialized setLayout animation");
                for (MathObject obj : mathobjects) {
                    Point dst = (Point)centers.get(obj);
                    this.setShiftVector(obj, obj.getCenter().to(dst));
                }
            }
        };
        resul.setDebugName("setLayout");
        return resul;
    }

    public static AnimationWithEffects changeFillAlpha(double runTime, final MathObject ... objects) {
        AnimationWithEffects resul = new AnimationWithEffects(runTime){
            MathObject[] mathObjects;
            ArrayList<Double> alphaOrig;
            {
                super(runTime);
                this.mathObjects = objects;
                this.alphaOrig = new ArrayList();
            }

            @Override
            public void initialize(JMathAnimScene scene) {
                super.initialize(scene);
                JMathAnimScene.logger.debug("Initialized changeFillAlpha animation");
                this.addObjectsToscene(this.mathObjects);
                this.saveStates(this.mathObjects);
            }

            @Override
            public void doAnim(double t) {
                this.restoreStates(this.mathObjects);
                double lt = this.getLambda().applyAsDouble(t);
                for (MathObject obj : objects) {
                    obj.getMp().setFillAlpha(obj.getMp().getFillColor().getAlpha() * lt);
                    this.applyAnimationEffects(lt, obj);
                }
            }

            @Override
            public void finishAnimation() {
                super.finishAnimation();
                this.doAnim(1.0);
            }
        };
        resul.setDebugName("changeFillAlpha");
        return resul;
    }

    public static ShiftAnimation moveOut(double runtime, final Anchor.Type exitAnchor, final MathObject ... mathObjects) {
        ShiftAnimation resul = new ShiftAnimation(runtime, mathObjects){

            @Override
            public void initialize(JMathAnimScene scene) {
                super.initialize(scene);
                JMathAnimScene.logger.debug("Initialized moveOut animation");
                Rect r = JMathAnimConfig.getConfig().getCamera().getMathView();
                for (MathObject obj : mathObjects) {
                    Point p = Anchor.getAnchorPoint(obj, Anchor.reverseAnchorPoint(exitAnchor));
                    Point q = Anchor.getAnchorPoint(Shape.rectangle(r), exitAnchor, 1.0);
                    switch (exitAnchor) {
                        case LEFT: {
                            q.v.y = p.v.y;
                        }
                        case RIGHT: {
                            q.v.y = p.v.y;
                            break;
                        }
                        case UPPER: 
                        case LOWER: {
                            q.v.x = p.v.x;
                        }
                    }
                    this.setShiftVector(obj, p.to(q));
                }
            }

            @Override
            public void finishAnimation() {
                super.finishAnimation();
                for (MathObject obj : mathObjects) {
                    this.removeObjectsFromScene(obj);
                }
            }
        };
        resul.setDebugName("moveOut for " + mathObjects.length + " object(s)");
        return resul;
    }

    public static ShiftAnimation moveIn(double runtime, final Anchor.Type enterAnchor, final MathObject ... mathObjects) {
        final Rect r = JMathAnimConfig.getConfig().getCamera().getMathView();
        ShiftAnimation resul = new ShiftAnimation(runtime, mathObjects){

            @Override
            public void initialize(JMathAnimScene scene) {
                super.initialize(scene);
                JMathAnimScene.logger.debug("Initialized moveIn animation");
                for (MathObject obj : mathObjects) {
                    Anchor.Type reverseAnchor = Anchor.reverseAnchorPoint(enterAnchor);
                    Point p = Anchor.getAnchorPoint(obj, reverseAnchor);
                    Point q = Anchor.getAnchorPoint(Shape.rectangle(r), enterAnchor);
                    switch (enterAnchor) {
                        case LEFT: {
                            q.v.y = p.v.y;
                        }
                        case RIGHT: {
                            q.v.y = p.v.y;
                            break;
                        }
                        case UPPER: 
                        case LOWER: {
                            q.v.x = p.v.x;
                        }
                    }
                    obj.shift(p.to(q));
                    this.setShiftVector(obj, q.to(p));
                }
                this.saveStates(mathObjects);
            }
        };
        resul.setDebugName("moveIn for " + mathObjects.length + " object(s)");
        return resul;
    }

    public static FlipTransform flipTransform(double runtime, boolean horizontal, MathObject ob1, MathObject ob2) {
        return new FlipTransform(runtime, horizontal ? FlipTransform.FlipType.HORIZONTAL : FlipTransform.FlipType.VERTICAL, ob1, ob2);
    }

    public static ShiftAnimation align(double runtime, final MathObject dst, final MathObject.Align type, final MathObject ... mathobjects) {
        ShiftAnimation resul = new ShiftAnimation(runtime, mathobjects){

            @Override
            public void initialize(JMathAnimScene scene) {
                super.initialize(scene);
                JMathAnimScene.logger.debug("Initialized align animation");
                for (MathObject obj : mathobjects) {
                    Point dstCenter = ((MathObject)Shape.rectangle(obj.getBoundingBox()).align(dst, type)).getCenter();
                    this.setShiftVector(obj, obj.getCenter().to(dstCenter));
                }
            }
        };
        resul.setDebugName("align for " + mathobjects.length + " object(s)");
        return resul;
    }

    public static ShiftAnimation stackTo(double runtime, final MathObject dst, final Anchor.Type type, final double gap, final MathObject ... mathobjects) {
        ShiftAnimation resul = new ShiftAnimation(runtime, mathobjects){

            @Override
            public void initialize(JMathAnimScene scene) {
                MathObject previous = dst;
                super.initialize(scene);
                for (MathObject obj : mathobjects) {
                    Object objc = Shape.rectangle(obj.getBoundingBox()).stackTo(previous, type, gap);
                    this.setShiftVector(obj, obj.getCenter().to(((MathObject)objc).getCenter()));
                    previous = objc;
                }
            }
        };
        resul.setDebugName("stackTo for " + mathobjects.length + " object(s)");
        return resul;
    }

    public static Animation crossOut(double runtime, MathObject obj) {
        Rect bbox = obj.getBoundingBox();
        Shape s1 = (Shape)((MathObject)((MathObject)((MathObject)Shape.segment(bbox.getUL(), bbox.getDR()).scale(0.75)).linecap(StrokeLineCap.BUTT)).drawColor(JMColor.RED)).layer(Integer.MAX_VALUE);
        Shape s2 = (Shape)((MathObject)((MathObject)((MathObject)Shape.segment(bbox.getUR(), bbox.getDL()).scale(0.75)).linecap(StrokeLineCap.BUTT)).drawColor(JMColor.RED)).layer(Integer.MAX_VALUE);
        double longi = 0.25 * s1.getPoint(0).to(s1.getPoint(1)).norm();
        double width = JMathAnimConfig.getConfig().getRenderer().MathWidthToThickness(longi);
        ((MathObject)s1.thickness(width)).getMp().setAbsoluteThickness(false);
        ((MathObject)s2.thickness(width)).getMp().setAbsoluteThickness(false);
        Concatenate resul = new Concatenate(new ShowCreation(0.5 * runtime, s1), new ShowCreation(0.5 * runtime, s2));
        resul.setDebugName("crossOut");
        return resul;
    }

    public static enum Axis {
        X,
        Y,
        Z;

    }
}

