/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations;

import com.jmathanim.Animations.Animation;
import com.jmathanim.jmathanim.JMathAnimScene;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.DoubleUnaryOperator;

public class Concatenate
extends Animation {
    private final ArrayList<Animation> animations = new ArrayList();
    private int currentAnim;

    public static Concatenate make(Animation ... anims) {
        return new Concatenate(anims);
    }

    public Concatenate() {
        this(new ArrayList<Animation>());
    }

    public Concatenate(Animation ... anims) {
        this(Arrays.asList(anims));
    }

    public Concatenate(List<Animation> anims) {
        super(0.0);
        this.animations.addAll(anims);
        this.currentAnim = 0;
    }

    public final boolean add(Animation e) {
        return this.animations.add(e);
    }

    @Override
    public void initialize(JMathAnimScene scene) {
        super.initialize(scene);
        this.animations.get(0).initialize(scene);
    }

    @Override
    public boolean processAnimation() {
        if (this.currentAnim == this.animations.size()) {
            return true;
        }
        boolean resul = this.animations.get(this.currentAnim).processAnimation();
        if (resul) {
            this.animations.get(this.currentAnim).finishAnimation();
            ++this.currentAnim;
            if (this.currentAnim < this.animations.size()) {
                this.animations.get(this.currentAnim).initialize(this.scene);
                resul = this.animations.get(this.currentAnim).processAnimation();
            }
        }
        if (this.currentAnim == this.animations.size() - 1) {
            return resul;
        }
        return false;
    }

    @Override
    public void finishAnimation() {
        super.finishAnimation();
        for (Animation an : this.animations) {
            if (an.getStatus() == Animation.Status.NOT_INITIALIZED) {
                an.initialize(this.scene);
            }
            if (an.getStatus() == Animation.Status.FINISHED) continue;
            an.finishAnimation();
        }
    }

    @Override
    public void doAnim(double t) {
    }

    @Override
    public <T extends Animation> T setLambda(DoubleUnaryOperator lambda) {
        super.setLambda(lambda);
        for (Animation anim : this.animations) {
            anim.setLambda(lambda);
        }
        return (T)this;
    }
}

