/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations;

import com.jmathanim.Animations.Animation;
import com.jmathanim.Styling.JMColor;
import com.jmathanim.Utils.Rect;
import com.jmathanim.Utils.UsefulLambdas;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.Arrow2D;
import com.jmathanim.mathobjects.Line;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MathObjectGroup;
import com.jmathanim.mathobjects.MultiShapeObject;
import com.jmathanim.mathobjects.Shape;

public class ContourHighlight
extends Animation {
    MathObject[] objs;
    JMColor highlightColor;
    double thickness;
    double amplitude;

    public static ContourHighlight make(double runTime, MathObject ... objs) {
        return new ContourHighlight(runTime, objs);
    }

    public static ContourHighlight make(double runTime, Rect r) {
        return new ContourHighlight(runTime, Shape.rectangle(r));
    }

    public ContourHighlight(double runTime, MathObject ... objs) {
        super(runTime);
        this.objs = objs;
        this.highlightColor = JMColor.parse("red");
        this.thickness = 10.0;
        this.amplitude = 0.4;
    }

    @Override
    public void initialize(JMathAnimScene scene) {
        super.initialize(scene);
    }

    @Override
    public void doAnim(double t) {
        if (t >= 1.0) {
            return;
        }
        double lt = this.getLambda().applyAsDouble(t);
        double b = UsefulLambdas.allocateTo(0.0, 1.0 - 0.5 * this.amplitude).applyAsDouble(lt);
        double a = UsefulLambdas.allocateTo(0.5 * this.amplitude, 1.0).applyAsDouble(lt);
        for (MathObject obj : this.objs) {
            this.process(obj, a, b);
        }
    }

    private void process(MathObject obj, double a, double b) {
        if (obj instanceof Line) {
            Line line = (Line)obj;
            this.addSubShapeToScene(line.toSegment(this.scene.getCamera()), a, b);
            return;
        }
        if (obj instanceof Arrow2D) {
            Arrow2D ar = (Arrow2D)obj;
            this.addSubShapeToScene(ar.getBody(), a, b);
            return;
        }
        if (obj instanceof MultiShapeObject) {
            MultiShapeObject msh = (MultiShapeObject)obj;
            for (Shape sh : msh) {
                this.addSubShapeToScene(sh, a, b);
            }
        }
        if (obj instanceof MathObjectGroup) {
            MathObjectGroup mg = (MathObjectGroup)obj;
            for (MathObject subObject : mg) {
                this.process(subObject, a, b);
            }
        }
        if (obj instanceof Shape) {
            Shape sh = (Shape)obj;
            this.addSubShapeToScene(sh, a, b);
        }
    }

    private void addSubShapeToScene(Shape sh, double a, double b) {
        Shape sub = sh.getSubShape(Math.min(a, b), Math.max(a, b));
        ((MathObject)((MathObject)((MathObject)sub.style("default")).thickness(this.thickness)).fillAlpha(0.0)).drawColor(this.highlightColor);
        this.scene.addOnce(sub);
    }

    public ContourHighlight setAmplitude(double amplitude) {
        this.amplitude = amplitude;
        return this;
    }

    public ContourHighlight setColor(JMColor color) {
        this.highlightColor = color;
        return this;
    }

    public ContourHighlight setColor(String strColor) {
        this.highlightColor = JMColor.parse(strColor);
        return this;
    }

    public double getThickness() {
        return this.thickness;
    }

    public ContourHighlight setThickness(double thickness) {
        this.thickness = thickness;
        return this;
    }
}

