/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations;

import com.jmathanim.Animations.AnimationWithEffects;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;

public class FlipTransform
extends AnimationWithEffects {
    private final FlipType flipType;
    private final MathObject objOrig;
    private final MathObject objDst;
    private final Point origCenter;
    private final Point dstCenter;

    public FlipTransform(double runTime, FlipType flipType, MathObject objOrig, MathObject objDst) {
        super(runTime);
        this.setDebugName("FlipTransform");
        this.flipType = flipType;
        this.objDst = objDst;
        this.objOrig = objOrig;
        this.origCenter = objOrig.getCenter();
        this.dstCenter = objDst.getCenter();
    }

    public static FlipTransform HFlip(double runTime, MathObject objOrig, MathObject objDst) {
        return new FlipTransform(runTime, FlipType.HORIZONTAL, objOrig, objDst);
    }

    public static FlipTransform VFlip(double runTime, MathObject objOrig, MathObject objDst) {
        return new FlipTransform(runTime, FlipType.VERTICAL, objOrig, objDst);
    }

    public static FlipTransform Flip(double runTime, MathObject objOrig, MathObject objDst) {
        return new FlipTransform(runTime, FlipType.BOTH, objOrig, objDst);
    }

    @Override
    public void initialize(JMathAnimScene scene) {
        super.initialize(scene);
        this.addObjectsToscene(this.objOrig, this.objDst);
        this.saveStates(this.objOrig, this.objDst);
        this.objDst.visible(false);
        this.prepareJumpPath(this.origCenter, this.dstCenter, this.objDst);
        this.prepareJumpPath(this.origCenter, this.dstCenter, this.objOrig);
    }

    @Override
    public void doAnim(double t) {
        double lt = this.getLambda().applyAsDouble(t);
        this.objOrig.visible(lt < 0.5);
        this.objDst.visible(lt >= 0.5);
        MathObject objectToScale = lt < 0.5 ? this.objOrig : this.objDst;
        this.restoreStates(objectToScale);
        double[] scales = this.computeScale(lt);
        objectToScale.scale(scales[0], scales[1]);
        objectToScale.moveTo(this.origCenter.interpolate(this.dstCenter, lt));
        this.applyAnimationEffects(lt, objectToScale);
    }

    @Override
    public void finishAnimation() {
        super.finishAnimation();
        this.removeObjectsFromScene(this.objOrig);
    }

    private double[] computeScale(double lt) {
        double[] scales = new double[2];
        switch (this.flipType) {
            case HORIZONTAL: {
                scales[0] = lt < 0.5 ? 1.0 - 2.0 * lt : 2.0 * lt - 1.0;
                scales[1] = 1.0;
                break;
            }
            case VERTICAL: {
                scales[0] = 1.0;
                scales[1] = lt < 0.5 ? 1.0 - 2.0 * lt : 2.0 * lt - 1.0;
                break;
            }
            case BOTH: {
                scales[0] = lt < 0.5 ? 1.0 - 2.0 * lt : 2.0 * lt - 1.0;
                scales[1] = lt < 0.5 ? 1.0 - 2.0 * lt : 2.0 * lt - 1.0;
            }
        }
        return scales;
    }

    public static enum FlipType {
        HORIZONTAL,
        VERTICAL,
        BOTH;

    }
}

