/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations;

import com.jmathanim.Animations.Animation;
import com.jmathanim.jmathanim.JMathAnimScene;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class JoinAnimation
extends Animation {
    ArrayList<Animation> animations = new ArrayList();
    double[] steps;

    public static JoinAnimation make(double runTime, Animation ... anims) {
        JoinAnimation resul = new JoinAnimation(runTime, anims);
        resul.setLambda(t -> t);
        return resul;
    }

    private JoinAnimation(double runTime, Animation ... anims) {
        super(runTime);
        this.animations.addAll(Arrays.asList(anims));
    }

    @Override
    public void initialize(JMathAnimScene scene) {
        super.initialize(scene);
        double totalSum = this.animations.stream().collect(Collectors.summingDouble(Animation::getRunTime));
        this.steps = new double[this.animations.size() + 1];
        this.steps[0] = 0.0;
        double partialSum = 0.0;
        for (int i = 0; i < this.animations.size(); ++i) {
            this.steps[i + 1] = (partialSum += this.animations.get(i).getRunTime()) / totalSum;
        }
    }

    @Override
    public void doAnim(double t) {
        double lt = this.getLambda().applyAsDouble(t);
        int num = this.getAnimationNumberForTime(lt);
        double ltNormalized = (lt - this.steps[num]) / (this.steps[num + 1] - this.steps[num]);
        Animation anim = this.animations.get(num);
        if (anim.getStatus() == Animation.Status.NOT_INITIALIZED) {
            if (num > 0) {
                for (int k = 0; k < num; ++k) {
                    if (this.animations.get(k).getStatus() == Animation.Status.NOT_INITIALIZED) {
                        this.animations.get(k).initialize(this.scene);
                        this.animations.get(k).doAnim(1.0);
                    }
                    this.animations.get(k).finishAnimation();
                }
            }
            anim.initialize(this.scene);
        }
        anim.doAnim(ltNormalized);
    }

    @Override
    public void finishAnimation() {
        double lt = this.getLambda().applyAsDouble(1.0);
        if (lt == 1.0) {
            this.animations.get(this.animations.size() - 1).finishAnimation();
        }
    }

    private int getAnimationNumberForTime(double t) {
        if (t == 0.0) {
            return 0;
        }
        int num = 0;
        while (t > this.steps[num]) {
            ++num;
        }
        return --num;
    }

    public boolean add(Animation e) {
        return this.animations.add(e);
    }

    public void add(int index, Animation element) {
        this.animations.add(index, element);
    }

    public ArrayList<Animation> getAnimations() {
        return this.animations;
    }
}

