/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations.MathTransform;

import com.jmathanim.Animations.Animation;
import com.jmathanim.Animations.AnimationGroup;
import com.jmathanim.Animations.AnimationWithEffects;
import com.jmathanim.Animations.Commands;
import com.jmathanim.Animations.FlipTransform;
import com.jmathanim.Animations.MathTransform.TransformMathExpressionParameters;
import com.jmathanim.Animations.MathTransform.TransformMathExpressionParametersArray;
import com.jmathanim.Animations.Transform;
import com.jmathanim.Utils.Anchor;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MultiShapeObject;
import com.jmathanim.mathobjects.Shape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TransformMathExpression
extends Animation {
    private final MultiShapeObject latexDestiny;
    private final MultiShapeObject latexTransformed;
    private final AnimationGroup anim;
    private final ArrayList<Shape> toDelete;
    private final HashMap<String, int[]> trParOrigGroups;
    private final HashMap<String, int[]> trParDstGroups;
    private final HashMap<String, String> trParMaps;
    private final HashMap<String, TransformMathExpressionParameters> trParTransformParameters;
    private final HashMap<Integer, TransformMathExpressionParameters> removeInOrigParameters;
    private final HashMap<Integer, TransformMathExpressionParameters> addInDstParameters;

    public TransformMathExpression(double runTime, MultiShapeObject latexTransformed, MultiShapeObject latexDestiny) {
        super(runTime);
        int n;
        this.latexTransformed = latexTransformed;
        this.latexDestiny = latexDestiny;
        this.anim = new AnimationGroup(new Animation[0]);
        this.toDelete = new ArrayList();
        this.trParOrigGroups = new HashMap();
        this.trParDstGroups = new HashMap();
        this.trParMaps = new HashMap();
        this.trParTransformParameters = new HashMap();
        this.removeInOrigParameters = new HashMap();
        this.addInDstParameters = new HashMap();
        for (n = 0; n < this.latexTransformed.size(); ++n) {
            this.removeInOrigParameters.put(n, new TransformMathExpressionParameters());
        }
        for (n = 0; n < this.latexDestiny.size(); ++n) {
            this.addInDstParameters.put(n, new TransformMathExpressionParameters());
        }
    }

    @Override
    public void initialize(JMathAnimScene scene) {
        super.initialize(scene);
        this.removeObjectsFromScene(this.latexTransformed);
        HashMap<String, int[]> or = this.trParOrigGroups;
        HashMap<String, int[]> dst = this.trParDstGroups;
        HashMap<String, String> maps = this.trParMaps;
        for (String name1 : maps.keySet()) {
            Shape sh1;
            int k;
            Shape sh2;
            int nOrig;
            String name2 = maps.get(name1);
            ArrayList<Shape> listDst = this.getShapeListForGroup(dst, name2, this.latexDestiny, this.addInDstParameters);
            ArrayList<Shape> listOrig = this.getShapeListForGroup(or, name1, this.latexTransformed, this.removeInOrigParameters);
            int nDst = listDst.size();
            if (nDst < (nOrig = listOrig.size())) {
                for (Shape sh : listOrig) {
                    sh2 = this.getShapeForGroup(dst, name2, this.latexDestiny, this.addInDstParameters);
                    this.createTransformSubAnimation(sh, sh2, this.trParTransformParameters.get(name1));
                }
                continue;
            }
            for (k = 0; k < nOrig; ++k) {
                sh1 = listOrig.get(k);
                sh2 = listDst.get(k);
                this.createTransformSubAnimation(sh1, sh2, this.trParTransformParameters.get(name1));
            }
            for (k = 0; k < nDst - nOrig; ++k) {
                sh1 = listOrig.get(nOrig - 1).copy();
                sh2 = listDst.get(nOrig + k);
                this.createTransformSubAnimation(sh1, sh2, this.trParTransformParameters.get(name1));
            }
        }
        Iterator<Object> iterator = this.removeInOrigParameters.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.createRemovingSubAnimation(n, this.removeInOrigParameters.get(n));
        }
        iterator = this.addInDstParameters.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            Shape sh = this.latexDestiny.get(n);
            this.createAddingSubAnimation(sh, this.addInDstParameters.get(n));
        }
        this.anim.initialize(scene);
    }

    private void createRemovingSubAnimation(int n, TransformMathExpressionParameters par) {
        Shape sh = this.latexTransformed.get(n);
        this.addObjectsToscene(sh);
        AnimationGroup group = new AnimationGroup(new Animation[0]);
        switch (par.getRemovingStyle()) {
            case FADE_OUT: {
                group.add(new Animation[]{Commands.fadeOut(this.runTime, sh).setLambda(t -> Math.sqrt(t))});
                break;
            }
            case SHRINK_OUT: {
                group.add(Commands.shrinkOut(this.runTime, sh));
                break;
            }
            case MOVE_OUT_UP: {
                group.add(new Animation[]{Commands.moveOut(this.runTime, Anchor.Type.UPPER, sh).setLambda(this.lambda)});
                break;
            }
            case MOVE_OUT_LEFT: {
                group.add(new Animation[]{Commands.moveOut(this.runTime, Anchor.Type.LEFT, sh).setLambda(this.lambda)});
                break;
            }
            case MOVE_OUT_RIGHT: {
                group.add(new Animation[]{Commands.moveOut(this.runTime, Anchor.Type.RIGHT, sh).setLambda(this.lambda)});
                break;
            }
            case MOVE_OUT_DOWN: {
                group.add(new Animation[]{Commands.moveOut(this.runTime, Anchor.Type.LOWER, sh).setLambda(this.lambda)});
            }
        }
        if (par.getNumTurns() != 0) {
            AnimationWithEffects rotation = Commands.rotate(this.runTime, Math.PI * 2 * (double)par.getNumTurns(), sh);
            rotation.setUseObjectState(false);
            group.add(rotation);
        }
        this.anim.add(group);
    }

    private void createAddingSubAnimation(Shape sh, TransformMathExpressionParameters par) {
        AnimationGroup group = new AnimationGroup(new Animation[0]);
        switch (par.getAddingStyle()) {
            case FADE_IN: {
                this.anim.add(new Animation[]{Commands.fadeIn(this.runTime, sh).setLambda(this.lambda)});
                break;
            }
            case GROW_IN: {
                this.anim.add(new Animation[]{Commands.growIn(this.runTime, sh).setLambda(this.lambda)});
                break;
            }
            case MOVE_IN_UP: {
                this.anim.add(new Animation[]{Commands.moveIn(this.runTime, Anchor.Type.UPPER, sh).setLambda(this.lambda)});
                break;
            }
            case MOVE_IN_LEFT: {
                this.anim.add(new Animation[]{Commands.moveIn(this.runTime, Anchor.Type.LEFT, sh).setLambda(this.lambda)});
                break;
            }
            case MOVE_IN_RIGHT: {
                this.anim.add(new Animation[]{Commands.moveIn(this.runTime, Anchor.Type.RIGHT, sh).setLambda(this.lambda)});
                break;
            }
            case MOVE_IN_DOWN: {
                this.anim.add(new Animation[]{Commands.moveIn(this.runTime, Anchor.Type.LOWER, sh).setLambda(this.lambda)});
            }
        }
        if (par.getNumTurns() != 0) {
            AnimationWithEffects rotation = Commands.rotate(this.runTime, Math.PI * 2 * (double)par.getNumTurns(), sh);
            rotation.setUseObjectState(false);
            group.add(rotation);
        }
        this.anim.add(group);
        this.toDelete.add(sh);
    }

    private void createTransformSubAnimation(Shape sh, Shape sh2, TransformMathExpressionParameters par) {
        Animation transform = null;
        switch (par.getTransformStyle()) {
            case INTERPOLATION: {
                transform = new Transform(this.runTime, sh, sh2);
                break;
            }
            case FLIP_HORIZONTALLY: {
                transform = new FlipTransform(this.runTime, FlipTransform.FlipType.HORIZONTAL, sh, sh2);
                break;
            }
            case FLIP_VERTICALLY: {
                transform = new FlipTransform(this.runTime, FlipTransform.FlipType.VERTICAL, sh, sh2);
                break;
            }
            case FLIP_BOTH: {
                transform = new FlipTransform(this.runTime, FlipTransform.FlipType.BOTH, sh, sh2);
            }
        }
        transform.setLambda(this.lambda);
        if (par.getJumpHeightFromJumpEffect() != 0.0) {
            ((AnimationWithEffects)transform).addJumpEffect(par.getJumpHeightFromJumpEffect(), par.getJumptype());
        }
        if (par.getNumTurns() != 0) {
            ((AnimationWithEffects)transform).addRotationEffect(par.getNumTurns());
            transform.setLambda(t -> t);
        }
        if (par.getAlphaMultFromAlphaEffect() != 1.0) {
            ((AnimationWithEffects)transform).addAlphaEffect(par.getAlphaMultFromAlphaEffect());
        }
        if (par.getScaleFromScaleEffect() != 1.0) {
            ((AnimationWithEffects)transform).addScaleEffect(par.getScaleFromScaleEffect());
        }
        this.anim.add(transform);
        this.toDelete.add(sh);
        this.toDelete.add(sh2);
    }

    private ArrayList<Shape> getShapeListForGroup(HashMap<String, int[]> or, String names, MultiShapeObject lat, HashMap<Integer, TransformMathExpressionParameters> listRemainders) {
        ArrayList<Shape> resul = new ArrayList<Shape>();
        int[] gr = or.get(names);
        for (int n = 0; n < gr.length; ++n) {
            resul.add(lat.get(gr[n]).copy());
            listRemainders.remove(gr[n]);
        }
        return resul;
    }

    private Shape getShapeForGroup(HashMap<String, int[]> or, String names, MultiShapeObject lat, HashMap<Integer, TransformMathExpressionParameters> listRemainders) {
        int[] gr = or.get(names);
        Shape sh = lat.get(gr[0]).copy();
        listRemainders.remove(gr[0]);
        for (int n = 1; n < gr.length; ++n) {
            sh.merge(lat.get(gr[n]).copy(), false, false);
            listRemainders.remove(gr[n]);
        }
        return sh;
    }

    @Override
    public boolean processAnimation() {
        return this.anim.processAnimation();
    }

    @Override
    public void doAnim(double t) {
    }

    @Override
    public void finishAnimation() {
        super.finishAnimation();
        this.anim.finishAnimation();
        for (Shape sh : this.toDelete) {
            this.removeObjectsFromScene(sh);
        }
        this.addObjectsToscene(this.latexDestiny);
    }

    public TransformMathExpressionParameters map(int i, int j) {
        return this.map(this.defineOrigGroup("_" + i, i), this.defineDstGroup("_" + j, j));
    }

    public TransformMathExpressionParameters map(String name, int j) {
        return this.map(name, this.defineDstGroup("_" + j, j));
    }

    public TransformMathExpressionParametersArray mapRange(int i1, int i2, int j) {
        TransformMathExpressionParametersArray ar = new TransformMathExpressionParametersArray();
        for (int n = 0; n <= i2 - i1; ++n) {
            int ind = i1 + n;
            this.map(ind, j + n);
            ar.add(this.trParTransformParameters.get("_" + ind));
        }
        return ar;
    }

    public TransformMathExpressionParametersArray mapAll() {
        int n = Math.min(this.latexDestiny.size() - 1, this.latexTransformed.size() - 1);
        return this.mapRange(0, n, 0);
    }

    public TransformMathExpressionParameters map(int i, String name) {
        return this.map(this.defineOrigGroup("_" + i, i), name);
    }

    public TransformMathExpressionParameters map(String origName, String dstName) {
        this.trParMaps.put(origName, dstName);
        TransformMathExpressionParameters par = new TransformMathExpressionParameters();
        this.trParTransformParameters.put(origName, par);
        return par;
    }

    public TransformMathExpressionParametersArray setRemovingStyle(RemoveType type, int ... indices) {
        TransformMathExpressionParametersArray ar = new TransformMathExpressionParametersArray();
        for (int i : indices) {
            if (!this.removeInOrigParameters.containsKey(i)) continue;
            this.removeInOrigParameters.get(i).setRemovingStyle(type);
            ar.add(this.removeInOrigParameters.get(i));
        }
        return ar;
    }

    public TransformMathExpressionParametersArray setAddingStyle(AddType type, int ... indices) {
        TransformMathExpressionParametersArray ar = new TransformMathExpressionParametersArray();
        for (int i : indices) {
            if (!this.addInDstParameters.containsKey(i)) continue;
            this.addInDstParameters.get(i).setAddingStyle(type);
            ar.add(this.addInDstParameters.get(i));
        }
        return ar;
    }

    public String defineOrigGroup(String name, int ... indices) {
        for (int i : indices) {
            String belongsToAnOrigGroup = this.belongsToAnOrigGroup(i);
            if ("".equals(belongsToAnOrigGroup)) continue;
            JMathAnimScene.logger.error("Index " + i + " already belongs to a created group " + belongsToAnOrigGroup + ". Weird results may occur.");
        }
        this.trParOrigGroups.put(name, indices);
        return name;
    }

    public String defineDstGroup(String name, int ... indices) {
        for (int i : indices) {
            String belongsToADstGroup = this.belongsToADstGroup(i);
            if ("".equals(belongsToADstGroup)) continue;
            JMathAnimScene.logger.error("Index " + i + " already belongs to a created group " + belongsToADstGroup + ". Weird results may occur.");
        }
        this.trParDstGroups.put(name, indices);
        return name;
    }

    private String belongsToAnOrigGroup(int index) {
        for (String p : this.trParOrigGroups.keySet()) {
            int[] li = this.trParOrigGroups.get(p);
            for (int n = 0; n < li.length; ++n) {
                if (li[n] != index) continue;
                return p;
            }
        }
        return "";
    }

    private String belongsToADstGroup(int index) {
        for (String p : this.trParDstGroups.keySet()) {
            List ar = Arrays.asList(new int[][]{this.trParDstGroups.get(p)});
            if (!ar.contains(index)) continue;
            return p;
        }
        return "";
    }

    public static enum RemoveType {
        FADE_OUT,
        SHRINK_OUT,
        MOVE_OUT_UP,
        MOVE_OUT_LEFT,
        MOVE_OUT_RIGHT,
        MOVE_OUT_DOWN;

    }

    public static enum AddType {
        FADE_IN,
        GROW_IN,
        MOVE_IN_UP,
        MOVE_IN_LEFT,
        MOVE_IN_RIGHT,
        MOVE_IN_DOWN;

    }

    public static enum TransformType {
        INTERPOLATION,
        FLIP_HORIZONTALLY,
        FLIP_VERTICALLY,
        FLIP_BOTH;

    }
}

