/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations;

import com.jmathanim.Animations.Animation;
import com.jmathanim.Animations.Commands;
import com.jmathanim.Animations.ContourHighlight;
import com.jmathanim.Animations.ShowCreation;
import com.jmathanim.Animations.Transform;
import com.jmathanim.Cameras.Camera;
import com.jmathanim.Styling.PaintStyle;
import com.jmathanim.Utils.Anchor;
import com.jmathanim.Utils.Rect;
import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MathObjectGroup;
import com.jmathanim.mathobjects.MultiShapeObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;
import java.util.ArrayList;

public class PlayAnim {
    public double defaultRunTimeshowCreation = 1.0;
    public double defaultRunTimefadeIn = 1.0;
    public double defaultRunTimefadeOut = 1.0;
    public double defaultRunTimeGrowIn = 1.0;
    public double defaultRunTimeShrinkOut = 1.0;
    public double defaultRunTimeHighlight = 1.0;
    public double defaultRunTimeCamera = 1.0;
    public double defaultRunTimeMoveOut = 1.0;
    public double defaultRunTimeMoveIn = 1.0;
    private final JMathAnimScene scene;

    public PlayAnim(JMathAnimScene scene) {
        this.scene = scene;
    }

    public void fadeIn(MathObject ... objs) {
        this.fadeIn(this.defaultRunTimefadeIn, objs);
    }

    public void fadeIn(double runtime, MathObject ... objs) {
        this.scene.playAnimation(Commands.fadeIn(runtime, objs));
    }

    public void fadeOut(MathObject ... objs) {
        this.fadeOut(this.defaultRunTimefadeOut, objs);
    }

    public void fadeOut(double runtime, MathObject ... objs) {
        this.scene.playAnimation(Commands.fadeOut(runtime, objs));
    }

    public void fadeOutAll() {
        this.fadeOutAll(this.defaultRunTimefadeOut);
    }

    public void fadeOutAll(double runtime) {
        MathObject[] objects = this.scene.getObjects().toArray(new MathObject[this.scene.getObjects().size()]);
        this.scene.playAnimation(Commands.fadeOut(runtime, objects));
    }

    public void fadeOutAllBut(double runtime, MathObject ... objs) {
        ArrayList<MathObject> toRemove = new ArrayList<MathObject>();
        toRemove.addAll(this.scene.getObjects());
        for (MathObject obj : objs) {
            if (obj instanceof MultiShapeObject) {
                for (Shape sh : (MultiShapeObject)obj) {
                    toRemove.remove(sh);
                }
            }
            if (obj instanceof MathObjectGroup) {
                for (MathObject o : (MathObjectGroup)obj) {
                    toRemove.remove(o);
                }
            }
            toRemove.remove(obj);
        }
        MathObject[] objects = toRemove.toArray(new MathObject[toRemove.size()]);
        this.scene.playAnimation(Commands.fadeOut(runtime, objects));
    }

    public void moveOut(double runtime, Anchor.Type exitAnchor, MathObject ... mathObjects) {
        this.scene.playAnimation(Commands.moveOut(runtime, exitAnchor, mathObjects));
    }

    public void moveOut(Anchor.Type exitAnchor, MathObject ... mathObjects) {
        this.scene.playAnimation(Commands.moveOut(this.defaultRunTimeMoveOut, exitAnchor, mathObjects));
    }

    public void moveIn(double runtime, Anchor.Type enterAnchor, MathObject ... mathObjects) {
        this.scene.playAnimation(Commands.moveIn(runtime, enterAnchor, mathObjects));
    }

    public void moveIn(Anchor.Type enterAnchor, MathObject ... mathObjects) {
        this.scene.playAnimation(Commands.moveIn(this.defaultRunTimeMoveIn, enterAnchor, mathObjects));
    }

    public void shift(double runtime, double dx, double dy, MathObject ... objs) {
        this.scene.playAnimation(Commands.shift(runtime, dx, dy, objs));
    }

    public void shift(double runtime, Vec v, MathObject ... objs) {
        this.scene.playAnimation(Commands.shift(runtime, v, objs));
    }

    public void scale(double runTime, Point center, double scaleFactor, MathObject ... objs) {
        this.scale(runTime, center, scaleFactor, scaleFactor, scaleFactor, objs);
    }

    public void scale(double runTime, double scaleFactor, MathObject ... objs) {
        this.scale(runTime, scaleFactor, scaleFactor, objs);
    }

    public void scale(double runTime, double scx, double scy, MathObject ... objs) {
        Rect r = objs[0].getBoundingBox();
        for (MathObject obj : objs) {
            r = Rect.union(r, obj.getBoundingBox());
        }
        this.scene.playAnimation(Commands.scale(runTime, r.getCenter(), scx, scy, 1.0, objs));
    }

    public void scale(double runTime, Point center, double scx, double scy, MathObject ... objs) {
        this.scene.playAnimation(Commands.scale(runTime, center, scx, scy, 1.0, objs));
    }

    public void scale(double runTime, Point center, double scx, double scy, double scz, MathObject ... objs) {
        this.scene.playAnimation(Commands.scale(runTime, center, scx, scy, scz, objs));
    }

    public void rotate(double runTime, double angle, MathObject ... objs) {
        Rect r = objs[0].getBoundingBox();
        for (MathObject obj : objs) {
            r = Rect.union(r, obj.getBoundingBox());
        }
        this.scene.playAnimation(Commands.rotate(runTime, r.getCenter(), angle, objs));
    }

    public void rotate(double runTime, Point center, double angle, MathObject ... objs) {
        this.scene.playAnimation(Commands.rotate(runTime, center, angle, objs));
    }

    public void transform(double runTime, MathObject transformed, MathObject destiny) {
        this.scene.playAnimation(new Transform(runTime, transformed, destiny));
    }

    public void adjustCameraToAllObjects() {
        this.adjustCameraToAllObjects(this.defaultRunTimeCamera);
    }

    public void adjustCameraToAllObjects(double runtime) {
        Vec gaps = this.scene.getCamera().getGaps();
        Rect r = this.scene.getCamera().getMathView();
        for (MathObject obj : this.scene.getObjects()) {
            r = Rect.union(r, obj.getBoundingBox().addGap(gaps.x, gaps.y));
        }
        this.zoomToRect(runtime, r);
    }

    public void adjustToObjects(MathObject ... objs) {
        this.adjustToObjects(this.defaultRunTimeCamera, objs);
    }

    public void adjustToObjects(double runTime, MathObject ... objs) {
        Vec gaps = this.scene.getCamera().getGaps();
        Rect r = this.scene.getCamera().getMathView();
        for (MathObject obj : objs) {
            r = Rect.union(r, obj.getBoundingBox().addGap(gaps.x, gaps.y));
        }
        this.zoomToRect(runTime, r);
    }

    public void zoomToObjects(double runTime, MathObject ... objs) {
        Rect r = objs[0].getBoundingBox();
        for (MathObject obj : objs) {
            r = Rect.union(r, obj.getBoundingBox());
        }
        this.zoomToRect(runTime, r);
    }

    private void zoomToRect(double runTime, Camera cam, Rect r) {
        this.scene.playAnimation(Commands.cameraZoomToRect(runTime, cam, r));
    }

    public void zoomToRect(double runTime, Rect rect) {
        this.zoomToRect(runTime, this.scene.getCamera(), rect);
    }

    public void cameraScale(double runTime, double scale) {
        this.cameraScale(runTime, this.scene.getCamera(), scale);
    }

    private void cameraScale(double runTime, Camera cam, double scale) {
        this.scene.playAnimation(Commands.cameraScale(runTime, cam, scale));
    }

    private void cameraShift(double runTime, Vec v, Camera cam) {
        this.scene.playAnimation(Commands.cameraShift(runTime, cam, v));
    }

    public void cameraShift(double runTime, Vec v) {
        this.cameraShift(runTime, v, this.scene.getCamera());
    }

    public void cameraShift(double runTime, double x, double y) {
        this.cameraShift(runTime, new Vec(x, y), this.scene.getCamera());
    }

    public void highlight(MathObject ... mobjs) {
        this.scene.playAnimation(Commands.highlight(this.defaultRunTimeHighlight, mobjs));
    }

    public void highlight(double runTime, MathObject ... mobjs) {
        this.scene.playAnimation(Commands.highlight(runTime, mobjs));
    }

    public void growIn(double runTime, double angle, MathObject ... mobjs) {
        this.scene.playAnimation(Commands.growIn(runTime, angle, mobjs));
    }

    public void growIn(double runTime, MathObject ... mobjs) {
        this.scene.playAnimation(Commands.growIn(runTime, mobjs));
    }

    public void growIn(MathObject ... mobjs) {
        this.growIn(this.defaultRunTimeGrowIn, mobjs);
    }

    public void shrinkOut(double runTime, double angle, MathObject ... mobjs) {
        this.scene.playAnimation(Commands.shrinkOut(runTime, angle, mobjs));
    }

    public void shrinkOut(double runTime, MathObject ... mobjs) {
        this.scene.playAnimation(Commands.shrinkOut(runTime, 0.0, mobjs));
    }

    public void shrinkOut(MathObject mobj) {
        this.shrinkOut(this.defaultRunTimeShrinkOut, mobj);
    }

    public void showCreation(double runtime, MathObject ... mobjects) {
        ArrayList<Animation> anims = new ArrayList<Animation>();
        for (MathObject obj : mobjects) {
            anims.add(new ShowCreation(runtime, obj));
        }
        this.scene.playAnimation(anims);
    }

    public void showCreation(MathObject ... mobjs) {
        this.showCreation(this.defaultRunTimeshowCreation, mobjs);
    }

    public void setColor(double runtime, PaintStyle drawColor, PaintStyle fillColor, MathObject ... mobjects) {
        this.scene.playAnimation(Commands.setColor(runtime, drawColor, fillColor, mobjects));
    }

    public void setStyle(double runtime, String styleName, MathObject ... mobjects) {
        this.scene.playAnimation(Commands.setStyle(runtime, styleName, mobjects));
    }

    public void stackTo(double runtime, MathObject dst, Anchor.Type type, double gap, MathObject ... mobjects) {
        this.scene.playAnimation(Commands.stackTo(runtime, dst, type, gap, mobjects));
    }

    public void contourHighlight(MathObject ... objs) {
        this.scene.playAnimation(ContourHighlight.make(this.defaultRunTimeHighlight, objs));
    }

    public void twistAndScale(MathObject ... objs) {
        this.scene.playAnimation(Commands.twistAndScale(this.defaultRunTimefadeIn, objs));
    }
}

