/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations;

import com.jmathanim.Animations.Animation;
import com.jmathanim.Animations.AnimationEffect;
import com.jmathanim.Utils.Vec;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;
import java.util.HashMap;

public abstract class ShiftAnimation
extends Animation {
    private double delayPercentage;
    private final MathObject[] mathObjects;
    private final HashMap<MathObject, Vec> shiftVectors;
    private final HashMap<MathObject, AnimationEffect> effects;
    private final HashMap<MathObject, Double> beginningTimes;
    private final HashMap<MathObject, Double> rotationAngles;

    public ShiftAnimation(double runTime, MathObject[] mathObjects) {
        super(runTime);
        this.mathObjects = mathObjects;
        this.shiftVectors = new HashMap();
        this.effects = new HashMap();
        this.beginningTimes = new HashMap();
        this.rotationAngles = new HashMap();
        this.delayPercentage = 0.0;
        for (MathObject obj : mathObjects) {
            this.effects.put(obj, new AnimationEffect());
            this.rotationAngles.put(obj, 0.0);
        }
    }

    @Override
    public void initialize(JMathAnimScene scene) {
        super.initialize(scene);
        this.saveStates(this.mathObjects);
        this.addObjectsToscene(this.mathObjects);
        int size = this.mathObjects.length;
        int k = 0;
        if (size > 1) {
            for (MathObject obj : this.mathObjects) {
                this.beginningTimes.put(obj, (double)k * this.delayPercentage / (double)(size - 1));
                ++k;
            }
        }
    }

    public double allocateToNewTime(double a, double b, double t) {
        if (t < a) {
            return 0.0;
        }
        if (t > b) {
            return 1.0;
        }
        return (t - a) / (b - a);
    }

    @Override
    public void doAnim(double t) {
        int size = this.mathObjects.length;
        double lt = this.getLambda().applyAsDouble(t);
        this.restoreStates(this.mathObjects);
        double b = 1.0 - this.delayPercentage;
        for (MathObject obj : this.mathObjects) {
            Vec v = this.shiftVectors.get(obj);
            if (size > 1 && this.delayPercentage > 0.0) {
                double a = this.beginningTimes.get(obj);
                double newT = this.allocateToNewTime(a, a + b, t);
                lt = this.getLambda().applyAsDouble(newT);
            }
            obj.shift(v.mult(lt));
            this.effects.get(obj).applyAnimationEffects(lt, obj);
            if (this.rotationAngles.get(obj) == 0.0) continue;
            obj.rotate(this.rotationAngles.get(obj) * lt);
        }
    }

    @Override
    public void finishAnimation() {
        super.finishAnimation();
        this.doAnim(1.0);
    }

    public Vec getShiftVector(MathObject obj) {
        return this.shiftVectors.get(obj);
    }

    public <T extends ShiftAnimation> T setShiftVector(MathObject obj, Vec shiftVector) {
        this.shiftVectors.put(obj, shiftVector);
        if (!this.effects.containsKey(obj)) {
            this.effects.put(obj, new AnimationEffect());
        }
        Point c = obj.getCenter();
        this.effects.get(obj).prepareJumpPath(c, (Point)c.copy().shift(shiftVector), obj);
        return (T)this;
    }

    public double getJumpHeight(MathObject obj) {
        return this.effects.get((Object)obj).jumpHeight;
    }

    public double getNumTurns(MathObject obj) {
        return this.effects.get((Object)obj).numTurns.intValue();
    }

    public double getScaleEffect(MathObject obj) {
        return this.effects.get((Object)obj).scaleEffect;
    }

    public <T extends ShiftAnimation> T addJumpEffect(MathObject obj, double jumpHeight, AnimationEffect.JumpType jumpType) {
        if (!this.effects.containsKey(obj)) {
            this.effects.put(obj, new AnimationEffect());
        }
        this.effects.get(obj).addJumpEffect(jumpHeight, jumpType);
        return (T)this;
    }

    public <T extends ShiftAnimation> T addJumpEffect(MathObject obj, double jumpHeight) {
        this.addJumpEffect(obj, jumpHeight, AnimationEffect.JumpType.PARABOLICAL);
        return (T)this;
    }

    public <T extends ShiftAnimation> T addJumpEffect(double jumpHeight) {
        for (MathObject obj : this.mathObjects) {
            this.addJumpEffect(obj, jumpHeight);
        }
        return (T)this;
    }

    public <T extends ShiftAnimation> T addJumpEffect(double jumpHeight, AnimationEffect.JumpType jumpType) {
        for (MathObject obj : this.mathObjects) {
            this.addJumpEffect(obj, jumpHeight, jumpType);
        }
        return (T)this;
    }

    public <T extends ShiftAnimation> T addScaleEffect(MathObject obj, double scaleEffect) {
        this.effects.get(obj).addScaleEffect(scaleEffect);
        return (T)this;
    }

    public <T extends ShiftAnimation> T addScaleEffect(double scaleEffect) {
        for (MathObject obj : this.mathObjects) {
            this.addScaleEffect(obj, scaleEffect);
        }
        return (T)this;
    }

    public <T extends ShiftAnimation> T addRotationEffect(MathObject obj, int numTurns) {
        this.effects.get(obj).addRotationEffect(numTurns);
        return (T)this;
    }

    public <T extends ShiftAnimation> T addRotationEffect(int numTurns) {
        for (MathObject obj : this.mathObjects) {
            this.addRotationEffect(obj, numTurns);
        }
        return (T)this;
    }

    public <T extends ShiftAnimation> T addRotationEffectByAngle(double rotationAngle) {
        for (MathObject obj : this.mathObjects) {
            this.addRotationEffectByAngle(obj, rotationAngle);
        }
        return (T)this;
    }

    public <T extends ShiftAnimation> T addRotationEffectByAngle(MathObject obj, double rotationAngle) {
        this.rotationAngles.put(obj, rotationAngle);
        return (T)this;
    }

    public <T extends ShiftAnimation> T addAlphaScaleEffect(MathObject obj, double alphaScale) {
        this.effects.get(obj).addAlphaEffect(alphaScale);
        return (T)this;
    }

    public <T extends ShiftAnimation> T addDelayEffect(double delayPercentage) {
        if (delayPercentage <= 0.0 || delayPercentage >= 1.0) {
            return (T)this;
        }
        this.delayPercentage = delayPercentage;
        return (T)this;
    }
}

