/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations;

import com.jmathanim.Animations.Animation;
import com.jmathanim.Animations.Strategies.ShowCreation.AbstractCreationStrategy;
import com.jmathanim.Animations.Strategies.ShowCreation.ArrowCreationAnimation;
import com.jmathanim.Animations.Strategies.ShowCreation.AxesCreationAnimation;
import com.jmathanim.Animations.Strategies.ShowCreation.CreationStrategy;
import com.jmathanim.Animations.Strategies.ShowCreation.FirstDrawThenFillAnimation;
import com.jmathanim.Animations.Strategies.ShowCreation.GroupCreationAnimation;
import com.jmathanim.Animations.Strategies.ShowCreation.SimpleShapeCreationAnimation;
import com.jmathanim.Constructible.Constructible;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.Arrow2D;
import com.jmathanim.mathobjects.Axes.Axes;
import com.jmathanim.mathobjects.CanonicalJMPath;
import com.jmathanim.mathobjects.Delimiters.Delimiter;
import com.jmathanim.mathobjects.Line;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MathObjectGroup;
import com.jmathanim.mathobjects.MultiShapeObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.SVGMathObject;
import com.jmathanim.mathobjects.Shape;
import com.jmathanim.mathobjects.Text.LaTeXMathObject;
import java.util.ArrayList;
import java.util.function.DoubleUnaryOperator;

public class ShowCreation
extends Animation {
    protected final Point[] pencilPosition;
    MathObject mobj;
    CanonicalJMPath canonPath;
    private Animation creationStrategy;
    private ShowCreationStrategy strategyType = ShowCreationStrategy.NONE;
    private final ArrayList<MathObject> removeThisAtTheEnd;
    private final ArrayList<MathObject> addThisAtTheEnd;

    public static ShowCreation make(double runtime, MathObject mobj) {
        return new ShowCreation(runtime, mobj);
    }

    public ShowCreation(double runtime, MathObject mobj) {
        super(runtime);
        this.setDebugName("showCreation");
        this.mobj = mobj;
        this.addThisAtTheEnd = new ArrayList();
        this.removeThisAtTheEnd = new ArrayList();
        if (mobj instanceof Constructible) {
            this.mobj = ((Constructible)mobj).getMathObject();
            this.removeThisAtTheEnd.add(this.mobj);
            this.addThisAtTheEnd.add(mobj);
        }
        this.pencilPosition = new Point[]{Point.origin(), Point.origin()};
    }

    @Override
    public void initialize(JMathAnimScene scene) {
        super.initialize(scene);
        try {
            if (this.strategyType == ShowCreationStrategy.NONE) {
                this.determineCreationStrategy(this.mobj);
            }
            this.createStrategy();
            this.creationStrategy.setLambda(this.lambda);
            this.creationStrategy.setAddObjectsToScene(this.isShouldAddObjectsToScene());
            this.creationStrategy.setShouldInterpolateStyles(this.isShouldInterpolateStyles());
            this.creationStrategy.setUseObjectState(this.isUseObjectState());
            this.creationStrategy.initialize(scene);
        }
        catch (ClassCastException | NullPointerException e) {
            JMathAnimScene.logger.error("Couldn't create ShowCreation strategy for " + this.mobj.getClass().getCanonicalName() + ". Animation will not be done. (" + e.toString() + ")");
        }
    }

    @Override
    public void doAnim(double t) {
        this.creationStrategy.doAnim(t);
    }

    @Override
    public boolean processAnimation() {
        if (this.creationStrategy != null) {
            boolean ret = this.creationStrategy.processAnimation();
            try {
                if (this.creationStrategy instanceof CreationStrategy) {
                    CreationStrategy cs = (CreationStrategy)((Object)this.creationStrategy);
                    this.pencilPosition[0].copyFrom(cs.getPencilPosition()[0]);
                    this.pencilPosition[1].copyFrom(cs.getPencilPosition()[1]);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return ret;
        }
        return true;
    }

    @Override
    public void finishAnimation() {
        super.finishAnimation();
        if (this.creationStrategy != null) {
            this.creationStrategy.finishAnimation();
        }
        this.removeObjectsFromScene(this.removeThisAtTheEnd);
        this.addObjectsToscene(this.addThisAtTheEnd);
    }

    private void determineCreationStrategy(MathObject mobj) {
        if (mobj instanceof Axes) {
            this.strategyType = ShowCreationStrategy.AXES_CREATION;
            return;
        }
        if (mobj instanceof MathObjectGroup) {
            this.strategyType = ShowCreationStrategy.GROUP_CREATION;
            return;
        }
        if (mobj instanceof LaTeXMathObject) {
            this.strategyType = ShowCreationStrategy.LATEX_CREATION;
            return;
        }
        if (mobj instanceof SVGMathObject) {
            this.strategyType = ShowCreationStrategy.FIRST_DRAW_AND_THEN_FILL;
            return;
        }
        if (mobj instanceof Arrow2D) {
            this.strategyType = ShowCreationStrategy.ARROW_CREATION;
            return;
        }
        if (mobj instanceof Delimiter) {
            this.strategyType = ShowCreationStrategy.DELIMITER_CREATION;
            return;
        }
        if (mobj instanceof MultiShapeObject) {
            this.strategyType = ShowCreationStrategy.MULTISHAPE_CREATION;
            return;
        }
        if (mobj instanceof Line) {
            this.strategyType = ShowCreationStrategy.LINE_CREATION;
            return;
        }
        if (mobj instanceof Shape) {
            this.strategyType = ShowCreationStrategy.FIRST_DRAW_AND_THEN_FILL;
        }
    }

    public <T extends ShowCreation> T setStrategy(ShowCreationStrategy strategyType) {
        this.strategyType = strategyType;
        return (T)this;
    }

    private void createStrategy() throws ClassCastException {
        switch (this.strategyType) {
            case GROUP_CREATION: {
                this.creationStrategy = new GroupCreationAnimation(this.runTime, (MathObjectGroup)this.mobj);
                JMathAnimScene.logger.debug("ShowCreation method: GroupCreationStrategy");
                break;
            }
            case LINE_CREATION: {
                Shape lineToCreate = ((Line)this.mobj).toSegment(this.scene.getCamera());
                this.removeThisAtTheEnd.add(lineToCreate);
                this.addThisAtTheEnd.add(this.mobj);
                this.creationStrategy = new SimpleShapeCreationAnimation(this.runTime, lineToCreate);
                JMathAnimScene.logger.debug("ShowCreation method: LineCreationStrategy");
                break;
            }
            case ARROW_CREATION: {
                this.creationStrategy = new ArrowCreationAnimation(this.runTime, (Arrow2D)this.mobj);
                JMathAnimScene.logger.debug("ShowCreation method: ArrowCreationStrategy");
                break;
            }
            case DELIMITER_CREATION: {
                final Delimiter del = (Delimiter)this.mobj;
                this.creationStrategy = new AbstractCreationStrategy(this.runTime){

                    @Override
                    public void initialize(JMathAnimScene scene) {
                        super.initialize(scene);
                        this.addObjectsToscene(del);
                    }

                    @Override
                    public void doAnim(double t) {
                        del.setAmplitudeScale(this.lambda.applyAsDouble(t));
                    }
                };
                JMathAnimScene.logger.debug("ShowCreation method: Delimiter (growIn)");
                break;
            }
            case SIMPLE_SHAPE_CREATION: {
                this.creationStrategy = new SimpleShapeCreationAnimation(this.runTime, (Shape)this.mobj);
                JMathAnimScene.logger.debug("ShowCreation method: SimpleShapeCreationStrategy");
                break;
            }
            case MULTISHAPE_CREATION: {
                MultiShapeObject msh = (MultiShapeObject)this.mobj;
                this.removeThisAtTheEnd.addAll(msh.getShapes());
                this.addThisAtTheEnd.add(this.mobj);
                this.creationStrategy = new FirstDrawThenFillAnimation(this.runTime, msh);
                JMathAnimScene.logger.debug("ShowCreation method: MultiShapeCreationStrategy");
                break;
            }
            case FIRST_DRAW_AND_THEN_FILL: {
                this.creationStrategy = new FirstDrawThenFillAnimation(this.runTime, this.mobj);
                JMathAnimScene.logger.debug("ShowCreation method: FirstDrawThenFillStrategy");
                break;
            }
            case LATEX_CREATION: {
                LaTeXMathObject lat = (LaTeXMathObject)this.mobj;
                this.removeThisAtTheEnd.addAll(lat.getShapes());
                this.addThisAtTheEnd.add(this.mobj);
                this.creationStrategy = new FirstDrawThenFillAnimation(this.runTime, lat);
                JMathAnimScene.logger.debug("ShowCreation method: FirstDrawThenFillStrategy (LaTeXMathObject)");
                break;
            }
            case AXES_CREATION: {
                this.creationStrategy = new AxesCreationAnimation(this.runTime, (Axes)this.mobj);
            }
        }
    }

    public <T extends ShowCreation> T setStrategyType(ShowCreationStrategy strategyType) {
        this.strategyType = strategyType;
        return (T)this;
    }

    public Point[] getPencilPosition() {
        return this.pencilPosition;
    }

    @Override
    public <T extends Animation> T setLambda(DoubleUnaryOperator lambda) {
        super.setLambda(lambda);
        try {
            this.creationStrategy.setLambda(lambda);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return (T)this;
    }

    public static enum ShowCreationStrategy {
        NONE,
        FIRST_DRAW_AND_THEN_FILL,
        SIMPLE_SHAPE_CREATION,
        MULTISHAPE_CREATION,
        LATEX_CREATION,
        LINE_CREATION,
        ARROW_CREATION,
        DELIMITER_CREATION,
        GROUP_CREATION,
        AXES_CREATION;

    }
}

