/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations.Strategies.ShowCreation;

import com.jmathanim.Animations.Animation;
import com.jmathanim.Animations.AnimationGroup;
import com.jmathanim.Animations.Commands;
import com.jmathanim.Animations.Concatenate;
import com.jmathanim.Animations.JoinAnimation;
import com.jmathanim.Animations.Strategies.ShowCreation.AbstractCreationStrategy;
import com.jmathanim.Animations.Strategies.ShowCreation.SimpleShapeCreationAnimation;
import com.jmathanim.Animations.WaitAnimation;
import com.jmathanim.Styling.MODrawProperties;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MathObjectGroup;
import com.jmathanim.mathobjects.MultiShapeObject;
import com.jmathanim.mathobjects.Shape;
import java.util.function.DoubleUnaryOperator;

public class FirstDrawThenFillAnimation
extends AbstractCreationStrategy {
    public static final double PERCENT_DRAWING = 0.6;
    public final double delayPercent = 0.1;
    private final MathObject obj;
    private double timegap;
    private Animation anim;
    private double delayFactor;

    public FirstDrawThenFillAnimation(double runtime, MathObject obj) {
        super(runtime);
        this.obj = obj;
        this.delayFactor = 0.2;
    }

    @Override
    public boolean processAnimation() {
        return this.anim.processAnimation();
    }

    private Animation createAnimation(MathObject obj, double runtime) {
        if (obj instanceof Shape) {
            JoinAnimation join = JoinAnimation.make(runtime, new Animation[0]);
            MODrawProperties mpDst = obj.getMp().copy();
            Shape sh = (Shape)obj;
            double alpha = sh.getMp().getFillColor().getAlpha();
            double percentDrawing = alpha * 0.6 + (1.0 - alpha);
            join.add(new SimpleShapeCreationAnimation(runtime * percentDrawing, sh));
            if (percentDrawing < 1.0) {
                join.add(Commands.setMP(runtime * (1.0 - percentDrawing), mpDst, sh));
            }
            return join;
        }
        if (obj instanceof MultiShapeObject) {
            MultiShapeObject msh = (MultiShapeObject)obj;
            AnimationGroup ag = new AnimationGroup(new Animation[0]);
            for (Shape sh : msh.getShapes()) {
                JoinAnimation con = JoinAnimation.make(runtime, new FirstDrawThenFillAnimation(runtime, sh));
                ag.add(con);
            }
            ag.addDelayEffect(this.delayFactor);
            return ag;
        }
        if (obj instanceof MathObjectGroup) {
            MathObjectGroup mog = (MathObjectGroup)obj;
            double time = runtime * 0.9;
            if (time <= 0.0) {
                JMathAnimScene.logger.error("Time too short for draw-and-fill multishape, please take a higher runtime");
                return null;
            }
            AnimationGroup ag = new AnimationGroup(new Animation[0]);
            double delay = 0.0;
            for (MathObject sh : mog.getObjects()) {
                Concatenate con = new Concatenate();
                con.add(new WaitAnimation(delay));
                con.add(new FirstDrawThenFillAnimation(time, sh));
                ag.add(con);
                delay += 0.1;
            }
            return ag;
        }
        return null;
    }

    @Override
    public void initialize(JMathAnimScene scene) {
        super.initialize(scene);
        this.anim = this.createAnimation(this.obj, this.runTime);
        if (this.anim == null) {
            JMathAnimScene.logger.error("Could'n crate FirstDrawThenFillAnimation for object type " + this.obj.getClass().getCanonicalName() + ". Animation will not be performed");
        }
        this.obj.getMp().getFillColor().setAlpha(0.0);
        this.anim.setLambda(this.lambda);
        this.anim.initialize(scene);
    }

    @Override
    public void doAnim(double t) {
        this.anim.doAnim(t);
    }

    @Override
    public void finishAnimation() {
        super.finishAnimation();
        this.anim.finishAnimation();
    }

    public double getTimegap() {
        return this.timegap;
    }

    public FirstDrawThenFillAnimation setTimegap(double timegap) {
        this.timegap = timegap;
        return this;
    }

    public static FirstDrawThenFillAnimation make(double runtime, MathObject obj) {
        return new FirstDrawThenFillAnimation(runtime, obj);
    }

    public FirstDrawThenFillAnimation setDelayEffect(double delay) {
        this.delayFactor = delay;
        return this;
    }

    @Override
    public <T extends Animation> T setLambda(DoubleUnaryOperator lambda) {
        super.setLambda(lambda);
        try {
            this.anim.setLambda(lambda);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return (T)this;
    }
}

