/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations.Strategies.Transform;

import com.jmathanim.Animations.AnimationWithEffects;
import com.jmathanim.Animations.Commands;
import com.jmathanim.Animations.Strategies.Transform.TransformStrategy;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.Arrow2D;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;

public class ArrowTransform
extends TransformStrategy {
    Arrow2D arOrig;
    Arrow2D arDst;
    AnimationWithEffects anim;

    public ArrowTransform(double runTime, Arrow2D arOrig, Arrow2D arDst) {
        super(runTime);
        this.arOrig = arOrig;
        this.arDst = arDst;
    }

    @Override
    public void initialize(JMathAnimScene scene) {
        super.initialize(scene);
        Point a = this.arOrig.getStart().copy();
        Point b = this.arOrig.getEnd().copy();
        Point c = this.arDst.getStart().copy();
        Point d = this.arDst.getEnd().copy();
        this.anim = Commands.homothecy(this.runTime, a, b, c, d, this.arOrig);
        this.copyEffectParametersTo(this.anim);
        this.copyAnimationParametersTo(this.anim);
        this.anim.initialize(scene);
    }

    @Override
    public boolean processAnimation() {
        super.processAnimation();
        return this.anim.processAnimation();
    }

    @Override
    public void doAnim(double t) {
    }

    @Override
    public void finishAnimation() {
        super.finishAnimation();
        this.removeObjectsFromScene(this.arOrig);
        this.addObjectsToscene(this.arDst);
    }

    @Override
    public MathObject getIntermediateTransformedObject() {
        return this.arOrig;
    }
}

