/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations.Strategies.Transform;

import com.jmathanim.Animations.Animation;
import com.jmathanim.Animations.AnimationGroup;
import com.jmathanim.Animations.AnimationWithEffects;
import com.jmathanim.Animations.Commands;
import com.jmathanim.Animations.Strategies.Transform.TransformStrategy;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;

public class GeneralAffineTransformAnimation
extends TransformStrategy {
    private AnimationWithEffects affine;
    private AnimationGroup anim;
    private final Shape mobjDestiny;
    private final Shape mobjTransformed;

    public GeneralAffineTransformAnimation(double runTime, Shape objTr, Shape objDst) {
        super(runTime);
        this.mobjTransformed = objTr;
        this.mobjDestiny = objDst;
    }

    @Override
    public void initialize(JMathAnimScene scene) {
        super.initialize(scene);
        Point a = this.mobjTransformed.getPoint(0);
        Point b = this.mobjTransformed.getPoint(1);
        Point c = this.mobjTransformed.getPoint(2);
        Point d = this.mobjDestiny.getPoint(0);
        Point e = this.mobjDestiny.getPoint(1);
        Point f = this.mobjDestiny.getPoint(2);
        this.anim = new AnimationGroup(new Animation[0]);
        this.affine = Commands.affineTransform(this.runTime, a, b, c, d, e, f, this.mobjTransformed);
        this.affine.setUseObjectState(this.isUseObjectState());
        this.anim.add(this.affine);
        if (this.isShouldInterpolateStyles().booleanValue()) {
            this.anim.add(new Animation[]{Commands.setMP(this.runTime, this.mobjDestiny.getMp().copy(), this.mobjTransformed).setUseObjectState(false)});
        }
        this.copyAnimationParametersTo(this.anim);
        this.copyEffectParametersTo(this.affine);
        this.affine.prepareJumpPath(this.mobjTransformed.getCenter(), this.mobjDestiny.getCenter(), this.mobjTransformed);
        this.anim.initialize(scene);
    }

    @Override
    public boolean processAnimation() {
        super.processAnimation();
        return this.anim.processAnimation();
    }

    @Override
    public void doAnim(double t) {
    }

    @Override
    public void finishAnimation() {
        super.finishAnimation();
        this.anim.finishAnimation();
    }

    @Override
    public MathObject getIntermediateTransformedObject() {
        return this.mobjTransformed;
    }
}

