/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations.Strategies.Transform;

import com.jmathanim.Animations.Animation;
import com.jmathanim.Animations.AnimationGroup;
import com.jmathanim.Animations.AnimationWithEffects;
import com.jmathanim.Animations.Commands;
import com.jmathanim.Animations.Strategies.Transform.TransformStrategy;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;

public class HomothecyTransformAnimation
extends TransformStrategy {
    AnimationGroup anim;
    private AnimationWithEffects homothecy;
    private final Shape mobjTransformed;
    private final Shape mobjDestiny;

    public HomothecyTransformAnimation(double runtime, Shape mobjTransformed, Shape mobjDestiny) {
        super(runtime);
        this.mobjTransformed = mobjTransformed;
        this.mobjDestiny = mobjDestiny;
    }

    @Override
    public void initialize(JMathAnimScene scene) {
        super.initialize(scene);
        Point a = this.mobjTransformed.getPoint(0);
        Point b = this.mobjTransformed.getPoint(1);
        Point c = this.mobjDestiny.getPoint(0);
        Point d = this.mobjDestiny.getPoint(1);
        this.anim = new AnimationGroup(new Animation[0]);
        this.homothecy = Commands.homothecy(this.runTime, a, b, c, d, this.mobjTransformed);
        this.homothecy.setUseObjectState(this.isUseObjectState());
        this.anim.add(this.homothecy);
        if (this.isShouldInterpolateStyles().booleanValue()) {
            this.anim.add(new Animation[]{Commands.setMP(this.runTime, this.mobjDestiny.getMp().copy(), this.mobjTransformed).setUseObjectState(false)});
        }
        this.copyAnimationParametersTo(this.anim);
        this.copyEffectParametersTo(this.anim);
        this.anim.initialize(scene);
    }

    @Override
    public boolean processAnimation() {
        super.processAnimation();
        boolean value = this.anim.processAnimation();
        return value;
    }

    @Override
    public void doAnim(double t) {
    }

    @Override
    public void finishAnimation() {
        super.finishAnimation();
        this.removeObjectsFromScene(this.mobjTransformed);
        this.anim.finishAnimation();
    }

    @Override
    public MathObject getIntermediateTransformedObject() {
        return this.mobjTransformed;
    }
}

