/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations.Strategies.Transform;

import com.jmathanim.Animations.Animation;
import com.jmathanim.Animations.AnimationGroup;
import com.jmathanim.Animations.Strategies.Transform.TransformStrategy;
import com.jmathanim.Animations.Transform;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MultiShapeObject;

public class MultiShapeTransform
extends TransformStrategy {
    private MultiShapeObject dst;
    private MultiShapeObject tr;
    private final MultiShapeObject mobjTransformed;
    private final MultiShapeObject mobjDestiny;
    private final AnimationGroup anim;

    public MultiShapeTransform(double runtime, MultiShapeObject mobjTransformed, MultiShapeObject mobjDestiny) {
        super(runtime);
        this.mobjDestiny = mobjDestiny;
        this.mobjTransformed = mobjTransformed;
        this.anim = new AnimationGroup(new Animation[0]);
    }

    @Override
    public boolean processAnimation() {
        return this.anim.processAnimation();
    }

    @Override
    public void initialize(JMathAnimScene scene) {
        int i;
        super.initialize(scene);
        this.tr = new MultiShapeObject();
        this.dst = new MultiShapeObject();
        int sizeTr = this.mobjTransformed.size();
        int sizeDst = this.mobjDestiny.size();
        int numAnims = Math.max(sizeTr, sizeDst);
        if (sizeDst < sizeTr) {
            for (i = 0; i < sizeTr; ++i) {
                this.dst.add(this.mobjDestiny.get(i * sizeDst / sizeTr).copy());
            }
            this.tr = this.mobjTransformed.copy();
        }
        if (sizeTr < sizeDst) {
            for (i = 0; i < sizeDst; ++i) {
                this.tr.add(this.mobjTransformed.get(i * sizeTr / sizeDst).copy());
            }
            this.dst = this.mobjDestiny.copy();
        }
        if (sizeDst == sizeTr) {
            this.dst = this.mobjDestiny.copy();
            this.tr = this.mobjTransformed.copy();
        }
        for (int n = 0; n < numAnims; ++n) {
            Transform transformAnim = new Transform(this.runTime, this.tr.get(n), this.dst.get(n));
            this.copyEffectParametersTo(transformAnim);
            this.anim.add(transformAnim);
        }
        this.anim.initialize(scene);
        this.removeObjectsFromScene(this.mobjTransformed);
    }

    @Override
    public void finishAnimation() {
        super.finishAnimation();
        this.anim.finishAnimation();
        this.removeObjectsFromScene(this.tr, this.dst, this.mobjTransformed);
        this.addObjectsToscene(this.mobjDestiny);
    }

    @Override
    public MathObject getIntermediateTransformedObject() {
        return null;
    }
}

