/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations.Strategies.Transform.Optimizers;

import com.jmathanim.Animations.Strategies.Transform.Optimizers.OptimizePathsStrategy;
import com.jmathanim.mathobjects.JMPath;
import com.jmathanim.mathobjects.JMPathPoint;
import com.jmathanim.mathobjects.Shape;

public class DivideOnSensiblePointsStrategy
implements OptimizePathsStrategy {
    @Override
    public void optimizePaths(Shape sh1, Shape sh2) {
        int n2;
        JMPath pa1 = sh1.getPath();
        JMPath pa2 = sh2.getPath();
        int n1 = pa1.getNumberOfConnectedComponents();
        if (n1 < 2 | (n2 = pa2.getNumberOfConnectedComponents()) > 1) {
            return;
        }
        int numSegments = pa2.size();
        int step = numSegments / n1;
        if (step == 0) {
            return;
        }
        block0: for (int n = n2; n < Math.min(n2, n1); ++n) {
            for (int k = 0; k < pa2.size(); ++k) {
                JMPathPoint jmp = pa2.jmPathPoints.get(k);
                if (jmp.type == JMPathPoint.JMPathPointType.INTERPOLATION_POINT) continue;
                JMPathPoint jmpNext = pa2.jmPathPoints.get(k + 1);
                if (!jmp.isThisSegmentVisible || jmp.isCurved || !jmpNext.isThisSegmentVisible) continue;
                pa2.separate(k);
                continue block0;
            }
        }
    }
}

