/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations.Strategies.Transform.Optimizers;

import com.jmathanim.Animations.Strategies.Transform.Optimizers.OptimizePathsStrategy;
import com.jmathanim.mathobjects.JMPath;
import com.jmathanim.mathobjects.Shape;
import java.util.ArrayList;
import java.util.Collections;

public class SimpleConnectedPathsOptimizationStrategy
implements OptimizePathsStrategy {
    Shape sh1;
    Shape sh2;

    public SimpleConnectedPathsOptimizationStrategy(Shape sh1, Shape sh2) {
        this.sh1 = sh1;
        this.sh2 = sh2;
    }

    @Override
    public void optimizePaths(Shape shape1, Shape shape2) {
        JMPath pa1c = shape1.getPath().copy();
        JMPath pa2 = shape2.getPath();
        int direction = pa1c.getOrientation() * pa2.getOrientation();
        ArrayList<Double> dists = new ArrayList<Double>();
        for (int n = 1; n < pa1c.size(); ++n) {
            pa1c.cyclePoints(1, direction < 0);
            double d = this.SumDistancesBetweenPaths(pa1c, pa2);
            dists.add(d);
        }
        int cycleMin = dists.indexOf(Collections.min(dists)) + 1;
        shape1.getPath().cyclePoints(cycleMin, direction < 0);
    }

    private double SumDistancesBetweenPaths(JMPath pa1, JMPath pa2) {
        double dist = 0.0;
        for (int n = 0; n < pa1.size(); ++n) {
            dist += pa1.jmPathPoints.get((int)n).p.to(pa2.jmPathPoints.get((int)n).p).norm();
        }
        return dist;
    }
}

