/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations.Strategies.Transform;

import com.jmathanim.Animations.Strategies.Transform.Optimizers.DivideOnSensiblePointsStrategy;
import com.jmathanim.Animations.Strategies.Transform.TransformStrategy;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.CanonicalJMPath;
import com.jmathanim.mathobjects.JMPath;
import com.jmathanim.mathobjects.JMPathPoint;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;
import java.util.ArrayList;
import java.util.Comparator;

public class PointInterpolationCanonical
extends TransformStrategy {
    public CanonicalJMPath connectedOrigin;
    public CanonicalJMPath connectedDst;
    public CanonicalJMPath connectedOriginaRawCopy;
    private final ArrayList<Shape> addedAuxiliaryObjectsToScene;
    private final Shape mobjTransformed;
    private final Shape mobjDestiny;
    private final Shape mobjDestinyOrig;
    private Shape originalShapeBaseCopy;
    private static final boolean DEBUG_COLORS = false;
    private final Shape mobjTransformedOrig;

    public PointInterpolationCanonical(double runtime, Shape mobjTransformed, Shape mobjDestiny) {
        super(runtime);
        this.mobjTransformed = mobjTransformed.copy();
        this.mobjTransformedOrig = mobjTransformed;
        this.mobjDestiny = mobjDestiny.copy();
        this.mobjDestinyOrig = mobjDestiny;
        this.addedAuxiliaryObjectsToScene = new ArrayList();
    }

    @Override
    public void initialize(JMathAnimScene scene) {
        super.initialize(scene);
        if (this.mobjTransformed.size() == 0 || this.mobjDestiny.size() == 0) {
            return;
        }
        this.mobjTransformed.getPath().distille();
        this.mobjDestiny.getPath().distille();
        if (this.optimizeStrategy == null) {
            this.optimizeStrategy = new DivideOnSensiblePointsStrategy();
        }
        this.optimizeStrategy.optimizePaths(this.mobjTransformed, this.mobjDestiny);
        this.optimizeStrategy.optimizePaths(this.mobjDestiny, this.mobjTransformed);
        this.originalShapeBaseCopy = this.mobjTransformed.copy();
        this.preparePaths(this.mobjTransformed.getPath(), this.mobjDestiny.getPath());
        this.mobjTransformed.getPath().clear();
        this.mobjTransformed.getPath().addJMPointsFrom(this.connectedOrigin.toJMPath());
        this.addObjectsToscene(this.mobjTransformed);
        this.removeObjectsFromScene(this.mobjTransformedOrig);
        Point origCenter = this.mobjTransformedOrig.getCenter();
        Point dstCenter = this.mobjDestinyOrig.getCenter();
        this.prepareJumpPath(origCenter, dstCenter, this.mobjTransformed);
    }

    @Override
    public void doAnim(double t) {
        double lt = this.lambda.applyAsDouble(t);
        if (this.connectedOrigin.getNumberOfPaths() == 0 || this.connectedDst.getNumberOfPaths() == 0) {
            return;
        }
        for (int numConnected = 0; numConnected < this.connectedDst.getNumberOfPaths(); ++numConnected) {
            JMPath convertedPath = this.connectedOrigin.get(numConnected);
            JMPath fromPath = this.connectedOriginaRawCopy.get(numConnected);
            JMPath toPath = this.connectedDst.get(numConnected);
            for (int n = 0; n < convertedPath.size(); ++n) {
                JMPathPoint interPoint = convertedPath.jmPathPoints.get(n);
                JMPathPoint basePoint = fromPath.jmPathPoints.get(n);
                JMPathPoint dstPoint = toPath.jmPathPoints.get(n);
                interPoint.p.v.x = (1.0 - lt) * basePoint.p.v.x + lt * dstPoint.p.v.x;
                interPoint.p.v.y = (1.0 - lt) * basePoint.p.v.y + lt * dstPoint.p.v.y;
                interPoint.p.v.z = (1.0 - lt) * basePoint.p.v.z + lt * dstPoint.p.v.z;
                interPoint.cpExit.v.x = (1.0 - lt) * basePoint.cpExit.v.x + lt * dstPoint.cpExit.v.x;
                interPoint.cpExit.v.y = (1.0 - lt) * basePoint.cpExit.v.y + lt * dstPoint.cpExit.v.y;
                interPoint.cpExit.v.z = (1.0 - lt) * basePoint.cpExit.v.z + lt * dstPoint.cpExit.v.z;
                interPoint.cpEnter.v.x = (1.0 - lt) * basePoint.cpEnter.v.x + lt * dstPoint.cpEnter.v.x;
                interPoint.cpEnter.v.y = (1.0 - lt) * basePoint.cpEnter.v.y + lt * dstPoint.cpEnter.v.y;
                interPoint.cpEnter.v.z = (1.0 - lt) * basePoint.cpEnter.v.z + lt * dstPoint.cpEnter.v.z;
            }
        }
        if (this.isShouldInterpolateStyles().booleanValue()) {
            this.mobjTransformed.getMp().interpolateFrom(this.originalShapeBaseCopy.getMp(), this.mobjDestiny.getMp(), lt);
        }
        this.applyAnimationEffects(lt, this.mobjTransformed);
    }

    @Override
    public void finishAnimation() {
        super.finishAnimation();
        this.removeObjectsFromScene(this.mobjTransformed);
        for (Shape shapesToRemove : this.addedAuxiliaryObjectsToScene) {
            this.removeObjectsFromScene(shapesToRemove);
        }
        this.addObjectsToscene(this.mobjDestinyOrig);
    }

    private void preparePaths(JMPath pathTransformed, JMPath pathDestiny) {
        this.connectedOrigin = pathTransformed.canonicalForm();
        this.connectedDst = pathDestiny.canonicalForm();
        Comparator comparator = (o1, o2) -> {
            if (o1.getWidth() + o1.getHeight() < o2.getWidth() + o2.getHeight()) {
                return 1;
            }
            return -1;
        };
        this.connectedOrigin.paths.sort(comparator);
        this.connectedDst.paths.sort(comparator);
        if (this.connectedOrigin.getNumberOfPaths() == 0 || this.connectedDst.getNumberOfPaths() == 0) {
            return;
        }
        this.alignNumberOfComponents(this.connectedOrigin, this.connectedDst);
        this.connectedOriginaRawCopy = new CanonicalJMPath();
        for (JMPath p : this.connectedOrigin.getPaths()) {
            this.connectedOriginaRawCopy.add(p.copy());
        }
        for (int numConnected = 0; numConnected < this.connectedDst.getNumberOfPaths(); ++numConnected) {
            JMPath convertedPath = this.connectedOrigin.get(numConnected);
            for (JMPathPoint p : convertedPath.jmPathPoints) {
                p.isCurved = true;
            }
        }
    }

    private void alignNumberOfElements(JMPath path1, JMPath path2) {
        JMPath pathBig;
        JMPath pathSmall;
        if (path1.size() < path2.size()) {
            pathSmall = path1;
            pathBig = path2;
        } else {
            pathBig = path1;
            pathSmall = path2;
        }
        pathSmall.alignPathsToGivenNumberOfElements(pathBig.size());
    }

    private void alignNumberOfComponents(CanonicalJMPath con1, CanonicalJMPath con2) {
        int n;
        CanonicalJMPath conBig;
        CanonicalJMPath conSmall;
        if (con1.getNumberOfPaths() == 0 || con2.getNumberOfPaths() == 0) {
            return;
        }
        if (con1.getNumberOfPaths() < con2.getNumberOfPaths()) {
            conSmall = con1;
            conBig = con2;
        } else {
            conBig = con1;
            conSmall = con2;
        }
        for (n = conSmall.getNumberOfPaths(); n < conBig.getNumberOfPaths(); ++n) {
            int sizePathToAdd = conBig.get(n).size();
            Point p = conSmall.get((int)(n - 1)).getJMPointAt((double)-1.0).p;
            JMPath pa = new JMPath();
            for (int k = 0; k < sizePathToAdd; ++k) {
                JMPathPoint jmp = JMPathPoint.curveTo(p.copy());
                pa.addJMPoint(jmp);
            }
            pa.jmPathPoints.get((int)0).isThisSegmentVisible = false;
            conSmall.add(pa);
        }
        for (n = 0; n < conSmall.getNumberOfPaths(); ++n) {
            this.alignNumberOfElements(conSmall.get(n), conBig.get(n));
        }
    }

    @Override
    public MathObject getIntermediateTransformedObject() {
        return this.mobjTransformed;
    }
}

