/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations.Strategies.Transform;

import com.jmathanim.Animations.Strategies.Transform.Optimizers.SimpleConnectedPathsOptimizationStrategy;
import com.jmathanim.Animations.Strategies.Transform.TransformStrategy;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.JMPath;
import com.jmathanim.mathobjects.JMPathPoint;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;

public class PointInterpolationSimpleShapeTransform
extends TransformStrategy {
    private final Shape mobjTransformed;
    private final Shape mobjDestiny;
    private Shape originalShapeBaseCopy;
    Point origCenter;
    Point dstCenter;

    public PointInterpolationSimpleShapeTransform(double runtime, Shape mobjTransformed, Shape mobjDestiny) {
        super(runtime);
        this.mobjTransformed = mobjTransformed;
        this.mobjDestiny = mobjDestiny;
        this.origCenter = this.mobjTransformed.getCenter();
        this.dstCenter = this.mobjDestiny.getCenter();
    }

    @Override
    public void initialize(JMathAnimScene scene) {
        super.initialize(scene);
        this.mobjTransformed.getPath().distille();
        this.mobjDestiny.getPath().distille();
        if (this.optimizeStrategy == null) {
            this.optimizeStrategy = new SimpleConnectedPathsOptimizationStrategy(this.mobjTransformed, this.mobjDestiny);
        }
        this.alignNumberOfElements(this.mobjTransformed.getPath(), this.mobjDestiny.getPath());
        this.optimizeStrategy.optimizePaths(this.mobjTransformed, this.mobjDestiny);
        this.originalShapeBaseCopy = this.mobjTransformed.copy();
        for (JMPathPoint jmp : this.mobjTransformed.getPath().jmPathPoints) {
            jmp.isCurved = true;
        }
        this.addObjectsToscene(this.mobjTransformed);
        this.prepareJumpPath(this.origCenter, this.dstCenter, this.mobjTransformed);
    }

    @Override
    public void doAnim(double t) {
        double lt = this.lambda.applyAsDouble(t);
        for (int n = 0; n < this.mobjTransformed.getPath().size(); ++n) {
            JMPathPoint interPoint = this.mobjTransformed.get(n);
            JMPathPoint basePoint = this.originalShapeBaseCopy.get(n);
            JMPathPoint dstPoint = this.mobjDestiny.get(n);
            interPoint.p.v.x = (1.0 - lt) * basePoint.p.v.x + lt * dstPoint.p.v.x;
            interPoint.p.v.y = (1.0 - lt) * basePoint.p.v.y + lt * dstPoint.p.v.y;
            interPoint.p.v.z = (1.0 - lt) * basePoint.p.v.z + lt * dstPoint.p.v.z;
            interPoint.cpExit.v.x = (1.0 - lt) * basePoint.cpExit.v.x + lt * dstPoint.cpExit.v.x;
            interPoint.cpExit.v.y = (1.0 - lt) * basePoint.cpExit.v.y + lt * dstPoint.cpExit.v.y;
            interPoint.cpExit.v.z = (1.0 - lt) * basePoint.cpExit.v.z + lt * dstPoint.cpExit.v.z;
            interPoint.cpEnter.v.x = (1.0 - lt) * basePoint.cpEnter.v.x + lt * dstPoint.cpEnter.v.x;
            interPoint.cpEnter.v.y = (1.0 - lt) * basePoint.cpEnter.v.y + lt * dstPoint.cpEnter.v.y;
            interPoint.cpEnter.v.z = (1.0 - lt) * basePoint.cpEnter.v.z + lt * dstPoint.cpEnter.v.z;
        }
        if (this.isShouldInterpolateStyles().booleanValue()) {
            this.mobjTransformed.getMp().interpolateFrom(this.originalShapeBaseCopy.getMp(), this.mobjDestiny.getMp(), lt);
        }
        this.applyAnimationEffects(lt, this.mobjTransformed);
    }

    @Override
    public void finishAnimation() {
        super.finishAnimation();
        for (int n = 0; n < this.mobjTransformed.getPath().size(); ++n) {
            JMPathPoint p1 = this.mobjTransformed.get(n);
            JMPathPoint p2 = this.mobjDestiny.get(n);
            p1.type = p2.type;
            p1.isCurved = p2.isCurved;
            p1.isThisSegmentVisible = p2.isThisSegmentVisible;
            p1.cpExitvBackup = p2.cpExitvBackup;
            p1.cpEntervBackup = p2.cpEntervBackup;
        }
        this.mobjTransformed.getPath().removeInterpolationPoints();
        this.mobjTransformed.getMp().copyFrom(this.mobjDestiny.getMp());
        this.mobjTransformed.absoluteSize = this.mobjDestiny.absoluteSize;
    }

    private void alignNumberOfElements(JMPath path1, JMPath path2) {
        JMPath pathBig;
        JMPath pathSmall;
        if (path1.size() < path2.size()) {
            pathSmall = path1;
            pathBig = path2;
        } else {
            pathBig = path1;
            pathSmall = path2;
        }
        pathSmall.alignPathsToGivenNumberOfElements(pathBig.size());
    }

    @Override
    public MathObject getIntermediateTransformedObject() {
        return this.mobjTransformed;
    }
}

