/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations.Strategies.Transform;

import com.jmathanim.Animations.Strategies.Transform.TransformStrategy;
import com.jmathanim.Styling.MODrawProperties;
import com.jmathanim.Utils.AffineJTransform;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;

public class RotateAndScaleXYTransform
extends TransformStrategy {
    private final Shape mobjDestiny;
    private final Shape mobjTransformed;
    private MODrawProperties mpBase;
    Point A;
    Point B;
    Point C;
    Point D;
    Point E;
    Point F;

    public RotateAndScaleXYTransform(double runtime, Shape mobjTransformed, Shape mobjDestiny) {
        super(runtime);
        this.mobjTransformed = mobjTransformed;
        this.mobjDestiny = mobjDestiny;
    }

    @Override
    public void initialize(JMathAnimScene scene) {
        super.initialize(scene);
        this.mpBase = this.mobjTransformed.getMp().copy();
        this.A = this.mobjTransformed.getPoint(0).copy();
        this.B = this.mobjTransformed.getPoint(1).copy();
        this.C = this.mobjTransformed.getPoint(2).copy();
        this.D = this.mobjDestiny.getPoint(0).copy();
        this.E = this.mobjDestiny.getPoint(1).copy();
        this.F = this.mobjDestiny.getPoint(2).copy();
        this.saveStates(this.mobjTransformed);
        this.addObjectsToscene(this.mobjTransformed);
        AffineJTransform tr = this.createIntermediateTransform(1.0);
        this.prepareJumpPath(this.mobjTransformed.getCenter(), (Point)tr.getTransformedObject(this.mobjTransformed.getCenter()), this.mobjTransformed);
    }

    @Override
    public void doAnim(double t) {
        double lt = this.lambda.applyAsDouble(t);
        this.restoreStates(this.mobjTransformed);
        AffineJTransform tr = this.createIntermediateTransform(lt);
        tr.applyTransform(this.mobjTransformed);
        if (this.isShouldInterpolateStyles().booleanValue()) {
            this.mobjTransformed.getMp().interpolateFrom(this.mpBase, this.mobjDestiny.getMp(), lt);
        }
        this.applyAnimationEffects(lt, this.mobjTransformed);
    }

    public AffineJTransform createIntermediateTransform(double lt) {
        AffineJTransform tr1 = AffineJTransform.createDirect2DHomothecy(this.A, this.B, new Point(0.0, 0.0), new Point(1.0, 0.0), 1.0);
        AffineJTransform tr2 = new AffineJTransform();
        double proportionalHeight = this.F.to(this.E).norm() / this.D.to(this.E).norm() / (this.B.to(this.C).norm() / this.B.to(this.A).norm());
        tr2.setV2Img(0.0, proportionalHeight * lt + (1.0 - lt) * 1.0);
        AffineJTransform tr3 = AffineJTransform.createDirect2DHomothecy(this.A, this.B, this.D, this.E, lt);
        AffineJTransform tr = tr1.compose(tr2).compose(tr1.getInverse()).compose(tr3);
        return tr;
    }

    @Override
    public void finishAnimation() {
        super.finishAnimation();
        this.doAnim(1.0);
    }

    @Override
    public MathObject getIntermediateTransformedObject() {
        return this.mobjTransformed;
    }
}

