/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations;

import com.jmathanim.Animations.AnimationWithEffects;
import com.jmathanim.Animations.Strategies.Transform.ArrowTransform;
import com.jmathanim.Animations.Strategies.Transform.FunctionSimpleInterpolateTransform;
import com.jmathanim.Animations.Strategies.Transform.GeneralAffineTransformAnimation;
import com.jmathanim.Animations.Strategies.Transform.HomothecyTransformAnimation;
import com.jmathanim.Animations.Strategies.Transform.MultiShapeTransform;
import com.jmathanim.Animations.Strategies.Transform.Optimizers.NullOptimizationStrategy;
import com.jmathanim.Animations.Strategies.Transform.PointInterpolationCanonical;
import com.jmathanim.Animations.Strategies.Transform.PointInterpolationSimpleShapeTransform;
import com.jmathanim.Animations.Strategies.Transform.RotateAndScaleXYTransform;
import com.jmathanim.Animations.Strategies.Transform.TransformStrategy;
import com.jmathanim.Animations.TransformStrategyChecker;
import com.jmathanim.Utils.JMathAnimConfig;
import com.jmathanim.jmathanim.JMathAnimScene;
import com.jmathanim.mathobjects.Arrow2D;
import com.jmathanim.mathobjects.FunctionGraph;
import com.jmathanim.mathobjects.Line;
import com.jmathanim.mathobjects.MathObject;
import com.jmathanim.mathobjects.MultiShapeObject;
import com.jmathanim.mathobjects.Shape;

public class Transform
extends AnimationWithEffects {
    private final MathObject mobjDestiny;
    private MathObject mobjTransformed;
    private TransformMethod transformMethod;
    private boolean shouldOptimizePathsFirst;
    private TransformStrategy transformStrategy;

    public static Transform make(double runTime, MathObject ob1, MathObject ob2) {
        return new Transform(runTime, ob1, ob2);
    }

    public Transform(double runTime, MathObject ob1, MathObject ob2) {
        super(runTime);
        this.setDebugName("Transform");
        this.mobjTransformed = ob1;
        this.mobjDestiny = ob2;
        this.transformMethod = null;
        this.shouldOptimizePathsFirst = true;
        this.optimizeStrategy = null;
    }

    @Override
    public void initialize(JMathAnimScene scene) {
        super.initialize(scene);
        if (this.transformMethod == null) {
            this.determineTransformStrategy();
        }
        this.createTransformStrategy();
        if (!this.shouldOptimizePathsFirst) {
            this.transformStrategy.setOptimizationStrategy(new NullOptimizationStrategy());
        } else {
            this.transformStrategy.setOptimizationStrategy(null);
        }
        this.transformStrategy.setLambda(this.lambda);
        this.transformStrategy.setAddObjectsToScene(this.isShouldAddObjectsToScene());
        this.transformStrategy.setUseObjectState(this.isUseObjectState());
        this.transformStrategy.setShouldInterpolateStyles(this.isShouldInterpolateStyles());
        this.transformStrategy.initialize(scene);
    }

    private void determineTransformStrategy() {
        if (this.mobjTransformed instanceof Arrow2D && this.mobjDestiny instanceof Arrow2D) {
            this.transformMethod = TransformMethod.ARROW_TRANSFORM;
            return;
        }
        if (this.mobjTransformed instanceof Line) {
            this.mobjTransformed = ((Line)this.mobjTransformed).toSegment(JMathAnimConfig.getConfig().getCamera(), 2.0);
        }
        if (this.mobjTransformed instanceof Shape && this.mobjDestiny instanceof MultiShapeObject) {
            this.transformMethod = TransformMethod.MULTISHAPE_TRANSFORM;
            return;
        }
        if (this.mobjTransformed instanceof MultiShapeObject && this.mobjDestiny instanceof Shape) {
            this.transformMethod = TransformMethod.MULTISHAPE_TRANSFORM;
            return;
        }
        if (this.mobjTransformed instanceof MultiShapeObject && this.mobjDestiny instanceof MultiShapeObject) {
            this.transformMethod = TransformMethod.MULTISHAPE_TRANSFORM;
            return;
        }
        if (this.mobjTransformed instanceof FunctionGraph && this.mobjDestiny instanceof FunctionGraph) {
            this.transformMethod = TransformMethod.FUNCTION_INTERPOLATION;
            return;
        }
        if (this.mobjTransformed instanceof Shape && this.mobjDestiny instanceof Shape) {
            Shape shTr = (Shape)this.mobjTransformed;
            Shape shDst = (Shape)this.mobjDestiny;
            double epsilon = 1.0E-6;
            if (TransformStrategyChecker.testDirectHomothecyTransform(shTr, shDst, epsilon)) {
                this.transformMethod = TransformMethod.HOMOTHECY_TRANSFORM;
                return;
            }
            if (TransformStrategyChecker.testRotateScaleXYTransform(shTr, shDst, epsilon)) {
                this.transformMethod = TransformMethod.ROTATE_AND_SCALEXY_TRANSFORM;
                return;
            }
            if (TransformStrategyChecker.testGeneralAffineTransform(shTr, shDst, epsilon)) {
                this.transformMethod = TransformMethod.GENERAL_AFFINE_TRANSFORM;
                return;
            }
            if (shTr.getPath().getNumberOfConnectedComponents() == 0 && shDst.getPath().getNumberOfConnectedComponents() == 0) {
                this.transformMethod = TransformMethod.INTERPOLATE_SIMPLE_SHAPES_BY_POINT;
                return;
            }
        }
        this.transformMethod = TransformMethod.INTERPOLATE_POINT_BY_POINT;
    }

    private MultiShapeObject convertToMultiShapeObject(MathObject obj) {
        if (obj instanceof MultiShapeObject) {
            return (MultiShapeObject)obj;
        }
        if (obj instanceof Shape) {
            return new MultiShapeObject((Shape)obj);
        }
        return null;
    }

    private void createTransformStrategy() {
        switch (this.transformMethod) {
            case ARROW_TRANSFORM: {
                this.transformStrategy = new ArrowTransform(this.runTime, (Arrow2D)this.mobjTransformed, (Arrow2D)this.mobjDestiny);
                JMathAnimScene.logger.debug("Transform method: Arrow2D");
                break;
            }
            case MULTISHAPE_TRANSFORM: {
                this.transformStrategy = new MultiShapeTransform(this.runTime, this.convertToMultiShapeObject(this.mobjTransformed), this.convertToMultiShapeObject(this.mobjDestiny));
                JMathAnimScene.logger.debug("Transform method: Multishape");
                break;
            }
            case INTERPOLATE_SIMPLE_SHAPES_BY_POINT: {
                this.transformStrategy = new PointInterpolationSimpleShapeTransform(this.runTime, (Shape)this.mobjTransformed, (Shape)this.mobjDestiny);
                JMathAnimScene.logger.debug("Transform method: Point interpolation between 2 simple closed curves");
                break;
            }
            case INTERPOLATE_POINT_BY_POINT: {
                this.transformStrategy = new PointInterpolationCanonical(this.runTime, (Shape)this.mobjTransformed, (Shape)this.mobjDestiny);
                JMathAnimScene.logger.debug("Transform method: Point interpolation between 2 curves");
                break;
            }
            case HOMOTHECY_TRANSFORM: {
                this.transformStrategy = new HomothecyTransformAnimation(this.runTime, (Shape)this.mobjTransformed, (Shape)this.mobjDestiny);
                JMathAnimScene.logger.debug("Transform method: Homothecy");
                break;
            }
            case ROTATE_AND_SCALEXY_TRANSFORM: {
                this.transformStrategy = new RotateAndScaleXYTransform(this.runTime, (Shape)this.mobjTransformed, (Shape)this.mobjDestiny);
                JMathAnimScene.logger.debug("Transform method: Rotate and Scale XY");
                break;
            }
            case GENERAL_AFFINE_TRANSFORM: {
                this.transformStrategy = new GeneralAffineTransformAnimation(this.runTime, (Shape)this.mobjTransformed, (Shape)this.mobjDestiny);
                JMathAnimScene.logger.debug("Transform method: General affine transform");
                break;
            }
            case FUNCTION_INTERPOLATION: {
                this.transformStrategy = new FunctionSimpleInterpolateTransform(this.runTime, (FunctionGraph)this.mobjTransformed, (FunctionGraph)this.mobjDestiny);
                JMathAnimScene.logger.debug("Transform method: Interpolation of functions");
            }
        }
        if (this.transformStrategy instanceof AnimationWithEffects) {
            TransformStrategy tr = this.transformStrategy;
            this.copyEffectParametersTo(tr);
        } else {
            JMathAnimScene.logger.error("Cannot apply effects to current transform");
        }
    }

    @Override
    public void finishAnimation() {
        super.finishAnimation();
        this.transformStrategy.finishAnimation();
        this.addObjectsToscene(this.mobjDestiny);
        this.removeObjectsFromScene(this.mobjTransformed);
    }

    public Transform setOptimizePaths(boolean shouldOptimizePathsFirst) {
        this.shouldOptimizePathsFirst = shouldOptimizePathsFirst;
        return this;
    }

    public TransformMethod getTransformMethod() {
        return this.transformMethod;
    }

    public Transform setTransformMethod(TransformMethod transformMethod) {
        this.transformMethod = transformMethod;
        return this;
    }

    @Override
    public void doAnim(double t) {
    }

    @Override
    public boolean processAnimation() {
        return this.transformStrategy.processAnimation();
    }

    public MathObject getIntermediateTransformedObject() {
        if (this.transformStrategy != null) {
            return this.transformStrategy.getIntermediateTransformedObject();
        }
        return null;
    }

    public static enum TransformMethod {
        INTERPOLATE_SIMPLE_SHAPES_BY_POINT,
        INTERPOLATE_POINT_BY_POINT,
        HOMOTHECY_TRANSFORM,
        ROTATE_AND_SCALEXY_TRANSFORM,
        FUNCTION_INTERPOLATION,
        MULTISHAPE_TRANSFORM,
        GENERAL_AFFINE_TRANSFORM,
        ARROW_TRANSFORM;

    }
}

