/*
 * Decompiled with CFR 0.152.
 */
package com.jmathanim.Animations;

import com.jmathanim.Utils.AffineJTransform;
import com.jmathanim.mathobjects.Point;
import com.jmathanim.mathobjects.Shape;

public class TransformStrategyChecker {
    private static boolean testTransform(Shape shORig, Shape shDest, AffineJTransform tr, double epsilon) {
        Shape sh = (Shape)tr.getTransformedObject(shORig);
        return sh.getPath().isEquivalentTo(shDest.getPath(), epsilon);
    }

    public static boolean testDirectHomothecyTransform(Shape shORig, Shape shDest, double epsilon) {
        if (!TransformStrategyChecker.checkMinimalPathRequirements(shORig, 2, shDest, 2)) {
            return false;
        }
        Point[] points = TransformStrategyChecker.getIdealPoints(4, shORig, shDest);
        AffineJTransform tr = AffineJTransform.createDirect2DHomothecy(points[0], points[1], points[2], points[3], 1.0);
        return TransformStrategyChecker.testTransform(shORig, shDest, tr, epsilon);
    }

    private static boolean checkMinimalPathRequirements(Shape shORig, int n1, Shape shDest, int n2) {
        boolean mininumPoints = shORig.getPath().size() >= n1 && shDest.getPath().size() >= n2;
        boolean sameSize = shORig.getPath().size() == shDest.getPath().size();
        return mininumPoints & sameSize;
    }

    public static boolean testGeneralAffineTransform(Shape shORig, Shape shDest, double epsilon) {
        if (!TransformStrategyChecker.checkMinimalPathRequirements(shORig, 3, shDest, 3)) {
            return false;
        }
        Point[] p = TransformStrategyChecker.getIdealPoints(6, shORig, shDest);
        AffineJTransform tr = AffineJTransform.createAffineTransformation(p[0], p[1], p[2], p[3], p[4], p[5], 1.0);
        return TransformStrategyChecker.testTransform(shORig, shDest, tr, epsilon);
    }

    public static boolean testRotateScaleXYTransform(Shape shORig, Shape shDest, double epsilon) {
        if (!TransformStrategyChecker.checkMinimalPathRequirements(shORig, 3, shDest, 3)) {
            return false;
        }
        Point[] p = TransformStrategyChecker.getIdealPoints(6, shORig, shDest);
        AffineJTransform tr = AffineJTransform.createRotateScaleXYTransformation(p[0], p[1], p[2], p[3], p[4], p[5], 1.0);
        return TransformStrategyChecker.testTransform(shORig, shDest, tr, epsilon);
    }

    private static Point[] getIdealPoints(int numPoints, Shape shORig, Shape shDest) {
        Point D;
        Point C;
        Point B;
        Point A;
        Point[] points = null;
        if (numPoints == 4) {
            A = shORig.getPoint(0);
            B = shORig.getPoint(1);
            C = shDest.getPoint(0);
            D = shDest.getPoint(1);
            points = new Point[]{A, B, C, D};
        }
        if (numPoints == 6) {
            A = shORig.getPoint(0);
            B = shORig.getPoint(1);
            C = shORig.getPoint(2);
            D = shDest.getPoint(0);
            Point E = shDest.getPoint(1);
            Point F = shDest.getPoint(2);
            points = new Point[]{A, B, C, D, E, F};
        }
        return points;
    }
}

